/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.Collections;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractNoCrashTest
extends MultipleCacheManagersTest {
    protected CacheMode cacheMode;
    protected LockingMode lockingMode;
    protected Boolean useSynchronization;

    protected AbstractNoCrashTest(CacheMode cacheMode, LockingMode lockingMode, Boolean useSynchronization) {
        this.cacheMode = cacheMode;
        this.lockingMode = lockingMode;
        this.useSynchronization = useSynchronization;
    }

    @Override
    protected final void createCacheManagers() {
        assert (this.cacheMode != null && this.lockingMode != null && this.useSynchronization != null);
        ConfigurationBuilder config = AbstractNoCrashTest.getDefaultClusteredCacheConfig(this.cacheMode, true);
        config.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).lockingMode(this.lockingMode).useSynchronization(this.useSynchronization.booleanValue());
        config.clustering().hash().numOwners(3).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        this.createCluster(TestDataSCI.INSTANCE, config, 3);
        this.waitForClusterToForm();
    }

    public void testTxAndLockOnDifferentNodesPut() throws Exception {
        this.testTxAndLockOnDifferentNodes((key, cacheIndex) -> this.cache(cacheIndex).put(key, (Object)"v"), false, false);
    }

    public void testTxAndLockOnDifferentNodesPutAll() throws Exception {
        this.testTxAndLockOnDifferentNodes((key, cacheIndex) -> this.cache(cacheIndex).putAll(Collections.singletonMap(key, "v")), false, false);
    }

    public void testTxAndLockOnDifferentNodesReplace() throws Exception {
        this.testTxAndLockOnDifferentNodes((key, cacheIndex) -> this.cache(cacheIndex).replace(key, (Object)"v"), true, false);
    }

    public void testTxAndLockOnDifferentNodesRemove() throws Exception {
        this.testTxAndLockOnDifferentNodes((key, cacheIndex) -> this.cache(cacheIndex).remove(key), true, true);
    }

    public void testTxAndLockOnSameNode() throws Exception {
        Object k = this.getKeyForCache(0);
        this.tm(0).begin();
        this.cache(0).put(k, (Object)"v");
        EmbeddedTransaction dtm = (EmbeddedTransaction)this.tm(0).getTransaction();
        dtm.runPrepare();
        assert (this.lockManager(0).isLocked(k));
        assert (!this.lockManager(1).isLocked(k));
        assert (!this.lockManager(2).isLocked(k));
        dtm.runCommit(false);
        this.assertNotLocked(k);
        this.assertValue(k, false);
    }

    protected abstract void testTxAndLockOnDifferentNodes(Operation var1, boolean var2, boolean var3) throws Exception;

    protected boolean noPendingTransactions(int i) {
        return this.checkTxCount(i, 0, 0);
    }

    protected void assertValue(Object k, boolean isRemove) {
        this.eventually(() -> this.noPendingTransactions(0) && this.noPendingTransactions(1) && this.noPendingTransactions(2));
        String expected = isRemove ? null : "v";
        Assert.assertEquals((Object)this.cache(0).get(k), (Object)expected);
        this.eventually(() -> this.noPendingTransactions(0) && this.noPendingTransactions(1) && this.noPendingTransactions(2));
        Assert.assertEquals((Object)this.cache(1).get(k), (Object)expected);
        Assert.assertEquals((Object)this.cache(2).get(k), (Object)expected);
    }

    protected static interface Operation {
        public void perform(Object var1, int var2);
    }
}

