/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.commands.statetransfer.StateTransferGetTransactionsCommand;
import org.infinispan.commands.statetransfer.StateTransferStartCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.ControlledRpcManager;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.OriginatorBecomesOwnerLockTest")
@CleanupAfterMethod
public class OriginatorBecomesOwnerLockTest
extends MultipleCacheManagersTest {
    private ConfigurationBuilder configurationBuilder;
    private static final int ORIGINATOR_INDEX = 0;
    private static final int OTHER_INDEX = 1;
    private static final int KILLED_INDEX = 2;
    private Cache<Object, String> originatorCache;
    private Cache<Object, String> killedCache;
    private Cache<Object, String> otherCache;
    private boolean waitForStateTransfer = true;
    private boolean stopCacheOnly = true;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configurationBuilder = OriginatorBecomesOwnerLockTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true, true);
        this.configurationBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.configurationBuilder.clustering().remoteTimeout(30000L, TimeUnit.MILLISECONDS);
        this.configurationBuilder.clustering().hash().l1().disable();
        this.configurationBuilder.locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        this.configurationBuilder.clustering().stateTransfer().fetchInMemoryState(true);
        ControlledConsistentHashFactory.Default consistentHashFactory = new ControlledConsistentHashFactory.Default(new int[][]{{2, 0}, {2, 1}});
        this.configurationBuilder.clustering().hash().numSegments(2).consistentHashFactory((ConsistentHashFactory)consistentHashFactory);
        this.createCluster(TestDataSCI.INSTANCE, this.configurationBuilder, 3);
        this.waitForClusterToForm();
        this.originatorCache = this.cache(0);
        this.killedCache = this.cache(2);
        this.otherCache = this.cache(1);
        consistentHashFactory.setOwnerIndexes(new int[][]{{0, 1}, {1, 0}});
    }

    public void testOriginatorBecomesPrimaryOwnerDuringPrepare() throws Exception {
        MagicKey key = new MagicKey("primary", this.cache(2), this.cache(0));
        this.testLockMigrationDuringPrepare(key);
    }

    public void testOriginatorBecomesBackupOwnerDuringPrepare() throws Exception {
        MagicKey key = new MagicKey("backup", this.cache(2), this.cache(1));
        this.testLockMigrationDuringPrepare(key);
    }

    private void testLockMigrationDuringPrepare(Object key) throws Exception {
        ControlledRpcManager controlledRpcManager = ControlledRpcManager.replaceRpcManager(this.originatorCache);
        controlledRpcManager.excludeCommands(StateTransferStartCommand.class, StateTransferGetTransactionsCommand.class, StateResponseCommand.class);
        EmbeddedTransactionManager tm = this.embeddedTm(0);
        Future<EmbeddedTransaction> f = this.fork(() -> {
            tm.begin();
            this.originatorCache.put(key, (Object)"value");
            EmbeddedTransaction tx = tm.getTransaction();
            boolean success = tx.runPrepare();
            Assert.assertTrue((boolean)success);
            tm.suspend();
            return tx;
        });
        if (!this.originatorCache.getAdvancedCache().getDistributionManager().getCacheTopology().isReadOwner(key)) {
            controlledRpcManager.expectCommand(ClusteredGetCommand.class).send().receiveAll();
        }
        ControlledRpcManager.BlockedRequest<PrepareCommand> blockedPrepare = controlledRpcManager.expectCommand(PrepareCommand.class);
        Thread.sleep(2000L);
        log.trace((Object)"Lock transfer happens here");
        this.killCache();
        log.trace((Object)"Allow the prepare RPC to proceed");
        blockedPrepare.send().receiveAll();
        controlledRpcManager.expectCommand(PrepareCommand.class).send().receiveAll();
        EmbeddedTransaction tx = f.get();
        log.tracef("Prepare finished", new Object[0]);
        this.checkNewTransactionFails(key);
        log.trace((Object)"About to commit existing transactions.");
        controlledRpcManager.excludeCommands(CommitCommand.class, TxCompletionNotificationCommand.class);
        tm.resume((Transaction)tx);
        tx.runCommit(false);
        this.checkValue(key, "value");
        controlledRpcManager.stopBlocking();
    }

    public void testOriginatorBecomesPrimaryOwnerAfterPrepare() throws Exception {
        MagicKey key = new MagicKey("primary", this.cache(2), this.cache(0));
        this.testLockMigrationAfterPrepare(key);
    }

    public void testOriginatorBecomesBackupOwnerAfterPrepare() throws Exception {
        MagicKey key = new MagicKey("backup", this.cache(2), this.cache(1));
        this.testLockMigrationAfterPrepare(key);
    }

    private void testLockMigrationAfterPrepare(Object key) throws Exception {
        EmbeddedTransactionManager tm = this.embeddedTm(0);
        tm.begin();
        this.originatorCache.put(key, (Object)"value");
        EmbeddedTransaction tx = tm.getTransaction();
        boolean prepareSuccess = tx.runPrepare();
        assert (prepareSuccess);
        tm.suspend();
        log.trace((Object)"Lock transfer happens here");
        this.killCache();
        this.checkNewTransactionFails(key);
        log.trace((Object)"About to commit existing transaction.");
        tm.resume((Transaction)tx);
        tx.runCommit(false);
        this.checkValue(key, "value");
    }

    public void testOriginatorBecomesPrimaryOwnerDuringCommit() throws Exception {
        MagicKey key = new MagicKey("primary", this.cache(2), this.cache(0));
        this.testLockMigrationDuringCommit(key);
    }

    public void testOriginatorBecomesBackupOwnerDuringCommit() throws Exception {
        MagicKey key = new MagicKey("backup", this.cache(2), this.cache(1));
        this.testLockMigrationDuringCommit(key);
    }

    private void testLockMigrationDuringCommit(Object key) throws Exception {
        ControlledRpcManager controlledRpcManager = ControlledRpcManager.replaceRpcManager(this.originatorCache);
        controlledRpcManager.excludeCommands(StateTransferStartCommand.class, StateTransferGetTransactionsCommand.class, StateResponseCommand.class);
        EmbeddedTransactionManager tm = this.embeddedTm(0);
        Future<EmbeddedTransaction> f = this.fork(() -> {
            tm.begin();
            this.originatorCache.put(key, (Object)"value");
            EmbeddedTransaction tx = tm.getTransaction();
            boolean success = tx.runPrepare();
            assert (success);
            log.trace((Object)"About to commit transaction.");
            tx.runCommit(false);
            return null;
        });
        if (!this.originatorCache.getAdvancedCache().getDistributionManager().getCacheTopology().isReadOwner(key)) {
            controlledRpcManager.expectCommand(ClusteredGetCommand.class).send().receiveAll();
        }
        controlledRpcManager.expectCommand(PrepareCommand.class).send().receiveAll();
        ControlledRpcManager.BlockedRequest<CommitCommand> blockedCommit = controlledRpcManager.expectCommand(CommitCommand.class);
        log.trace((Object)"Lock transfer happens here");
        this.killCache();
        log.trace((Object)"Allow the commit RPC to proceed");
        blockedCommit.send().receiveAll();
        controlledRpcManager.expectCommand(CommitCommand.class).send().receiveAll();
        controlledRpcManager.expectCommand(TxCompletionNotificationCommand.class).send();
        f.get(30L, TimeUnit.SECONDS);
        log.tracef("Commit finished", new Object[0]);
        this.checkValue(key, "value");
        this.assertNoLocksOrTxs(key, this.originatorCache);
        this.assertNoLocksOrTxs(key, this.otherCache);
        controlledRpcManager.stopBlocking();
    }

    private void assertNoLocksOrTxs(Object key, Cache<Object, String> cache) {
        this.assertEventuallyNotLocked(this.originatorCache, key);
        TransactionTable transactionTable = TestingUtil.extractComponent(cache, TransactionTable.class);
        this.eventuallyEquals(0, () -> ((TransactionTable)transactionTable).getLocalTxCount());
        this.eventuallyEquals(0, () -> ((TransactionTable)transactionTable).getRemoteTxCount());
    }

    private void killCache() {
        if (this.stopCacheOnly) {
            this.killedCache.stop();
        } else {
            this.manager(2).stop();
        }
        if (this.waitForStateTransfer) {
            TestingUtil.waitForNoRebalance(this.originatorCache, this.otherCache);
        }
    }

    private void checkValue(Object key, String value) {
        if (!this.waitForStateTransfer) {
            TestingUtil.waitForNoRebalance(this.originatorCache, this.otherCache);
        }
        log.tracef("Checking key: %s", key);
        InternalCacheEntry d0 = this.advancedCache(0).getDataContainer().get(key);
        InternalCacheEntry d1 = this.advancedCache(1).getDataContainer().get(key);
        Assert.assertEquals((Object)d0.getValue(), (Object)value);
        Assert.assertEquals((Object)d1.getValue(), (Object)value);
    }

    private void checkNewTransactionFails(Object key) throws NotSupportedException, SystemException, HeuristicMixedException, HeuristicRollbackException {
        EmbeddedTransactionManager otherTM = this.embeddedTm(1);
        otherTM.begin();
        this.otherCache.put(key, (Object)"should fail");
        try {
            otherTM.commit();
            Assert.fail((String)"RollbackException should have been thrown here.");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    private EmbeddedTransactionManager embeddedTm(int cacheIndex) {
        return (EmbeddedTransactionManager)this.tm(cacheIndex);
    }
}

