/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.replicated.pessimistic;

import javax.transaction.Transaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.MagicKey;
import org.infinispan.lock.singlelock.AbstractNoCrashTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.replicated.pessimistic.BasicSingleLockRepPessimisticTest")
public class BasicSingleLockRepPessimisticTest
extends AbstractNoCrashTest {
    public BasicSingleLockRepPessimisticTest() {
        super(CacheMode.REPL_SYNC, LockingMode.PESSIMISTIC, false);
    }

    @Override
    protected void testTxAndLockOnDifferentNodes(AbstractNoCrashTest.Operation operation, boolean addFirst, boolean removed) throws Exception {
        MagicKey k = new MagicKey("k", this.cache(0));
        if (addFirst) {
            this.cache(0).put((Object)k, (Object)"v_initial");
        }
        this.assertNotLocked(k);
        this.tm(0).begin();
        operation.perform(k, 0);
        assert (this.lockManager(0).isLocked((Object)k));
        assert (!this.lockManager(1).isLocked((Object)k));
        assert (!this.lockManager(2).isLocked((Object)k));
        this.tm(0).commit();
        this.assertNotLocked(k);
        this.assertValue(k, removed);
    }

    public void testMultipleLocksInSameTx() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.cache(0));
        MagicKey k2 = new MagicKey("k2", this.cache(0));
        this.tm(0).begin();
        this.cache(0).put((Object)k1, (Object)"v");
        this.cache(0).put((Object)k2, (Object)"v");
        assert (this.lockManager(0).isLocked((Object)k1));
        assert (this.lockManager(0).isLocked((Object)k2));
        assert (!this.lockManager(1).isLocked((Object)k1));
        assert (!this.lockManager(1).isLocked((Object)k2));
        assert (!this.lockManager(1).isLocked((Object)k2));
        assert (!this.lockManager(2).isLocked((Object)k2));
        this.tm(0).commit();
        this.assertNotLocked(k1);
        this.assertNotLocked(k2);
        this.assertValue(k1, false);
        this.assertValue(k2, false);
    }

    @Override
    public void testTxAndLockOnSameNode() throws Exception {
        MagicKey k0 = new MagicKey("k0", this.cache(0));
        this.tm(0).begin();
        this.cache(0).put((Object)k0, (Object)"v");
        assert (this.lockManager(0).isLocked((Object)k0));
        assert (!this.lockManager(1).isLocked((Object)k0));
        assert (!this.lockManager(2).isLocked((Object)k0));
        this.tm(0).commit();
        this.assertNotLocked(k0);
        this.assertValue(k0, false);
    }

    public void testSecondTxCannotPrepare1() throws Exception {
        MagicKey k0 = new MagicKey("k0", this.cache(0));
        this.tm(0).begin();
        this.cache(0).put((Object)k0, (Object)"v");
        EmbeddedTransaction dtm = (EmbeddedTransaction)this.tm(0).suspend();
        assert (this.checkTxCount(0, 1, 0));
        assert (this.checkTxCount(1, 0, 0));
        assert (this.checkTxCount(2, 0, 0));
        this.tm(0).begin();
        try {
            this.cache(0).put((Object)k0, (Object)"other");
            assert (false);
        }
        catch (Throwable e) {
            this.tm(0).rollback();
        }
        this.eventually(() -> this.checkTxCount(0, 1, 0) && this.checkTxCount(1, 0, 0) && this.checkTxCount(2, 0, 0));
        this.tm(1).begin();
        try {
            this.cache(1).put((Object)k0, (Object)"other");
            assert (false);
        }
        catch (Throwable e) {
            this.tm(0).rollback();
        }
        this.eventually(() -> this.checkTxCount(0, 1, 0) && this.checkTxCount(1, 0, 0) && this.checkTxCount(2, 0, 0));
        this.tm(0).resume((Transaction)dtm);
        this.tm(0).commit();
        this.assertValue(k0, false);
        this.eventually(() -> this.noPendingTransactions(0) && this.noPendingTransactions(1) && this.noPendingTransactions(2));
    }

    public void testSecondTxCannotPrepare2() throws Exception {
        MagicKey k0 = new MagicKey("k0", this.cache(0));
        this.tm(1).begin();
        this.cache(1).put((Object)k0, (Object)"v");
        EmbeddedTransaction dtm = (EmbeddedTransaction)this.tm(1).suspend();
        assert (this.checkTxCount(0, 0, 1));
        assert (this.checkTxCount(1, 1, 0));
        assert (this.checkTxCount(2, 0, 1));
        this.tm(0).begin();
        try {
            this.cache(0).put((Object)k0, (Object)"other");
            assert (false);
        }
        catch (Throwable e) {
            this.tm(0).rollback();
        }
        this.eventually(() -> this.checkTxCount(0, 0, 1) && this.checkTxCount(1, 1, 0) && this.checkTxCount(2, 0, 1));
        this.tm(1).begin();
        try {
            this.cache(1).put((Object)k0, (Object)"other");
            assert (false);
        }
        catch (Throwable e) {
            this.tm(0).rollback();
        }
        this.eventually(() -> this.checkTxCount(0, 0, 1) && this.checkTxCount(1, 1, 0) && this.checkTxCount(2, 0, 1));
        this.tm(0).resume((Transaction)dtm);
        this.tm(0).commit();
        this.assertValue(k0, false);
        this.eventually(() -> this.noPendingTransactions(0) && this.noPendingTransactions(1) && this.noPendingTransactions(2));
    }
}

