/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="manager.CacheManagerAdminTest", groups={"functional"})
@CleanupAfterMethod
public class CacheManagerAdminTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.globalState().configurationStorage(ConfigurationStorage.VOLATILE);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
    }

    public void testClusterCacheTest() {
        this.waitForClusterToForm();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        Configuration configuration = builder.build();
        Cache cache = ((EmbeddedCacheManagerAdmin)this.manager(0).administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).createCache("a", configuration);
        this.waitForClusterToForm("a");
        AssertJUnit.assertEquals((int)this.cacheManagers.size(), (int)cache.getAdvancedCache().getRpcManager().getMembers().size());
        this.checkConsistencyAcrossCluster("a", configuration);
        this.addClusterEnabledCacheManager();
        this.checkConsistencyAcrossCluster("a", configuration);
        Exceptions.expectException(CacheConfigurationException.class, (String)"ISPN000374: No such template 'nonExistingTemplate' when declaring 'b'", () -> this.manager(0).administration().createCache("b", "nonExistingTemplate"));
        Exceptions.expectException(CacheConfigurationException.class, (String)"ISPN000507: Cache a already exists", () -> this.manager(0).administration().createCache("a", configuration));
        ((EmbeddedCacheManagerAdmin)this.manager(0).administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).getOrCreateCache("a", configuration);
        this.manager(1).administration().removeCache("a");
        this.checkCacheExistenceAcrossCluster("a", false);
        this.addClusterEnabledCacheManager();
        this.checkCacheExistenceAcrossCluster("a", false);
    }

    protected void checkCacheExistenceAcrossCluster(String cacheName, boolean exists) {
        for (EmbeddedCacheManager m : this.cacheManagers) {
            if (exists) {
                AssertJUnit.assertTrue((String)("Cache '" + cacheName + "' should be present on " + m), (boolean)m.cacheExists(cacheName));
                continue;
            }
            AssertJUnit.assertFalse((String)("Cache '" + cacheName + "' should NOT be present on " + m), (boolean)m.cacheExists(cacheName));
        }
    }

    protected void checkConsistencyAcrossCluster(String cacheName, Configuration configuration) {
        for (EmbeddedCacheManager m : this.cacheManagers) {
            Configuration actualConfiguration = m.getCacheConfiguration(cacheName);
            AssertJUnit.assertNotNull((String)("Cache " + cacheName + " missing from " + m), (Object)actualConfiguration);
            AssertJUnit.assertEquals((Object)configuration, (Object)actualConfiguration);
            Cache cache = m.getCache(cacheName);
            AssertJUnit.assertEquals((int)this.cacheManagers.size(), (int)cache.getAdvancedCache().getRpcManager().getMembers().size());
        }
    }
}

