/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.BatchingInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="manager.CacheManagerComponentRegistryTest")
public class CacheManagerComponentRegistryTest
extends AbstractCacheTest {
    private EmbeddedCacheManager cm;

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm);
        this.cm = null;
    }

    public void testForceSharedComponents() {
        ConfigurationBuilder defaultCfg = CacheManagerComponentRegistryTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC);
        defaultCfg.clustering().stateTransfer().fetchInMemoryState(false).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(defaultCfg);
        Cache c = this.cm.getCache();
        ConfigurationBuilder overrides = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        overrides.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.cm.defineConfiguration("transactional", overrides.build());
        Cache transactional = this.cm.getCache("transactional");
        assert (TestingUtil.extractComponent(c, TransactionManager.class) == null);
        assert (TestingUtil.extractComponent(transactional, TransactionManager.class) instanceof EmbeddedTransactionManager);
        assert (TestingUtil.extractComponent(c, Transport.class) != null);
        assert (TestingUtil.extractComponent(transactional, Transport.class) != null);
        assert (TestingUtil.extractComponent(c, Transport.class) == TestingUtil.extractComponent(transactional, Transport.class));
    }

    public void testForceUnsharedComponents() {
        ConfigurationBuilder defaultCfg = CacheManagerComponentRegistryTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC);
        defaultCfg.clustering().stateTransfer().fetchInMemoryState(false);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(defaultCfg);
        Cache c = this.cm.getCache();
        ConfigurationBuilder overrides = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        overrides.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.cm.defineConfiguration("transactional", overrides.build());
        Cache transactional = this.cm.getCache("transactional");
        assert (TestingUtil.extractComponent(c, EvictionManager.class) != null);
        assert (TestingUtil.extractComponent(transactional, EvictionManager.class) != null);
        assert (TestingUtil.extractComponent(c, EvictionManager.class) != TestingUtil.extractComponent(transactional, EvictionManager.class));
    }

    public void testOverridingComponents() {
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(new ConfigurationBuilder());
        Cache c = this.cm.getCache();
        ConfigurationBuilder overrides = new ConfigurationBuilder();
        overrides.invocationBatching().enable();
        this.cm.defineConfiguration("overridden", overrides.build());
        Cache overridden = this.cm.getCache("overridden");
        AsyncInterceptorChain initialChain = c.getAdvancedCache().getAsyncInterceptorChain();
        assert (!initialChain.containsInterceptorType(BatchingInterceptor.class));
        AsyncInterceptorChain overriddenChain = overridden.getAdvancedCache().getAsyncInterceptorChain();
        assert (overriddenChain.containsInterceptorType(BatchingInterceptor.class));
    }
}

