/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.function.SerializableRunnable;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="manager.FailOverClusterExecutorTest")
public class FailOverClusterExecutorTest
extends MultipleCacheManagersTest {
    private static AtomicInteger failureCount = new AtomicInteger();

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = FailOverClusterExecutorTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.waitForClusterToForm();
    }

    @Test
    public void testSimpleFailover() throws InterruptedException, ExecutionException, TimeoutException {
        int failOverAllowed = 2;
        failureCount.set(failOverAllowed);
        CompletableFuture fut = ((EmbeddedCacheManager)this.cacheManagers.get(0)).executor().singleNodeSubmission(failOverAllowed).submit((SerializableRunnable & Serializable)() -> {
            if (failureCount.decrementAndGet() != 0) {
                throw new IllegalArgumentException();
            }
        });
        fut.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((int)0, (int)failureCount.get());
    }

    @Test
    public void testTimeoutOccursWithRetry() {
        CompletableFuture fut = ((EmbeddedCacheManager)this.cacheManagers.get(0)).executor().timeout(10L, TimeUnit.MILLISECONDS).singleNodeSubmission(2).submit((SerializableRunnable & Serializable)() -> TestingUtil.sleepThread(TimeUnit.SECONDS.toMillis(2L)));
        Exceptions.expectExecutionException(org.infinispan.util.concurrent.TimeoutException.class, (Future)fut);
    }
}

