/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.infinispan.manager.AllClusterExecutorTest;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.function.SerializableSupplier;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="manager.SingleClusterExecutorTest")
public class SingleClusterExecutorTest
extends AllClusterExecutorTest {
    static final AtomicInteger atomicInteger = new AtomicInteger();
    private boolean local;

    public SingleClusterExecutorTest() {
        this.atomicIntegerSupplier = (SerializableSupplier & Serializable)() -> atomicInteger;
    }

    SingleClusterExecutorTest executeLocal(boolean local) {
        this.local = local;
        return this;
    }

    @Override
    protected String parameters() {
        return "[" + this.local + "]";
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new SingleClusterExecutorTest().executeLocal(true), new SingleClusterExecutorTest().executeLocal(false)};
    }

    @Override
    ClusterExecutor executor(EmbeddedCacheManager cm) {
        return cm.executor().singleNodeSubmission().filterTargets(a -> this.local == a.equals(cm.getAddress()));
    }

    @Override
    void assertSize(EmbeddedCacheManager[] cms, int receivedSize) {
        AssertJUnit.assertEquals((int)1, (int)receivedSize);
    }

    @Override
    void eventuallyAssertSize(EmbeddedCacheManager[] cms, Supplier<Integer> supplier) {
        this.eventuallyEquals(1, supplier);
    }

    @Override
    void assertContains(EmbeddedCacheManager[] managers, Collection<Address> results) {
        boolean contains = false;
        for (EmbeddedCacheManager manager : managers) {
            if (!results.contains(manager.getAddress())) continue;
            contains = true;
            break;
        }
        AssertJUnit.assertTrue((String)("At least 1 manager from " + Arrays.toString(managers) + " should be in " + results), (boolean)contains);
    }
}

