/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.marshall.Ids;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="marshall.DuplicateIdTest")
public class DuplicateIdTest
extends AbstractInfinispanTest {
    public void testDuplicateMarshallerIds() throws Exception {
        Class<Ids> idHolder = Ids.class;
        HashMap<Integer, HashSet<String>> dupes = new HashMap<Integer, HashSet<String>>();
        for (Field f : idHolder.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !f.getType().equals(Integer.TYPE)) continue;
            int val = (Integer)f.get(null);
            HashSet<String> names = (HashSet<String>)dupes.get(val);
            if (names == null) {
                names = new HashSet<String>();
            }
            names.add(f.getName());
            dupes.put(val, names);
        }
        int largest = 0;
        for (Map.Entry e : dupes.entrySet()) {
            assert (((Set)e.getValue()).size() == 1) : "ID " + e.getKey() + " is duplicated by fields " + e.getValue();
            largest = Math.max(largest, (Integer)e.getKey());
        }
        log.trace((Object)("Next available ID is " + (largest + 1)));
    }
}

