/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import org.infinispan.commons.marshall.ImmutableProtoStreamMarshaller;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.marshall.AnotherUserSCIImpl;
import org.infinispan.marshall.UserSCIImpl;
import org.infinispan.marshall.core.impl.DelegatingUserMarshaller;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.persistence.impl.PersistenceMarshallerImpl;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.ProtostreamUserMarshallerTest")
public class ProtostreamUserMarshallerTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalBuilder.serialization().addContextInitializers(new SerializationContextInitializer[]{new UserSCIImpl(), new AnotherUserSCIImpl()});
        this.createCluster(globalBuilder, new ConfigurationBuilder(), 2);
    }

    @Test(expectedExceptions={MarshallingException.class}, expectedExceptionsMessageRegExp="No marshaller registered for object of Java type org\\.infinispan\\.marshall\\.ProtostreamUserMarshallerTest\\$NonMarshallablePojo : .*")
    public void testMarshallingException() throws Exception {
        PersistenceMarshallerImpl pm = TestingUtil.extractPersistenceMarshaller(this.manager(0));
        pm.objectToBuffer((Object)new NonMarshallablePojo());
    }

    public void testPrimitivesAreMarshallable() throws Exception {
        ArrayList<Object> objectsToTest = new ArrayList<Object>();
        objectsToTest.add("String");
        objectsToTest.add(Integer.MAX_VALUE);
        objectsToTest.add(Long.MAX_VALUE);
        objectsToTest.add(Double.MAX_VALUE);
        objectsToTest.add(Float.valueOf(Float.MAX_VALUE));
        objectsToTest.add(true);
        objectsToTest.add(new byte[0]);
        objectsToTest.add((byte)127);
        objectsToTest.add((short)Short.MAX_VALUE);
        objectsToTest.add(Character.valueOf('c'));
        objectsToTest.add(new Date());
        objectsToTest.add(Instant.now());
        PersistenceMarshallerImpl pm = TestingUtil.extractPersistenceMarshaller(this.manager(0));
        for (Object e : objectsToTest) {
            AssertJUnit.assertTrue((boolean)pm.isMarshallable(e));
            AssertJUnit.assertNotNull((Object)pm.objectToBuffer(e));
        }
    }

    public void testProtostreamMarshallerLoaded() {
        PersistenceMarshallerImpl pm = TestingUtil.extractPersistenceMarshaller(this.manager(0));
        this.testIsMarshallableAndPut((PersistenceMarshaller)pm, new ExampleUserPojo("A Pojo!"), new AnotherExampleUserPojo("And another one!"));
        DelegatingUserMarshaller userMarshaller = (DelegatingUserMarshaller)pm.getUserMarshaller();
        AssertJUnit.assertTrue((boolean)(userMarshaller.getDelegate() instanceof ImmutableProtoStreamMarshaller));
    }

    private void testIsMarshallableAndPut(PersistenceMarshaller pm, Object ... pojos) {
        for (Object o : pojos) {
            AssertJUnit.assertTrue((boolean)pm.isMarshallable(o));
            String key = o.getClass().getSimpleName();
            this.cache(0).put((Object)key, o);
            AssertJUnit.assertNotNull((Object)this.cache(0).get((Object)key));
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={AnotherExampleUserPojo.class}, schemaFileName="test.core.protostream-another-user-marshall.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.marshall", service=false)
    static interface AnotherUserSCI
    extends SerializationContextInitializer {
    }

    @AutoProtoSchemaBuilder(includeClasses={ExampleUserPojo.class}, schemaFileName="test.core.protostream-user-marshall.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.marshall", service=false)
    static interface UserSCI
    extends SerializationContextInitializer {
    }

    static class NonMarshallablePojo {
        int x;

        NonMarshallablePojo() {
        }
    }

    static class AnotherExampleUserPojo {
        @ProtoField(value=1)
        final String anotherString;

        @ProtoFactory
        AnotherExampleUserPojo(String anotherString) {
            this.anotherString = anotherString;
        }
    }

    static class ExampleUserPojo {
        @ProtoField(value=1)
        final String someString;

        @ProtoFactory
        ExampleUserPojo(String someString) {
            this.someString = someString;
        }
    }
}

