/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.ServiceLoadSerializationContextInitializerTest")
public class ServiceLoadSerializationContextInitializerTest
extends AbstractInfinispanTest {
    public void testSCILoaded() throws Exception {
        try (EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(true);){
            SerializationContextRegistry registry = TestingUtil.extractGlobalComponent((CacheContainer)cm, SerializationContextRegistry.class);
            AssertJUnit.assertTrue((boolean)registry.getUserCtx().canMarshall(ServiceLoadedClass.class));
            AssertJUnit.assertFalse((boolean)registry.getGlobalCtx().canMarshall(ServiceLoadedClass.class));
            AssertJUnit.assertFalse((boolean)registry.getPersistenceCtx().canMarshall(ServiceLoadedClass.class));
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={ServiceLoadedClass.class}, schemaFileName="test.core.protostream-service-loaded-class.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.marshall")
    static interface ServiceLoadedSci
    extends SerializationContextInitializer {
    }

    static class ServiceLoadedClass {
        @ProtoField(value=1)
        String field;

        ServiceLoadedClass() {
        }
    }
}

