/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.statetransfer.StateTransferStartCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.marshall.PojoWithSerializeWith;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.FastCopyHashMap;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.VersionAwareMarshallerSCIImpl;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.BrokenMarshallingPojo;
import org.infinispan.test.data.Key;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.UUID;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

@Test(groups={"functional"}, testName="marshall.VersionAwareMarshallerTest")
public class VersionAwareMarshallerTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(VersionAwareMarshallerTest.class);
    protected StreamingMarshaller marshaller;
    private EmbeddedCacheManager cm;
    private final TransactionFactory gtf = new TransactionFactory();

    public VersionAwareMarshallerTest() {
        this.gtf.init(false, false, true, false);
    }

    @BeforeClass
    public void setUp() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(this.globalConfiguration(), builder);
        this.marshaller = TestingUtil.extractGlobalMarshaller(this.cm);
    }

    protected GlobalConfigurationBuilder globalConfiguration() {
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalBuilder.serialization().addAdvancedExternalizer((AdvancedExternalizer)new PojoWithExternalAndInternal.Externalizer());
        globalBuilder.serialization().addAdvancedExternalizer((AdvancedExternalizer)new PojoWithExternalizer.Externalizer());
        globalBuilder.serialization().addAdvancedExternalizer((AdvancedExternalizer)new PojoWithMultiExternalizer.Externalizer());
        globalBuilder.serialization().serialization().addContextInitializer((SerializationContextInitializer)new VersionAwareMarshallerSCIImpl());
        return globalBuilder;
    }

    @AfterClass
    public void tearDown() {
        this.cm.stop();
    }

    public void testJGroupsAddressMarshalling() throws Exception {
        JGroupsAddress address = new JGroupsAddress((Address)UUID.randomUUID());
        this.marshallAndAssertEquality(address);
    }

    public void testGlobalTransactionMarshalling() throws Exception {
        JGroupsAddress jGroupsAddress = new JGroupsAddress((Address)UUID.randomUUID());
        GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)jGroupsAddress, false);
        this.marshallAndAssertEquality(gtx);
    }

    public void testListMarshalling() throws Exception {
        ArrayList<GlobalTransaction> l1 = new ArrayList<GlobalTransaction>();
        LinkedList<GlobalTransaction> l2 = new LinkedList<GlobalTransaction>();
        for (int i = 0; i < 10; ++i) {
            JGroupsAddress jGroupsAddress = new JGroupsAddress((Address)new IpAddress("localhost", 1000 * i));
            GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)jGroupsAddress, false);
            l1.add(gtx);
            l2.add(gtx);
        }
        this.marshallAndAssertEquality(l1);
        this.marshallAndAssertEquality(l2);
    }

    public void testMapMarshalling() throws Exception {
        HashMap<Integer, GlobalTransaction> m1 = new HashMap<Integer, GlobalTransaction>();
        TreeMap<Integer, GlobalTransaction> m2 = new TreeMap<Integer, GlobalTransaction>();
        HashMap m3 = new HashMap();
        FastCopyHashMap m4 = new FastCopyHashMap();
        for (int i = 0; i < 10; ++i) {
            JGroupsAddress jGroupsAddress = new JGroupsAddress((Address)UUID.randomUUID());
            GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)jGroupsAddress, false);
            m1.put(1000 * i, gtx);
            m2.put(1000 * i, gtx);
            m4.put(1000 * i, gtx);
        }
        Map m5 = Immutables.immutableMapWrap(m3);
        this.marshallAndAssertEquality(m1);
        this.marshallAndAssertEquality(m2);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)m4);
        Map m4Read = (Map)this.marshaller.objectFromByteBuffer(bytes);
        for (Map.Entry entry : m4.entrySet()) {
            assert (((GlobalTransaction)m4Read.get(entry.getKey())).equals(entry.getValue())) : "Writen[" + entry.getValue() + "] and read[" + m4Read.get(entry.getKey()) + "] objects should be the same";
        }
        this.marshallAndAssertEquality(m5);
    }

    public void testSetMarshalling() throws Exception {
        HashSet<Integer> s1 = new HashSet<Integer>();
        TreeSet<Integer> s2 = new TreeSet<Integer>();
        for (int i = 0; i < 10; ++i) {
            Integer integ = 1000 * i;
            s1.add(integ);
            s2.add(integ);
        }
        this.marshallAndAssertEquality(s1);
        this.marshallAndAssertEquality(s2);
    }

    public void testSingletonListMarshalling() throws Exception {
        GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)new JGroupsAddress((Address)UUID.randomUUID()), false);
        List<GlobalTransaction> l = Collections.singletonList(gtx);
        this.marshallAndAssertEquality(l);
    }

    public void testImmutableResponseMarshalling() throws Exception {
        this.marshallAndAssertEquality(UnsuccessfulResponse.EMPTY);
        this.marshallAndAssertEquality(UnsureResponse.INSTANCE);
    }

    public void testReplicableCommandsMarshalling() throws Exception {
        ByteString cacheName = ByteString.fromString((String)TestingUtil.getDefaultCacheName(this.cm));
        ClusteredGetCommand c2 = new ClusteredGetCommand((Object)"key", cacheName, Integer.valueOf(0), 0L);
        this.marshallAndAssertEquality((ReplicableCommand)c2);
        GetKeyValueCommand c4 = new GetKeyValueCommand((Object)"key", 0, 0L);
        this.marshallAndAssertEquality((ReplicableCommand)c4);
        PutKeyValueCommand c5 = new PutKeyValueCommand((Object)"k", (Object)"v", false, new EmbeddedMetadata.Builder().build(), 0, 0L, CommandInvocationId.generateId(null));
        this.marshallAndAssertEquality((ReplicableCommand)c5);
        RemoveCommand c6 = new RemoveCommand((Object)"key", null, 0, 0L, CommandInvocationId.generateId(null));
        this.marshallAndAssertEquality((ReplicableCommand)c6);
        InvalidateCommand c7 = new InvalidateCommand(0L, CommandInvocationId.generateId(null), new Object[]{"key1", "key2"});
        this.marshallAndAssertEquality((ReplicableCommand)c7);
        InvalidateL1Command c71 = new InvalidateL1Command(0L, CommandInvocationId.generateId(null), new Object[]{"key1", "key2"});
        this.marshallAndAssertEquality((ReplicableCommand)c71);
        ReplaceCommand c8 = new ReplaceCommand((Object)"key", (Object)"oldvalue", (Object)"newvalue", new EmbeddedMetadata.Builder().build(), 0, 0L, CommandInvocationId.generateId(null));
        this.marshallAndAssertEquality((ReplicableCommand)c8);
        ClearCommand c9 = new ClearCommand();
        this.marshallAndAssertEquality((ReplicableCommand)c9);
        HashMap<Integer, GlobalTransaction> m1 = new HashMap<Integer, GlobalTransaction>();
        for (int i = 0; i < 10; ++i) {
            GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)new JGroupsAddress((Address)UUID.randomUUID()), false);
            m1.put(1000 * i, gtx);
        }
        PutMapCommand c10 = new PutMapCommand(m1, new EmbeddedMetadata.Builder().build(), 0L, CommandInvocationId.generateId(null));
        this.marshallAndAssertEquality((ReplicableCommand)c10);
        JGroupsAddress local = new JGroupsAddress((Address)UUID.randomUUID());
        GlobalTransaction gtx = this.gtf.newGlobalTransaction((org.infinispan.remoting.transport.Address)local, false);
        PrepareCommand c11 = new PrepareCommand(cacheName, gtx, true, new WriteCommand[]{c5, c6, c8, c10});
        this.marshallAndAssertEquality((ReplicableCommand)c11);
        CommitCommand c12 = new CommitCommand(cacheName, gtx);
        this.marshallAndAssertEquality((ReplicableCommand)c12);
        RollbackCommand c13 = new RollbackCommand(cacheName, gtx);
        this.marshallAndAssertEquality((ReplicableCommand)c13);
    }

    public void testStateTransferControlCommand() throws Exception {
        ByteString cacheName = ByteString.fromString((String)TestingUtil.getDefaultCacheName(this.cm));
        ImmortalCacheEntry entry1 = (ImmortalCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), -1L);
        ArrayList<ImmortalCacheEntry> state = new ArrayList<ImmortalCacheEntry>();
        state.add(entry1);
        JGroupsAddress a1 = new JGroupsAddress((Address)UUID.randomUUID());
        JGroupsAddress a2 = new JGroupsAddress((Address)UUID.randomUUID());
        JGroupsAddress a3 = new JGroupsAddress((Address)UUID.randomUUID());
        ArrayList<JGroupsAddress> oldAddresses = new ArrayList<JGroupsAddress>();
        oldAddresses.add(a1);
        oldAddresses.add(a2);
        ArrayList<JGroupsAddress> newAddresses = new ArrayList<JGroupsAddress>();
        newAddresses.add(a1);
        newAddresses.add(a2);
        newAddresses.add(a3);
        StateTransferStartCommand c14 = new StateTransferStartCommand(cacheName, 99, IntSets.mutableEmptySet());
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)c14);
        this.marshaller.objectFromByteBuffer(bytes);
        bytes = this.marshaller.objectToByteBuffer((Object)c14);
        this.marshaller.objectFromByteBuffer(bytes);
        bytes = this.marshaller.objectToByteBuffer((Object)c14);
        this.marshaller.objectFromByteBuffer(bytes);
    }

    public void testInternalCacheEntryMarshalling() throws Exception {
        ImmortalCacheEntry entry1 = (ImmortalCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), -1L);
        this.marshallAndAssertEquality(entry1);
        MortalCacheEntry entry2 = (MortalCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, 200000L, System.currentTimeMillis(), -1L);
        this.marshallAndAssertEquality(entry2);
        TransientCacheEntry entry3 = (TransientCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), 4000000L);
        this.marshallAndAssertEquality(entry3);
        TransientMortalCacheEntry entry4 = (TransientMortalCacheEntry)TestInternalCacheEntryFactory.create("key", "value", System.currentTimeMillis() - 1000L, 200000L, System.currentTimeMillis(), 4000000L);
        this.marshallAndAssertEquality(entry4);
    }

    public void testInternalCacheValueMarshalling() throws Exception {
        ImmortalCacheValue value1 = (ImmortalCacheValue)TestInternalCacheEntryFactory.createValue("value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), -1L);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)value1);
        ImmortalCacheValue rvalue1 = (ImmortalCacheValue)this.marshaller.objectFromByteBuffer(bytes);
        assert (rvalue1.getValue().equals(value1.getValue())) : "Writen[" + rvalue1.getValue() + "] and read[" + value1.getValue() + "] objects should be the same";
        MortalCacheValue value2 = (MortalCacheValue)TestInternalCacheEntryFactory.createValue("value", System.currentTimeMillis() - 1000L, 200000L, System.currentTimeMillis(), -1L);
        bytes = this.marshaller.objectToByteBuffer((Object)value2);
        MortalCacheValue rvalue2 = (MortalCacheValue)this.marshaller.objectFromByteBuffer(bytes);
        assert (rvalue2.getValue().equals(value2.getValue())) : "Writen[" + rvalue2.getValue() + "] and read[" + value2.getValue() + "] objects should be the same";
        TransientCacheValue value3 = (TransientCacheValue)TestInternalCacheEntryFactory.createValue("value", System.currentTimeMillis() - 1000L, -1L, System.currentTimeMillis(), 4000000L);
        bytes = this.marshaller.objectToByteBuffer((Object)value3);
        TransientCacheValue rvalue3 = (TransientCacheValue)this.marshaller.objectFromByteBuffer(bytes);
        assert (rvalue3.getValue().equals(value3.getValue())) : "Writen[" + rvalue3.getValue() + "] and read[" + value3.getValue() + "] objects should be the same";
        TransientMortalCacheValue value4 = (TransientMortalCacheValue)TestInternalCacheEntryFactory.createValue("value", System.currentTimeMillis() - 1000L, 200000L, System.currentTimeMillis(), 4000000L);
        bytes = this.marshaller.objectToByteBuffer((Object)value4);
        TransientMortalCacheValue rvalue4 = (TransientMortalCacheValue)this.marshaller.objectFromByteBuffer(bytes);
        assert (rvalue4.getValue().equals(value4.getValue())) : "Writen[" + rvalue4.getValue() + "] and read[" + value4.getValue() + "] objects should be the same";
    }

    public void testLongPutKeyValueCommand() throws Exception {
        PutKeyValueCommand c = new PutKeyValueCommand((Object)"SESSION_173", (Object)"@TSXMHVROYNOFCJVEUJQGBCENNQDEWSCYSOHECJOHEICBEIGJVTIBB@TVNCWLTQCGTEJ@NBJLTMVGXCHXTSVE@BCRYGWPRVLXOJXBRJDVNBVXPRTRLBMHPOUYQKDEPDSADUAWPFSIOCINPSSFGABDUXRMTMMJMRTGBGBOAMGVMTKUDUAJGCAHCYW@LAXMDSFYOSXJXLUAJGQKPTHUKDOXRWKEFIVRTH@VIMQBGYPKWMS@HPOESTPIJE@OTOTWUWIOBLYKQQPTNGWVLRRCWHNIMWDQNOO@JHHEVYVQEODMWKFKKKSWURVDLXPTFQYIHLIM@GSBFWMDQGDQIJONNEVHGQTLDBRBML@BEWGHOQHHEBRFUQSLB@@CILXEAVQQBTXSITMBXHMHORHLTJF@MKMHQGHTSENWILTAKCCPVSQIPBVRAFSSEXIOVCPDXHUBIBUPBSCGPRECXEPMQHRHDOHIHVBPNDKOVLPCLKAJMNOTSF@SRXYVUEMQRCXVIETXVHOVNGYERBNM@RIMGHC@FNTUXSJSKALGHAFHGTFEANQUMBPUYFDSGLUYRRFDJHCW@JBWOBGMGTITAICRC@TPVCRKRMFPUSRRAHI@XOYKVGPHEBQD@@APEKSBCTBKREWAQGKHTJ@IHJD@YFSRDQPA@HKKELIJGFDYFEXFCOTCQIHKCQBLVDFHMGOWIDOWMVBDSJQOFGOIAPURRHVBGEJWYBUGGVHE@PU@NMQFMYTNYJDWPIADNVNCNYCCCPGODLAO@YYLVITEMNNKIFSDXKORJYWMFGKNYFPUQIC@AIDR@IWXCVALQBDOXRWIBXLKYTWDNHHSCUROAU@HVNENDAOP@RPTRIGLLLUNDQIDXJDDNF@P@PA@FEIBQKSKFQITTHDYGQRJMWPRLQC@NJVNVSKGOGYXPYSQHKPALKLFWNAOSQFTLEPVOII@RPDNRCVRDUMMFIVSWGIASUBMTGQSDGB@TBBYECFBRBGILJFCJ@JIQIQRVJXWIPGNVXKYATSPJTIPGCMCNPOKNEHBNUIAEQFQTYVLGAR@RVWVA@RMPBX@LRLJUEBUWO@PKXNIP@FKIQSVWKNO@FOJWDSIOLXHXJFBQPPVKKP@YKXPOOMBTLXMEHPRLLSFSVGMPXXNBCYVVSPNGMFBJUDCVOVGXPKVNTOFKVJUJOSDHSCOQRXOKBVP@WCUUFGMJAUQ@GRAGXICFCFICBSNASUBPAFRIPUK@OXOCCNOGTTSFVQKBQNB@DWGVEFSGTAXAPLBJ@SYHUNXWXPMR@KPFAJCIXPDURELFYPMUSLTJSQNDHHKJTIWCGNEKJF@CUWYTWLPNHYPHXNOGLSICKEFDULIXXSIGFMCQGURSRTUJDKRXBUUXIDFECMPXQX@CVYLDABEMFKUGBTBNMNBPCKCHWRJKSOGJFXMFYLLPUVUHBCNULEFAXPVKVKQKYCEFRUYPBRBDBDOVYLIQMQBLTUK@PRDCYBOKJGVUADFJFAFFXKJTNAJTHISWOSMVAYLIOGIORQQWFAKNU@KHPM@BYKTFSLSRHBATQTKUWSFAQS@Y@QIKCUWQYTODBRCYYYIAFMDVRURKVYJXHNGVLSQQFCXKLNUPCTEJSWIJUBFELSBUHANELHSIWLVQSSAIJRUEDOHHX@CKEBPOJRLRHEPLENSCDGEWXRTVUCSPFSAJUXDJOIUWFGPKHBVRVDMUUCPUDKRKVAXPSOBOPKPRRLFCKTLH@VGWKERASJYU@JAVWNBJGQOVF@QPSGJVEPAV@NAD@@FQRYPQIOAURILWXCKINPMBNUHPUID@YDQBHWAVDPPWRFKKGWJQTI@@OPSQ@ROUGHFNHCJBDFCHRLRTEMTUBWVCNOPYXKSSQDCXTOLOIIOCXBTPAUYDICFIXPJRB@CHFNXUCXANXYKXAISDSSLJGQOLBYXWHG@@KPARPCKOXAYVPDGRW@LDCRQBNMJREHWDYMXHEXAJQKHBIRAVHJQIVGOIXNINYQMJBXKM@DXESMBHLKHVSFDLVPOSOVMLHPSHQYY@DNMCGGGAJMHPVDLBGJP@EVDGLYBMD@NWHEYTBPIBPUPYOPOJVV@IVJXJMHIWWSIRKUWSR@U@@TDVMG@GRXVLCNEIISEVIVPOMJHKOWMRMITYDUQASWJIKVNYUFQVDT@BHTOMFXVFRKAARLNOGX@ADWCKHOVEMIGBWXINCUXEMVHSJJQDU@INTHDJQPSAQNAYONDBBFYGBTNGUSJHRKLCPHQMNLDHUQJPLLCDVTYLXTHJCBUXCRDY@YI@IQDCLJBBJC@NXGANXFIWPPNFVTDJWQ@@BIYJONOFP@RHTQEYPVHPPUS@UUENSNNF@WVGTSAVKDSQNMHP@VJORGTVWXVBPWKQNRWLSQFSBMXQKWRYMXPAYREXYGONKEWJMBCSLB@KSHXMIWMSBDGQWPDMUGVNMEWKMJKQECIRRVXBPBLGAFTUFHYSHLF@TGYETMDXRFAXVEUBSTGLSMWJMXJWMDPPDAFGNBMTQEMBDLRASMUMU@QTCDCPEGODHESDQVEIQYBJJPFXDLWPUNFAREYCY@YDDSTMKWCANNPXF@@WLMEXRPUNTWNOX@YKFNNTGMXIBBDA@TYLPJFNFHPQKMSNCLBME@FBPOIYNSDFBLHITKIFEFNXXOJAAFMRTGPALOANXF@YPY@RYTVOW@AKNM@C@LJKGBJMUYGGTXRHQCPOLNOGPPS@YSKAJSTQHLRBXUACXJYBLJSEHDNMLLUBSOIHQUI@VUNF@XAVRXUCYNCBDDGUDNVRYP@TPFPKGVNPTEDOTTUUFKCHQ@WWASQXLCBHNRBVSD@NVYT@GJQYSQGYPJO@WSEYDVKCBWANAFUWLDXOQYCYP@BSJFCBTXGKUNWLWUCYL@TNOWGDFHQTWQVYLQBBRQVMGNDBVXEFXTMMVYSHNVTTQAJCHKULOAJUSGJRPHQFCROWE@OMFUVRKGCWED@IAQGRLADOJGQKLCL@FCKTSITGMJRCCMPLOS@ONPQWFUROXYAUJQXIYVDCYBPYHPYCXNCRKRKLATLWWXLBLNOPUJFUJEDOIRKS@MMYPXIJNXPFOQJCHSCBEBGDUQYXQAWEEJDOSINXYLDXUJCQECU@WQSACTDFLGELHPGDFVDXFSSFOSYDLHQFVJESNAVAHKTUPBTPLSFSHYKLEXJXGWESVQQUTUPU@QXRTIDQ@IXBBOYINNHPEMTPRVRNJPQJFACFXUBKXOFHQSPOTLCQ@PLWGEFNKYCYFMKWPFUP@GLHKNMASGIENCACUISTG@YNQCNSOSBKOIXORKSHEOXHSMJJRUICJTCK@PWFRBPLXU@MUEMPFGDLUJEKD@ROUFBLKATXUCHEAQHEYDLCFDIRJSAXTV@CYMPQNMLTMFAHPRBLNSCVFBJMKQLAHWYIOLRMTOY@@RNKTUXHFYUMHGKCCGNEOIOQCISJEHCEVTTWM@TLFRIFDREHFBTTDEJRUNTWAEETGSVDOR@@UQNKFERMBVFJBOAYHPOKMSMRIERDA@JXYSJ@ORER@MBAVWCVGFNA@FRRPQSIIOIUGAJKVQXGINUUKPJPLQRMHPUBETEEIMIBPM@PETR@XD@DOHGRIBVXKLXQWHUFMTWEDYWFWRLPGDS@TANUXGIDTRVXKVCVEXYRKXQCTI@WNSFRAHJJGG@NIPPAAOJXQRTCLBYKDA@FFGHNUIGBFKOQMEDUEFELFLNKPCHA@OXJJRYNPDFSXIFSJYTDMSSBHDPUSQQDAVD@JAAWJDSVTERAJBFEPVRWKMYAPISPWLDPSRE@UMRQLXERTWRDLQVMVCOM@NYPXFLWMWKALMQVNJ@HCTMMIOLRWBJHCYFLMM@IWXPSHRRUNICSSWHOQHUVJE@HKJAADLBTPVLDAKCHRSURJCAXYTMYKHQMWDAWWASUW@HWGBVPTRHJGDWOGHPCNWSXTNKWONQGEKDDWGCKWVSAD@YLCCENMCHALHVDYQW@NQGNCY@M@GGV@RIR@OUS@PQIJMCFEIMGPYBXYR@NSIAUEXT@MOCNWRMLYHUUAFJCCLLRNFGKLPPIIH@BYRME@UJAKIFHOV@ILP@BGXRNJBIBARSOIMTDSHMGPIGRJBGHYRYXPFUHVOOMCQFNLM@CNCBTGO@UKXBOICNVCRGHADYQVAMNSFRONJ@WITET@BSHMQLWYMVGMQJVSJOXOUJDSXYVVBQJSVGREQLIQKWC@BMDNONHXFYPQENSJINQYKHVCTUTG@QQYJKJURDCKJTUQAM@DWNXWRNILYVAAJ@IADBIXKEIHVXLXUVMGQPAQTWJCDMVDVYUDTXQTCYXDPHKBAGMTAMKEM@QNOQJBREXNWFCXNXRPGOGEIR@KQJIGXAWXLTNCX@ID@XNRNYGRF@QPNWEX@XH@XKSXLQTLQPFSHAHXJLHUTNQWFFAJYHBWIFVJELDPSPLRRDPPNXSBYBEREEELIWNVYXOXYJQAIGHALUAWNUSSNMBHBFLRMMTKEKNSINECUGWTDNMROXI@BJJXKSPIIIXOAJBFVSITQDXTODBGKEPJMWK@JOL@SWTCGSHCOPHECTPJFUXIHUOSVMUTNNSLLJDEOMAGIXEAAVILRMOJXVHHPNPUYYODMXYAYGHI@BUB@NLP@KNPCYFRWAFES@WISBACDSPELEVTJEBNRVENSXXEVDVC@RIDIDSBPQIQNNSRPS@HCJ@XPIOFDXHUBCNFQKHMUYLXW@LMFMALHLESSXCOULRWDTJIVKKTLGFE@HKGVKUGMVHWACQOTSVNWBNUUGTMSQEJ@DXJQQYPOWVRQNQKXSLOEAA@@FRDCGCCQWQ@IY@EATGQGQIETPIJHOIQRYWLTGUENQYDNQSBI@IAUDEWDKICHNUGNAIXNICMBK@CJGSASMTFKWOBSI@KULNENWXV@VNFOANM@OJHFVV@IYRMDB@LHSGXIJMMFCGJKTKDXSMY@FHDNY@VSDUORGWVFMVKJXOCCDLSLMHCSXFBTW@RQTFNRDJUIKRD@PWPY", false, new EmbeddedMetadata.Builder().build(), 0, 0L, CommandInvocationId.generateId(null));
        this.marshallAndAssertEquality((ReplicableCommand)c);
    }

    public void testExceptionResponse() throws Exception {
        ExceptionResponse er = new ExceptionResponse((Exception)((Object)new TimeoutException()));
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)er);
        ExceptionResponse rer = (ExceptionResponse)this.marshaller.objectFromByteBuffer(bytes);
        assert (rer.getException().getClass().equals(er.getException().getClass())) : "Writen[" + er.getException().getClass() + "] and read[" + rer.getException().getClass() + "] objects should be the same";
    }

    @Test(expectedExceptions={MarshallingException.class})
    public void testNestedNonMarshallable() throws Exception {
        PutKeyValueCommand cmd = new PutKeyValueCommand((Object)"k", new Object(), false, new EmbeddedMetadata.Builder().build(), 0, 0L, CommandInvocationId.generateId(null));
        this.marshaller.objectToByteBuffer((Object)cmd);
    }

    @Test(expectedExceptions={MarshallingException.class})
    public void testNonMarshallable() throws Exception {
        this.marshaller.objectToByteBuffer(new Object());
    }

    public void testConcurrentHashMap() throws Exception {
        ConcurrentHashMap<Integer, String> map = new ConcurrentHashMap<Integer, String>();
        map.put(1, "v1");
        map.put(2, "v2");
        map.put(3, "v3");
        this.marshallAndAssertEquality(map);
    }

    @Test(expectedExceptions={MarshallingException.class})
    public void testErrorUnmarshalling() throws Exception {
        BrokenMarshallingPojo bmp = new BrokenMarshallingPojo(false);
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)bmp);
        this.marshaller.objectFromByteBuffer(bytes);
    }

    public void testErrorUnmarshallInputStreamAvailable() throws Exception {
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)"23");
        Object o = this.marshaller.objectFromInputStream((InputStream)new ByteArrayInputStream(bytes){

            @Override
            public int available() {
                return 0;
            }
        });
        AssertJUnit.assertEquals((Object)"23", (Object)o);
    }

    public void testFlagMarshalling() throws Exception {
        this.marshallAndAssertEquality(Arrays.asList(Flag.values()));
    }

    public void testSingleFlagMarshalling() throws Exception {
        this.marshallAndAssertEquality(Flag.FORCE_SYNCHRONOUS);
    }

    public void testEnumSetSingleElementMarshalling() throws Exception {
        this.marshallAndAssertEquality(EnumSet.of(Flag.FORCE_SYNCHRONOUS));
    }

    public void testEnumSetMultiElementMarshalling() throws Exception {
        this.marshallAndAssertEquality(EnumSet.of(Flag.FORCE_SYNCHRONOUS, Flag.FORCE_ASYNCHRONOUS));
    }

    public void testIsMarshallableSerializableWithAnnotation() throws Exception {
        PojoWithSerializeWith pojo = new PojoWithSerializeWith(17, "k1");
        AssertJUnit.assertTrue((boolean)this.marshaller.isMarshallable((Object)pojo));
    }

    public void testSerializableWithAnnotation() throws Exception {
        this.marshallAndAssertEquality(new PojoWithSerializeWith(20, "k2"));
    }

    public void testListArray() throws Exception {
        Object[] numbers = new List[]{Arrays.asList(1), Arrays.asList(2)};
        this.marshallAndAssertArrayEquality(numbers);
    }

    public void testByteArray() throws Exception {
        byte[] bytes = new byte[]{1, 2, 3};
        this.marshallAndAssertByteArrayEquality(bytes);
    }

    public void testExternalAndInternalWithOffset() throws Exception {
        PojoWithExternalAndInternal obj = new PojoWithExternalAndInternal(new Human().age(23), "value");
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)obj);
        bytes = this.prependBytes(new byte[]{1, 2, 3}, bytes);
        Object readObj = this.marshaller.objectFromByteBuffer(bytes, 3, bytes.length);
        AssertJUnit.assertEquals((Object)obj, (Object)readObj);
    }

    public void testArrays() throws Exception {
        this.marshallAndAssertArrayEquality(new Object[0]);
        this.marshallAndAssertArrayEquality(new String[]{null, "foo"});
        this.marshallAndAssertArrayEquality(new String[]{"foo", "bar"});
        this.marshallAndAssertArrayEquality(new Object[]{1.2, 3.4});
        this.marshallAndAssertArrayEquality(new Pojo[0]);
        this.marshallAndAssertArrayEquality(new Pojo[]{null});
        this.marshallAndAssertArrayEquality(new Pojo[]{null, null});
        this.marshallAndAssertArrayEquality(new Pojo[]{new Pojo(1, false), new Pojo(2, true)});
        this.marshallAndAssertArrayEquality(new Pojo[]{new Pojo(3, false), null});
        this.marshallAndAssertArrayEquality(new Pojo[]{new Pojo(4, false), new PojoExtended(5, true)});
        this.marshallAndAssertArrayEquality(new I[]{new Pojo(6, false), new Pojo(7, true)});
        this.marshallAndAssertArrayEquality(new I[]{new Pojo(8, false), new PojoExtended(9, true)});
        this.marshallAndAssertArrayEquality(new I[]{new Pojo(10, false), new PojoWithExternalizer(11, false)});
        this.marshallAndAssertArrayEquality(new PojoWithExternalizer[]{new PojoWithExternalizer(12, true), new PojoWithExternalizer(13, false)});
        this.marshallAndAssertArrayEquality(new I[]{new PojoWithExternalizer(14, false), new PojoWithExternalizer(15, true)});
        this.marshallAndAssertArrayEquality(new PojoWithMultiExternalizer[]{new PojoWithMultiExternalizer(16, true), new PojoWithMultiExternalizer(17, false)});
        this.marshallAndAssertArrayEquality(new I[]{new PojoWithMultiExternalizer(18, false), new PojoWithExternalizer(19, true)});
        this.marshallAndAssertArrayEquality(new I[]{new PojoWithMultiExternalizer(20, false), new PojoWithMultiExternalizer(21, true)});
        this.marshallAndAssertArrayEquality(new Object[]{new PojoWithMultiExternalizer(22, false), new PojoWithMultiExternalizer(23, true)});
        this.marshallAndAssertArrayEquality(new Object[]{new PojoWithExternalizer(24, false), new PojoWithExternalizer(25, true)});
        this.marshallAndAssertArrayEquality(new Object[]{new PojoAnnotated(26, false), "foo"});
        this.marshallAndAssertArrayEquality(new Object[]{new PojoAnnotated(27, false), new PojoAnnotated(28, true)});
        this.marshallAndAssertArrayEquality(new PojoAnnotated[]{new PojoAnnotated(27, false), new PojoAnnotated(28, true)});
        this.marshallAndAssertArrayEquality(new PojoAnnotated[]{null, null});
    }

    public void testLongArrays() throws Exception {
        for (int length : new int[]{255, 256, 257, 258, 65791, 65792, 65793, 65794}) {
            Object[] array = new String[length];
            this.marshallAndAssertArrayEquality(array);
            Arrays.fill(array, "a");
            this.marshallAndAssertArrayEquality(array);
        }
    }

    byte[] prependBytes(byte[] bytes, byte[] src) {
        byte[] res = new byte[bytes.length + src.length];
        System.arraycopy(bytes, 0, res, 0, bytes.length);
        System.arraycopy(src, 0, res, bytes.length, src.length);
        return res;
    }

    protected void marshallAndAssertEquality(Object writeObj) throws Exception {
        byte[] bytes = this.marshaller.objectToByteBuffer(writeObj);
        log.debugf("Payload size for object=%s : %s", writeObj, (Object)bytes.length);
        Object readObj = this.marshaller.objectFromByteBuffer(bytes);
        assert (readObj.equals(writeObj)) : "Writen[" + writeObj + "] and read[" + readObj + "] objects should be the same";
    }

    protected void marshallAndAssertEquality(ReplicableCommand writeObj) throws Exception {
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)writeObj);
        log.debugf("Payload size for object=%s : %s", (Object)writeObj, (Object)bytes.length);
        ReplicableCommand readObj = (ReplicableCommand)this.marshaller.objectFromByteBuffer(bytes);
        assert (readObj.getCommandId() == writeObj.getCommandId()) : "Writen[" + writeObj.getCommandId() + "] and read[" + readObj.getCommandId() + "] objects should be the same";
        assert (readObj.equals(writeObj)) : "Writen[" + writeObj + "] and read[" + readObj + "] objects should be the same";
    }

    protected void marshallAndAssertArrayEquality(Object[] writeObj) throws Exception {
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)writeObj);
        log.debugf("Payload size for %s[]=%s : %s", (Object)writeObj.getClass().getComponentType().getName(), (Object)Arrays.toString(writeObj), (Object)bytes.length);
        Object[] readObj = (Object[])this.marshaller.objectFromByteBuffer(bytes);
        ArrayAsserts.assertArrayEquals((String)("Writen[" + Arrays.toString(writeObj) + "] and read[" + Arrays.toString(readObj) + "] objects should be the same"), (Object[])writeObj, (Object[])readObj);
    }

    protected void marshallAndAssertByteArrayEquality(byte[] writeObj) throws Exception {
        byte[] bytes = this.marshaller.objectToByteBuffer((Object)writeObj);
        log.debugf("Payload size for byte[]=%s : %s", (Object)Util.toHexString((byte[])writeObj), (Object)bytes.length);
        byte[] readObj = (byte[])this.marshaller.objectFromByteBuffer(bytes);
        ArrayAsserts.assertArrayEquals((String)("Writen[" + Util.toHexString((byte[])writeObj) + "] and read[" + Util.toHexString((byte[])readObj) + "] objects should be the same"), (byte[])writeObj, (byte[])readObj);
    }

    @AutoProtoSchemaBuilder(includeClasses={Key.class, Human.class, Pojo.class, PojoExtended.class, PojoWithExternalAndInternal.class}, schemaFileName="test.core.VersionAwareMarshallerTest.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.core.VersionAwareMarshallerTest", service=false)
    static interface VersionAwareMarshallerSCI
    extends SerializationContextInitializer {
    }

    public static class PojoWithExternalAndInternal {
        @ProtoField(value=1)
        final Human human;
        @ProtoField(value=2)
        final String value;

        @ProtoFactory
        PojoWithExternalAndInternal(Human human, String value) {
            this.human = human;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PojoWithExternalAndInternal that = (PojoWithExternalAndInternal)o;
            if (!this.human.equals(that.human)) {
                return false;
            }
            return this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.human.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public static class Externalizer
        implements AdvancedExternalizer<PojoWithExternalAndInternal> {
            public void writeObject(ObjectOutput out, PojoWithExternalAndInternal obj) throws IOException {
                out.writeObject(obj.human);
                out.writeObject(obj.value);
            }

            public PojoWithExternalAndInternal readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                Human human = (Human)input.readObject();
                String value = (String)input.readObject();
                return new PojoWithExternalAndInternal(human, value);
            }

            public Set<Class<? extends PojoWithExternalAndInternal>> getTypeClasses() {
                return Collections.singleton(PojoWithExternalAndInternal.class);
            }

            public Integer getId() {
                return 999;
            }
        }
    }

    public static class HumanComparator
    implements Comparator<Human>,
    Serializable {
        @Override
        public int compare(Human o1, Human o2) {
            if (o1.age < o2.age) {
                return -1;
            }
            if (o1.age == o2.age) {
                return 0;
            }
            return 1;
        }
    }

    public static class Human
    implements Serializable {
        @ProtoField(number=1, defaultValue="0")
        int age;

        public Human age(int age) {
            this.age = age;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Human human = (Human)o;
            return this.age == human.age;
        }

        public int hashCode() {
            return this.age;
        }
    }

    public static class PojoWithMultiExternalizer
    extends Pojo {
        public PojoWithMultiExternalizer(int i, boolean b) {
            super(i, b);
        }

        public static class Externalizer
        implements AdvancedExternalizer<Object> {
            public Set<Class<?>> getTypeClasses() {
                return Util.asSet((Object[])new Class[]{PojoWithMultiExternalizer.class, Thread.class});
            }

            public Integer getId() {
                return 4321;
            }

            public void writeObject(ObjectOutput output, Object o) throws IOException {
                PojoWithMultiExternalizer pojo = (PojoWithMultiExternalizer)o;
                output.writeInt(pojo.i);
                output.writeBoolean(pojo.b);
            }

            public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new PojoWithMultiExternalizer(input.readInt(), input.readBoolean());
            }
        }
    }

    public static class PojoWithExternalizer
    extends Pojo {
        public PojoWithExternalizer(int i, boolean b) {
            super(i, b);
        }

        public static class Externalizer
        implements AdvancedExternalizer<PojoWithExternalizer> {
            public Set<Class<? extends PojoWithExternalizer>> getTypeClasses() {
                return Util.asSet((Object[])new Class[]{PojoWithExternalizer.class});
            }

            public Integer getId() {
                return 1234;
            }

            public void writeObject(ObjectOutput output, PojoWithExternalizer object) throws IOException {
                output.writeInt(object.i);
                output.writeBoolean(object.b);
            }

            public PojoWithExternalizer readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new PojoWithExternalizer(input.readInt(), input.readBoolean());
            }
        }
    }

    public static class PojoExtended
    extends Pojo {
        public PojoExtended() {
        }

        public PojoExtended(int i, boolean b) {
            super(i, b);
        }
    }

    @SerializeWith(value=Externalizer.class)
    public static class PojoAnnotated
    extends Pojo {
        public PojoAnnotated(int i, boolean b) {
            super(i, b);
        }

        public static class Externalizer
        implements org.infinispan.commons.marshall.Externalizer<PojoAnnotated> {
            public void writeObject(ObjectOutput output, PojoAnnotated object) throws IOException {
                output.writeInt(object.i);
                output.writeBoolean(object.b);
            }

            public PojoAnnotated readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return new PojoAnnotated(input.readInt(), input.readBoolean());
            }
        }
    }

    public static class Pojo
    implements I,
    Externalizable {
        private static final long serialVersionUID = 9032309454840083326L;
        @ProtoField(number=1, defaultValue="0")
        int i;
        @ProtoField(number=2, defaultValue="false")
        boolean b;

        public Pojo() {
        }

        public Pojo(int i, boolean b) {
            this.i = i;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pojo pojo = (Pojo)o;
            if (this.b != pojo.b) {
                return false;
            }
            return this.i == pojo.i;
        }

        public int hashCode() {
            int result = this.i;
            result = 31 * result + (this.b ? 1 : 0);
            return result;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.i);
            out.writeBoolean(this.b);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.i = in.readInt();
            this.b = in.readBoolean();
        }
    }

    public static interface I {
    }

    public static class PojoWhichFailsOnUnmarshalling
    extends Pojo {
        private static final long serialVersionUID = -5109779096242560884L;

        public PojoWhichFailsOnUnmarshalling() {
            super(0, false);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            throw new IOException("Injected failue!");
        }
    }
}

