/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.AdvancedExternalizerTest;
import org.infinispan.marshall.core.GlobalMarshaller;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.core.ExternalizerConfigurationValidationTest")
public class ExternalizerConfigurationValidationTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(ExternalizerConfigurationValidationTest.class);
    private EmbeddedCacheManager cm;

    @BeforeClass
    public void setUp() {
        this.cm = TestCacheManagerFactory.createCacheManager();
    }

    @AfterClass
    public void tearDown() {
        if (this.cm != null) {
            this.cm.stop();
        }
    }

    public void testInternalDuplicateExternalizerId() throws Exception {
        this.withExpectedInternalFailure((AdvancedExternalizer<?>)new DuplicateIdClass.Externalizer(), "Should have thrown a CacheException reporting the duplicate id");
    }

    public void testInternalExternalIdLimit() {
        this.withExpectedInternalFailure((AdvancedExternalizer<?>)new TooHighIdClass.Externalizer(), "Should have thrown a CacheException indicating that the Id is too high");
    }

    @Test(expectedExceptions={CacheException.class})
    public void testForeignExternalizerIdNegative() {
        GlobalConfigurationBuilder global = this.createForeignExternalizerGlobalConfig(-1);
        TestCacheManagerFactory.createCacheManager(global, new ConfigurationBuilder());
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testForeignExternalizerIdClash() {
        this.createMultiForeignExternalizerGlobalConfig(3456, true);
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testForeignExternalizerIdClash2() {
        this.createMultiForeignExternalizerGlobalConfig(5678, true);
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testForeignExternalizerWithoutId() {
        this.createMultiForeignExternalizerGlobalConfig(9999, false);
    }

    public void testForeignExternalizerConfigIdWins() throws Exception {
        GlobalConfigurationBuilder globalCfg = this.createForeignExternalizerGlobalConfig(3456);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(globalCfg, new ConfigurationBuilder());
        try {
            cm.getCache();
            AssertJUnit.assertEquals((int)3456, (int)this.findExternalizerId(new AdvancedExternalizerTest.IdViaBothObj(), cm));
        }
        finally {
            cm.stop();
        }
    }

    private int findExternalizerId(Object obj, EmbeddedCacheManager cm) {
        GlobalMarshaller marshaller = TestingUtil.extractGlobalMarshaller(cm);
        return ((AdvancedExternalizer)marshaller.findExternalizerFor(obj)).getId();
    }

    public void testForeignExternalizerMultiClassTypesViaSameExternalizer() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.serialization().addAdvancedExternalizer((AdvancedExternalizer)new MultiIdViaClassExternalizer());
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(builder, new ConfigurationBuilder());
        try {
            cm.getCache();
            assert (767 == this.findExternalizerId(new AdvancedExternalizerTest.IdViaConfigObj(), cm));
            assert (767 == this.findExternalizerId(new AdvancedExternalizerTest.IdViaAnnotationObj(), cm));
            assert (767 == this.findExternalizerId(new AdvancedExternalizerTest.IdViaBothObj(), cm));
        }
        finally {
            cm.stop();
        }
    }

    public void testForeignExternalizerMultiClassNameTypesViaSameExternalizer() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.serialization().addAdvancedExternalizer(868, (AdvancedExternalizer)new MultiIdViaClassNameExternalizer());
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(builder, new ConfigurationBuilder());
        try {
            cm.getCache();
            assert (868 == this.findExternalizerId(new AdvancedExternalizerTest.IdViaConfigObj(), cm));
            assert (868 == this.findExternalizerId(new AdvancedExternalizerTest.IdViaAnnotationObj(), cm));
            assert (868 == this.findExternalizerId(new AdvancedExternalizerTest.IdViaBothObj(), cm));
        }
        finally {
            cm.stop();
        }
    }

    private GlobalConfigurationBuilder createForeignExternalizerGlobalConfig(int id) {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.serialization().addAdvancedExternalizer(id, (AdvancedExternalizer)new AdvancedExternalizerTest.IdViaBothObj.Externalizer());
        return builder;
    }

    private GlobalConfigurationBuilder createMultiForeignExternalizerGlobalConfig(int id, boolean doSetId) {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        if (doSetId) {
            builder.serialization().addAdvancedExternalizer(id, (AdvancedExternalizer)new AdvancedExternalizerTest.IdViaConfigObj.Externalizer());
        } else {
            builder.serialization().addAdvancedExternalizer((AdvancedExternalizer)new AdvancedExternalizerTest.IdViaConfigObj.Externalizer());
        }
        builder.serialization().addAdvancedExternalizer((AdvancedExternalizer)new AdvancedExternalizerTest.IdViaAnnotationObj.Externalizer());
        builder.serialization().addAdvancedExternalizer(3456, (AdvancedExternalizer)new AdvancedExternalizerTest.IdViaBothObj.Externalizer());
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withExpectedInternalFailure(AdvancedExternalizer<?> ext, String message) {
        try {
            GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder();
            globalBuilder.serialization().addAdvancedExternalizer(ext).addAdvancedExternalizer(ext);
            assert (false) : message;
        }
        catch (CacheConfigurationException ce) {
            log.trace((Object)"Expected exception", (Throwable)ce);
        }
        finally {
            this.cm.stop();
        }
    }

    static class MultiIdViaClassNameExternalizer
    extends MultiIdViaClassExternalizer {
        MultiIdViaClassNameExternalizer() {
        }

        @Override
        public Integer getId() {
            return null;
        }

        @Override
        public Set<Class<? extends Object>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{Util.loadClass((String)"org.infinispan.marshall.AdvancedExternalizerTest$IdViaConfigObj", (ClassLoader)Thread.currentThread().getContextClassLoader()), Util.loadClass((String)"org.infinispan.marshall.AdvancedExternalizerTest$IdViaAnnotationObj", (ClassLoader)Thread.currentThread().getContextClassLoader()), Util.loadClass((String)"org.infinispan.marshall.AdvancedExternalizerTest$IdViaBothObj", (ClassLoader)Thread.currentThread().getContextClassLoader())});
        }
    }

    static class MultiIdViaClassExternalizer
    extends AbstractExternalizer<Object> {
        private final AdvancedExternalizer idViaConfigObjExt = new AdvancedExternalizerTest.IdViaConfigObj.Externalizer();
        private final AdvancedExternalizer idViaAnnotationObjExt = new AdvancedExternalizerTest.IdViaAnnotationObj.Externalizer();
        private final AdvancedExternalizer idViaBothObjExt = new AdvancedExternalizerTest.IdViaBothObj.Externalizer();

        MultiIdViaClassExternalizer() {
        }

        public void writeObject(ObjectOutput output, Object object) throws IOException {
            AdvancedExternalizer ext;
            if (object instanceof AdvancedExternalizerTest.IdViaConfigObj) {
                output.write(0);
                ext = this.idViaConfigObjExt;
            } else if (object instanceof AdvancedExternalizerTest.IdViaAnnotationObj) {
                output.write(1);
                ext = this.idViaAnnotationObjExt;
            } else if (object instanceof AdvancedExternalizerTest.IdViaBothObj) {
                output.write(2);
                ext = this.idViaBothObjExt;
            } else {
                throw new CacheException(String.format("Object of type %s is not supported by externalizer %s", object.getClass().getName(), ((Object)((Object)this)).getClass().getName()));
            }
            ext.writeObject(output, object);
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            AdvancedExternalizer ext;
            int index = input.read();
            switch (index) {
                case 0: {
                    ext = this.idViaConfigObjExt;
                    break;
                }
                case 1: {
                    ext = this.idViaAnnotationObjExt;
                    break;
                }
                case 2: {
                    ext = this.idViaBothObjExt;
                    break;
                }
                default: {
                    throw new CacheException(String.format("Unknown index (%d) for externalizer %s", index, ((Object)((Object)this)).getClass().getName()));
                }
            }
            return ext.readObject(input);
        }

        public Integer getId() {
            return 767;
        }

        public Set<Class<? extends Object>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{AdvancedExternalizerTest.IdViaConfigObj.class, AdvancedExternalizerTest.IdViaAnnotationObj.class, AdvancedExternalizerTest.IdViaBothObj.class});
        }
    }

    static class TooHighIdClass {
        TooHighIdClass() {
        }

        public static class Externalizer
        extends AbstractExternalizer<TooHighIdClass> {
            public TooHighIdClass readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return null;
            }

            public void writeObject(ObjectOutput output, TooHighIdClass object) throws IOException {
            }

            public Integer getId() {
                return 255;
            }

            public Set<Class<? extends TooHighIdClass>> getTypeClasses() {
                return Util.asSet((Object[])new Class[]{TooHighIdClass.class});
            }
        }
    }

    static class DuplicateIdClass {
        DuplicateIdClass() {
        }

        public static class Externalizer
        extends AbstractExternalizer<DuplicateIdClass> {
            public DuplicateIdClass readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                return null;
            }

            public void writeObject(ObjectOutput output, DuplicateIdClass object) throws IOException {
            }

            public Integer getId() {
                return 1;
            }

            public Set<Class<? extends DuplicateIdClass>> getTypeClasses() {
                return Util.asSet((Object[])new Class[]{DuplicateIdClass.class});
            }
        }
    }
}

