/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.util.DoubleSummaryStatistics;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.marshall.exts.AbstractExternalizerTest;
import org.infinispan.marshall.exts.DoubleSummaryStatisticsExternalizer;
import org.infinispan.marshall.exts.SecurityActions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="marshall.DoubleSummaryStatisticsExternalizerTest")
public class DoubleSummaryStatisticsExternalizerTest
extends AbstractExternalizerTest<DoubleSummaryStatistics> {
    public void testFinite() throws Exception {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        stats.accept(3.3333333333333335);
        stats.accept(-0.1);
        DoubleSummaryStatistics deserialized = this.deserialize(stats);
        this.assertStatsAreEqual(stats, deserialized);
    }

    public void testPositiveNegativeInfinites() throws Exception {
        block2: {
            DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
            stats.accept(Double.POSITIVE_INFINITY);
            stats.accept(Double.NEGATIVE_INFINITY);
            try {
                DoubleSummaryStatistics deserialized = this.deserialize(stats);
                this.assertStatsAreEqual(stats, deserialized);
            }
            catch (IOException e) {
                if (SecurityActions.getConstructor(DoubleSummaryStatistics.class, (Class[])new Class[]{Long.TYPE, Double.TYPE, Double.TYPE, Double.TYPE}) != null) break block2;
                throw e;
            }
        }
    }

    public void testNaN() throws Exception {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        stats.accept(-1.0);
        stats.accept(Double.NaN);
        DoubleSummaryStatistics deserialized = this.deserialize(stats);
        this.assertStatsAreEqual(stats, deserialized);
    }

    public void testInfinity() throws Exception {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        stats.accept(Double.POSITIVE_INFINITY);
        stats.accept(-1.0);
        DoubleSummaryStatistics deserialized = this.deserialize(stats);
        this.assertStatsAreEqual(stats, deserialized);
    }

    @Override
    AbstractExternalizer<DoubleSummaryStatistics> createExternalizer() {
        return new DoubleSummaryStatisticsExternalizer();
    }

    private void assertStatsAreEqual(DoubleSummaryStatistics original, DoubleSummaryStatistics deserialized) {
        Assert.assertEquals((long)original.getCount(), (long)deserialized.getCount());
        Assert.assertEquals((Object)original.getMin(), (Object)deserialized.getMin());
        Assert.assertEquals((Object)original.getMax(), (Object)deserialized.getMax());
        Assert.assertEquals((Object)original.getSum(), (Object)deserialized.getSum());
        Assert.assertEquals((Object)original.getAverage(), (Object)deserialized.getAverage());
    }
}

