/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.UUID;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.types.java.CommonTypesSchema;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="marshall.ProtoStreamBackwardsCompatibilityTest")
public class ProtoStreamBackwardsCompatibilityTest {
    public void testOldEventLoggerUUIDBytesAreReadable() throws IOException {
        SerializationContext oldServerCtx = ProtobufUtil.newSerializationContext();
        PersistenceContextManualInitializer serverInitializer = new PersistenceContextManualInitializer();
        serverInitializer.registerSchema(oldServerCtx);
        serverInitializer.registerMarshallers(oldServerCtx);
        SerializationContext coreCtx = ProtobufUtil.newSerializationContext();
        CommonTypesSchema sci = new CommonTypesSchema();
        sci.registerSchema(coreCtx);
        sci.registerMarshallers(coreCtx);
        UUID uuid = UUID.randomUUID();
        byte[] oldBytes = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)oldServerCtx, (Object)uuid);
        UUID unmarshalled = (UUID)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)coreCtx, (byte[])oldBytes);
        AssertJUnit.assertEquals((Object)uuid, (Object)unmarshalled);
        byte[] newBytes = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)coreCtx, (Object)uuid);
        unmarshalled = (UUID)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)coreCtx, (byte[])newBytes);
        AssertJUnit.assertEquals((Object)uuid, (Object)unmarshalled);
    }

    private static class OldUUIDMarshaller
    implements MessageMarshaller<UUID> {
        private final String typeName;

        public OldUUIDMarshaller(String typeName) {
            this.typeName = typeName;
        }

        public UUID readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
            throw new IllegalStateException();
        }

        public void writeTo(MessageMarshaller.ProtoStreamWriter writer, UUID uuid) throws IOException {
            writer.writeLong("mostSigBits", uuid.getMostSignificantBits());
            writer.writeLong("leastSigBits", uuid.getLeastSignificantBits());
        }

        public Class<? extends UUID> getJavaClass() {
            return UUID.class;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }

    private static class PersistenceContextManualInitializer
    implements SerializationContextInitializer {
        String type(String message) {
            return String.format("org.infinispan.persistence.m.event_logger.%s", message);
        }

        private PersistenceContextManualInitializer() {
        }

        public String getProtoFileName() {
            return "persistence.m.event_logger.proto";
        }

        public String getProtoFile() throws UncheckedIOException {
            return "package org.infinispan.persistence.m.event_logger;\n\n/**\n * @TypeId(1005)\n * ProtoStreamTypeIds.SERVER_EVENT_UUID\n */\nmessage UUID {\n    optional uint64 mostSigBits = 1;\n    optional uint64 leastSigBits = 2;\n}\n";
        }

        public void registerSchema(SerializationContext serCtx) {
            serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)this.getProtoFileName(), (String)this.getProtoFile()));
        }

        public void registerMarshallers(SerializationContext serCtx) {
            serCtx.registerMarshaller((BaseMarshaller)new OldUUIDMarshaller(this.type(UUID.class.getSimpleName())));
        }
    }
}

