/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics;

import java.util.SortedMap;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metrics.impl.MetricsCollector;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="metrics.ClusteredCacheManagerMetricsTest")
public class ClusteredCacheManagerMetricsTest
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "MyCache";

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder globalConfig1 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalConfig1.cacheContainer().statistics(true).metrics().prefix("ispn").gauges(true).histograms(true).namesAsTags(true);
        ConfigurationBuilder config = ClusteredCacheManagerMetricsTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC);
        config.statistics().enable();
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager(globalConfig1, config, new TransportFlags());
        cacheManager1.start();
        GlobalConfigurationBuilder globalConfig2 = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalConfig2.metrics().prefix("ispn").gauges(true).histograms(true).namesAsTags(true);
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createClusteredCacheManager(globalConfig2, config, new TransportFlags());
        cacheManager2.start();
        this.registerCacheManager(new CacheContainer[]{cacheManager1, cacheManager2});
        this.defineConfigurationOnAllManagers(CACHE_NAME, config);
        this.manager(0).getCache(CACHE_NAME);
        this.manager(1).getCache(CACHE_NAME);
    }

    public void testMetricsAreRegistered() {
        MetricsCollector mc0 = (MetricsCollector)this.manager(0).getGlobalComponentRegistry().getComponent(MetricsCollector.class);
        SortedMap gauges0 = mc0.getRegistry().getGauges((metricID, metric) -> metricID.getName().contains("ispn"));
        AssertJUnit.assertFalse((boolean)gauges0.isEmpty());
        MetricsCollector mc1 = (MetricsCollector)this.manager(1).getGlobalComponentRegistry().getComponent(MetricsCollector.class);
        SortedMap gauges1 = mc1.getRegistry().getGauges((metricID, metric) -> metricID.getName().startsWith("ispn"));
        AssertJUnit.assertFalse((boolean)gauges1.isEmpty());
        GlobalConfiguration gcfg0 = this.manager(0).getCacheManagerConfiguration();
        Tag nodeNameTag = new Tag("node", gcfg0.transport().nodeName());
        Tag cacheManagerTag = new Tag("cache_manager", gcfg0.cacheManagerName());
        MetricID evictionsMetricId = new MetricID("ispn_cache_container_stats_evictions", new Tag[]{nodeNameTag, cacheManagerTag});
        Gauge evictions = (Gauge)mc0.getRegistry().getGauges().get(evictionsMetricId);
        AssertJUnit.assertNotNull((Object)evictions);
    }
}

