/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletableFutures;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.AsyncNotificationTest")
public class AsyncNotificationTest
extends AbstractInfinispanTest {
    Cache<String, String> c;
    EmbeddedCacheManager cm;

    @BeforeMethod
    public void setUp() {
        this.cm = TestCacheManagerFactory.createCacheManager(false);
        this.c = this.cm.getCache();
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm);
        this.cm = null;
        this.c = null;
    }

    public void testAsyncNotification() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(3);
        NonBlockingListener nonBlockingListener = new NonBlockingListener(latch);
        SyncListener syncListener = new SyncListener(latch);
        AsyncListener asyncListener = new AsyncListener(latch);
        this.c.addListener((Object)nonBlockingListener);
        this.c.addListener((Object)syncListener);
        this.c.addListener((Object)asyncListener);
        this.c.put((Object)"k", (Object)"v");
        latch.await();
        Thread currentThread = Thread.currentThread();
        AssertJUnit.assertEquals((Object)currentThread, (Object)nonBlockingListener.caller);
        AssertJUnit.assertEquals((Object)currentThread, (Object)syncListener.caller);
        AssertJUnit.assertNotSame((Object)currentThread, (Object)asyncListener.caller);
    }

    @Listener(sync=false)
    public static class AsyncListener
    extends AbstractListener {
        public AsyncListener(CountDownLatch latch) {
            super(latch);
        }

        @CacheEntryCreated
        public void handle(CacheEntryCreatedEvent e) {
            if (e.isPre()) {
                this.caller = Thread.currentThread();
                this.latch.countDown();
            }
        }
    }

    @Listener(sync=true)
    public static class SyncListener
    extends AbstractListener {
        public SyncListener(CountDownLatch latch) {
            super(latch);
        }

        @CacheEntryCreated
        public void handle(CacheEntryCreatedEvent e) {
            if (e.isPre()) {
                this.caller = Thread.currentThread();
                this.latch.countDown();
            }
        }
    }

    @Listener
    public static class NonBlockingListener
    extends AbstractListener {
        public NonBlockingListener(CountDownLatch latch) {
            super(latch);
        }

        @CacheEntryCreated
        public CompletionStage<Void> handle(CacheEntryCreatedEvent e) {
            if (e.isPre()) {
                this.caller = Thread.currentThread();
                this.latch.countDown();
            }
            return CompletableFutures.completedNull();
        }
    }

    public static abstract class AbstractListener {
        Thread caller;
        CountDownLatch latch;

        protected AbstractListener(CountDownLatch latch) {
            this.latch = latch;
        }
    }
}

