/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="notifications.ConcurrentNotificationTest")
public class ConcurrentNotificationTest
extends AbstractInfinispanTest {
    Cache<String, String> cache;
    CacheContainer cm;
    CacheListener listener;
    Log log = LogFactory.getLog(ConcurrentNotificationTest.class);

    @BeforeMethod
    public void setUp() {
        this.cm = TestCacheManagerFactory.createCacheManager(false);
        this.cache = this.cm.getCache();
        this.listener = new CacheListener();
        this.cache.addListener((Object)this.listener);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm);
        this.cm = null;
        this.cache = null;
        this.listener = null;
    }

    public void testThreads() throws Exception {
        Thread[] workers = new Thread[20];
        final LinkedList exceptions = new LinkedList();
        int loops = 100;
        final CountDownLatch latch = new CountDownLatch(1);
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    for (int j = 0; j < 100; ++j) {
                        try {
                            ConcurrentNotificationTest.this.cache.put((Object)"key", (Object)"value");
                        }
                        catch (Exception e) {
                            exceptions.add(new Exception("Caused on thread " + this.getName() + " in loop " + j + " when doing a put()", e));
                        }
                        try {
                            ConcurrentNotificationTest.this.cache.remove((Object)"key");
                        }
                        catch (Exception e) {
                            exceptions.add(new Exception("Caused on thread " + this.getName() + " in loop " + j + " when doing a remove()", e));
                        }
                        try {
                            ConcurrentNotificationTest.this.cache.get((Object)"key");
                            continue;
                        }
                        catch (Exception e) {
                            ConcurrentNotificationTest.this.log.error((Object)"Exception received!", (Throwable)e);
                            exceptions.add(new Exception("Caused on thread " + this.getName() + " in loop " + j + " when doing a get()", e));
                        }
                    }
                }
            };
            workers[i].start();
        }
        latch.countDown();
        for (Thread t : workers) {
            t.join();
        }
        Iterator iterator = exceptions.iterator();
        if (iterator.hasNext()) {
            Exception e = (Exception)iterator.next();
            throw e;
        }
        assert (100 * workers.length < this.listener.counter.get());
    }

    @Listener
    public static class CacheListener {
        private AtomicInteger counter = new AtomicInteger(0);

        @CacheEntryModified
        @CacheEntryRemoved
        @CacheEntryVisited
        @CacheEntryCreated
        public void catchEvent(Event e) {
            if (e.isPre()) {
                this.counter.getAndIncrement();
            }
        }
    }
}

