/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import io.reactivex.rxjava3.core.Flowable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.infinispan.CacheStream;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactoryImpl;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.MockBasicComponentRegistry;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="notifications.cachelistener.BaseCacheNotifierImplInitialTransferTest")
public abstract class BaseCacheNotifierImplInitialTransferTest
extends AbstractInfinispanTest {
    CacheNotifierImpl n;
    EncoderCache mockCache;
    InvocationContext ctx;
    ClusterPublisherManager mockPublisherManager;
    protected CacheMode cacheMode;

    protected BaseCacheNotifierImplInitialTransferTest(CacheMode mode) {
        if (mode.isDistributed()) {
            throw new IllegalArgumentException("This test only works with non distributed cache modes");
        }
        this.cacheMode = mode;
    }

    @BeforeMethod
    public void setUp() {
        this.n = new CacheNotifierImpl();
        this.mockCache = (EncoderCache)Mockito.mock(EncoderCache.class);
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)Mockito.mock(EmbeddedCacheManager.class);
        Mockito.when((Object)this.mockCache.getCacheManager()).thenReturn((Object)cacheManager);
        Mockito.when((Object)this.mockCache.getAdvancedCache()).thenReturn((Object)this.mockCache);
        Mockito.when((Object)this.mockCache.getKeyDataConversion()).thenReturn((Object)DataConversion.IDENTITY_KEY);
        Mockito.when((Object)this.mockCache.getValueDataConversion()).thenReturn((Object)DataConversion.IDENTITY_VALUE);
        Configuration config = new ConfigurationBuilder().clustering().cacheMode(this.cacheMode).build();
        GlobalConfiguration globalConfig = GlobalConfigurationBuilder.defaultClusteredBuilder().build();
        Mockito.when((Object)this.mockCache.getStatus()).thenReturn((Object)ComponentStatus.INITIALIZING);
        this.mockPublisherManager = (ClusterPublisherManager)Mockito.mock(ClusterPublisherManager.class);
        ComponentRegistry componentRegistry = (ComponentRegistry)Mockito.mock(ComponentRegistry.class);
        Mockito.when((Object)this.mockCache.getComponentRegistry()).thenReturn((Object)componentRegistry);
        MockBasicComponentRegistry mockRegistry = new MockBasicComponentRegistry();
        Mockito.when((Object)((BasicComponentRegistry)componentRegistry.getComponent(BasicComponentRegistry.class))).thenReturn((Object)mockRegistry);
        mockRegistry.registerMocks(RpcManager.class, CommandsFactory.class);
        mockRegistry.registerMock("org.infinispan.marshaller.internal", StreamingMarshaller.class);
        ClusteringDependentLogic.LocalLogic cdl = new ClusteringDependentLogic.LocalLogic();
        cdl.init(null, config, (KeyPartitioner)Mockito.mock(KeyPartitioner.class));
        ClusterEventManager cem = (ClusterEventManager)Mockito.mock(ClusterEventManager.class);
        Mockito.when((Object)cem.sendEvents(Matchers.any())).thenReturn((Object)CompletableFutures.completedNull());
        BlockingManager handler = (BlockingManager)Mockito.mock(BlockingManager.class);
        Mockito.when((Object)handler.continueOnNonBlockingThread((CompletionStage)Matchers.any(), Matchers.any())).thenReturn((Object)CompletableFutures.completedNull());
        TestingUtil.inject(this.n, this.mockCache, cdl, config, globalConfig, mockRegistry, this.mockPublisherManager, new InternalEntryFactoryImpl(), cem, Mockito.mock(KeyPartitioner.class), handler, TestingUtil.named("org.infinispan.executors.notification", new WithinThreadExecutor()));
        this.n.start();
        this.ctx = new NonTxInvocationContext(null);
    }

    public void testSimpleCacheStartingClusterListener() {
        this.testSimpleCacheStarting(new StateListenerClustered());
    }

    private void testSimpleCacheStarting(StateListener<String, String> listener) {
        ArrayList<CacheEntry<String, String>> initialValues = new ArrayList<CacheEntry<String, String>>(10);
        for (int i = 0; i < 10; ++i) {
            String key = "key-" + i;
            String value = "value-" + i;
            initialValues.add((CacheEntry<String, String>)new ImmortalCacheEntry((Object)key, (Object)value));
        }
        Mockito.when((Object)this.mockPublisherManager.entryPublisher((IntSet)Matchers.any(), (Set)Matchers.any(), (InvocationContext)Matchers.any(), ArgumentMatchers.anyBoolean(), (DeliveryGuarantee)Matchers.any(), ArgumentMatchers.anyInt(), (Function)Matchers.any())).thenReturn((s, intConsumer) -> Flowable.fromIterable((Iterable)initialValues).subscribe(s));
        this.n.addListener(listener);
        this.verifyEvents(this.isClustered(listener), listener, initialValues);
    }

    public void testFilterConverterUnusedDuringIteration() {
        this.testFilterConverterUnusedDuringIteration(new StateListenerClustered());
    }

    private void testFilterConverterUnusedDuringIteration(StateListener<String, String> listener) {
        ArrayList<CacheEntry<String, String>> initialValues = new ArrayList<CacheEntry<String, String>>(10);
        for (int i = 0; i < 10; ++i) {
            String key = "key-" + i;
            String value = "value-" + i;
            initialValues.add((CacheEntry<String, String>)new ImmortalCacheEntry((Object)key, (Object)value));
        }
        Mockito.when((Object)this.mockPublisherManager.entryPublisher((IntSet)Matchers.any(), (Set)Matchers.any(), (InvocationContext)Matchers.any(), ArgumentMatchers.anyBoolean(), (DeliveryGuarantee)Matchers.any(), ArgumentMatchers.anyInt(), (Function)Matchers.any())).thenReturn((s, intConsumer) -> Flowable.fromIterable((Iterable)initialValues).subscribe(s));
        CacheEventFilter filter = (CacheEventFilter)Mockito.mock(CacheEventFilter.class, (MockSettings)Mockito.withSettings().serializable());
        CacheEventConverter converter = (CacheEventConverter)Mockito.mock(CacheEventConverter.class, (MockSettings)Mockito.withSettings().serializable());
        this.n.addListener(listener, filter, converter);
        this.verifyEvents(this.isClustered(listener), listener, initialValues);
        ((CacheEventFilter)Mockito.verify((Object)filter, (VerificationMode)Mockito.never())).accept(Matchers.any(), Matchers.any(), (Metadata)Matchers.any(Metadata.class), Matchers.any(), (Metadata)Matchers.any(Metadata.class), (EventType)Matchers.any(EventType.class));
        ((CacheEventConverter)Mockito.verify((Object)converter, (VerificationMode)Mockito.never())).convert(Matchers.any(), Matchers.any(), (Metadata)Matchers.any(Metadata.class), Matchers.any(), (Metadata)Matchers.any(Metadata.class), (EventType)Matchers.any(EventType.class));
    }

    public void testMetadataAvailable() {
        ArrayList<CacheEntry<String, String>> initialValues = new ArrayList<CacheEntry<String, String>>(10);
        for (int i = 0; i < 10; ++i) {
            String key = "key-" + i;
            String value = "value-" + i;
            initialValues.add((CacheEntry<String, String>)new TransientMortalCacheEntry((Object)key, (Object)value, (long)i, -1L, System.currentTimeMillis()));
        }
        Mockito.when((Object)this.mockPublisherManager.entryPublisher((IntSet)Matchers.any(), (Set)Matchers.any(), (InvocationContext)Matchers.any(), ArgumentMatchers.anyBoolean(), (DeliveryGuarantee)Matchers.any(), ArgumentMatchers.anyInt(), (Function)Matchers.any())).thenReturn((s, intConsumer) -> Flowable.fromIterable((Iterable)initialValues).subscribe(s));
        CacheEventFilter filter = (CacheEventFilter)Mockito.mock(CacheEventFilter.class, (MockSettings)Mockito.withSettings().serializable());
        CacheEventConverter converter = (CacheEventConverter)Mockito.mock(CacheEventConverter.class, (MockSettings)Mockito.withSettings().serializable());
        StateListenerClustered listener = new StateListenerClustered();
        this.n.addListener((Object)listener, filter, converter);
        this.verifyEvents(this.isClustered(listener), listener, initialValues);
        for (CacheEntryEvent event : listener.events) {
            String key = (String)event.getKey();
            Metadata metadata = event.getMetadata();
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)metadata.lifespan(), (long)-1L);
            Assert.assertEquals((long)metadata.maxIdle(), (long)Long.parseLong(key.substring(4)));
        }
    }

    private void verifyEvents(boolean isClustered, StateListener<String, String> listener, List<CacheEntry<String, String>> expected) {
        Assert.assertEquals((int)listener.events.size(), (int)(isClustered ? expected.size() : expected.size() * 2));
        int eventPosition = 0;
        for (CacheEntryEvent event : listener.events) {
            int position;
            boolean isPost;
            if (isClustered) {
                isPost = true;
                position = eventPosition;
            } else {
                isPost = eventPosition & true;
                position = eventPosition / 2;
            }
            Assert.assertEquals((Object)event.getType(), (Object)Event.Type.CACHE_ENTRY_CREATED);
            Assert.assertEquals((String)((String)event.getKey()), (String)((String)expected.get(position).getKey()));
            Assert.assertEquals((boolean)event.isPre(), (!isPost ? 1 : 0) != 0);
            if (isPost) {
                Assert.assertEquals((String)((String)event.getValue()), (String)((String)expected.get(position).getValue()));
            } else {
                Assert.assertNull((Object)event.getValue());
            }
            ++eventPosition;
        }
    }

    public void testCreateAfterIterationBeganButNotIteratedValueYetClustered() throws InterruptedException, BrokenBarrierException, TimeoutException, ExecutionException {
        this.testModificationAfterIterationBeganButNotIteratedValueYet(new StateListenerClustered(), Operation.CREATE);
    }

    public void testRemoveAfterIterationBeganButNotIteratedValueYetClustered() throws InterruptedException, BrokenBarrierException, TimeoutException, ExecutionException {
        this.testModificationAfterIterationBeganButNotIteratedValueYet(new StateListenerClustered(), Operation.REMOVE);
    }

    public void testModificationAfterIterationBeganButNotIteratedValueYetClustered() throws InterruptedException, BrokenBarrierException, TimeoutException, ExecutionException {
        this.testModificationAfterIterationBeganButNotIteratedValueYet(new StateListenerClustered(), Operation.PUT);
    }

    private void testModificationAfterIterationBeganButNotIteratedValueYet(StateListener<String, String> listener, Operation operation) throws InterruptedException, TimeoutException, BrokenBarrierException, ExecutionException {
        ArrayList<CacheEntry<String, String>> initialValues = new ArrayList<CacheEntry<String, String>>();
        for (int i = 0; i < 10; ++i) {
            String key = "key-" + i;
            String value = "value-" + i;
            initialValues.add((CacheEntry<String, String>)new ImmortalCacheEntry((Object)key, (Object)value));
        }
        CyclicBarrier barrier = new CyclicBarrier(2);
        Mockito.when((Object)this.mockPublisherManager.entryPublisher((IntSet)Matchers.any(), (Set)Matchers.any(), (InvocationContext)Matchers.any(), ArgumentMatchers.anyBoolean(), (DeliveryGuarantee)Matchers.any(), ArgumentMatchers.anyInt(), (Function)Matchers.any())).thenReturn((s, intConsumer) -> Flowable.defer(() -> {
            barrier.await(10L, TimeUnit.SECONDS);
            barrier.await(10L, TimeUnit.SECONDS);
            return Flowable.fromIterable((Iterable)initialValues);
        }).subscribe(s));
        Future<Void> future = this.fork(() -> {
            this.n.addListener((Object)listener);
            return null;
        });
        barrier.await(10L, TimeUnit.SECONDS);
        switch (operation) {
            case REMOVE: {
                String key = "key-3";
                Object prevValue = ((CacheEntry)initialValues.get(3)).getValue();
                this.n.notifyCacheEntryRemoved((Object)key, prevValue, null, true, this.ctx, null);
                this.n.notifyCacheEntryRemoved((Object)key, prevValue, null, false, this.ctx, null);
                initialValues.remove(3);
                break;
            }
            case CREATE: {
                String key = "new-key";
                String value = "new-value";
                this.n.notifyCacheEntryCreated((Object)key, (Object)value, null, true, this.ctx, null);
                this.n.notifyCacheEntryCreated((Object)key, (Object)value, null, false, this.ctx, null);
                initialValues.add((CacheEntry<String, String>)new ImmortalCacheEntry((Object)key, (Object)value));
                break;
            }
            case PUT: {
                String key = "key-3";
                String value = "value-3-changed";
                this.n.notifyCacheEntryModified((Object)key, ((CacheEntry)initialValues.get(3)).getValue(), null, (Object)value, null, true, this.ctx, null);
                this.n.notifyCacheEntryModified((Object)key, ((CacheEntry)initialValues.get(3)).getValue(), null, (Object)value, null, false, this.ctx, null);
                initialValues.remove(3);
                initialValues.add(3, (CacheEntry<String, String>)new ImmortalCacheEntry((Object)key, (Object)value));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Operation provided " + (Object)((Object)operation));
            }
        }
        barrier.await(10L, TimeUnit.SECONDS);
        future.get(10L, TimeUnit.MINUTES);
        this.verifyEvents(this.isClustered(listener), listener, initialValues);
    }

    public void testCreateAfterIterationBeganAndIteratedValueClustered() throws Exception {
        this.testModificationAfterIterationBeganAndIteratedValue(new StateListenerClustered(), Operation.CREATE);
    }

    public void testRemoveAfterIterationBeganAndIteratedValueClustered() throws Exception {
        this.testModificationAfterIterationBeganAndIteratedValue(new StateListenerClustered(), Operation.REMOVE);
    }

    public void testModificationAfterIterationBeganAndIteratedValueClustered() throws Exception {
        this.testModificationAfterIterationBeganAndIteratedValue(new StateListenerClustered(), Operation.PUT);
    }

    private void testModificationAfterIterationBeganAndIteratedValue(StateListener<String, String> listener, Operation operation) throws Exception {
        CacheEntryEvent event;
        String prevValue;
        String value;
        String key;
        ArrayList<ImmortalCacheEntry> initialValues = new ArrayList<ImmortalCacheEntry>();
        for (int i = 0; i < 10; ++i) {
            String key2 = "key-" + i;
            String value2 = "value-" + i;
            initialValues.add(new ImmortalCacheEntry((Object)key2, (Object)value2));
        }
        CyclicBarrier barrier = new CyclicBarrier(2);
        Mockito.when((Object)this.mockPublisherManager.entryPublisher((IntSet)Matchers.any(), (Set)Matchers.any(), (InvocationContext)Matchers.any(), ArgumentMatchers.anyBoolean(), (DeliveryGuarantee)Matchers.any(), ArgumentMatchers.anyInt(), (Function)Matchers.any())).thenReturn((s, intConsumer) -> Flowable.fromIterable((Iterable)initialValues).doOnComplete(() -> {
            barrier.await(10L, TimeUnit.SECONDS);
            barrier.await(10L, TimeUnit.SECONDS);
        }).subscribe(s));
        Future<Void> future = this.fork(() -> {
            this.n.addListener((Object)listener);
            return null;
        });
        barrier.await(10L, TimeUnit.SECONDS);
        switch (operation) {
            case REMOVE: {
                key = "key-3";
                value = null;
                prevValue = (String)((CacheEntry)initialValues.get(3)).getValue();
                break;
            }
            case CREATE: {
                key = "new-key";
                value = "new-value";
                prevValue = null;
                break;
            }
            case PUT: {
                key = "key-3";
                value = "key-3-new";
                prevValue = (String)((CacheEntry)initialValues.get(3)).getValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Operation provided " + (Object)((Object)operation));
            }
        }
        operation.raiseEvent((CacheNotifier)this.n, key, prevValue, value, this.ctx);
        barrier.await(10L, TimeUnit.SECONDS);
        future.get(10L, TimeUnit.MINUTES);
        boolean isClustered = this.isClustered(listener);
        Assert.assertEquals((int)listener.events.size(), (int)(isClustered ? initialValues.size() + 1 : (initialValues.size() + 1) * 2));
        int position = 0;
        for (CacheEntry cacheEntry : initialValues) {
            if (isClustered) {
                CacheEntryEvent event2 = listener.events.get(position);
                Assert.assertEquals((Object)event2.getType(), (Object)Event.Type.CACHE_ENTRY_CREATED);
                Assert.assertEquals((boolean)event2.isPre(), (boolean)false);
                Assert.assertEquals((String)((String)event2.getKey()), (String)((String)cacheEntry.getKey()));
                Assert.assertEquals((String)((String)event2.getValue()), (String)((String)cacheEntry.getValue()));
            } else {
                CacheEntryEvent event2 = listener.events.get(position * 2);
                Assert.assertEquals((Object)event2.getType(), (Object)Event.Type.CACHE_ENTRY_CREATED);
                Assert.assertEquals((boolean)event2.isPre(), (boolean)true);
                Assert.assertEquals((String)((String)event2.getKey()), (String)((String)cacheEntry.getKey()));
                Assert.assertNull((Object)event2.getValue());
                event2 = listener.events.get(position * 2 + 1);
                Assert.assertEquals((Object)event2.getType(), (Object)Event.Type.CACHE_ENTRY_CREATED);
                Assert.assertEquals((boolean)event2.isPre(), (boolean)false);
                Assert.assertEquals((String)((String)event2.getKey()), (String)((String)cacheEntry.getKey()));
                Assert.assertEquals((String)((String)event2.getValue()), (String)((String)cacheEntry.getValue()));
            }
            ++position;
        }
        if (isClustered) {
            event = listener.events.get(position);
            Assert.assertEquals((Object)event.getType(), (Object)operation.getType());
            Assert.assertEquals((boolean)event.isPre(), (boolean)false);
            Assert.assertEquals((String)((String)event.getKey()), (String)key);
            Assert.assertEquals((String)((String)event.getValue()), (String)value);
        } else {
            event = listener.events.get(position * 2);
            Assert.assertEquals((Object)event.getType(), (Object)operation.getType());
            Assert.assertEquals((boolean)event.isPre(), (boolean)true);
            Assert.assertEquals((String)((String)event.getKey()), (String)key);
            Assert.assertEquals((String)((String)event.getValue()), (String)prevValue);
            event = listener.events.get(position * 2 + 1);
            Assert.assertEquals((Object)event.getType(), (Object)operation.getType());
            Assert.assertEquals((boolean)event.isPre(), (boolean)false);
            Assert.assertEquals((String)((String)event.getKey()), (String)key);
            Assert.assertEquals((String)((String)event.getValue()), (String)value);
        }
    }

    private boolean isClustered(StateListener listener) {
        return listener.getClass().getAnnotation(Listener.class).clustered();
    }

    protected CacheStream mockStream() {
        CacheStream mockStream = (CacheStream)Mockito.mock(CacheStream.class, (MockSettings)Mockito.withSettings().defaultAnswer(i -> i.getMock()));
        ((CacheStream)Mockito.doNothing().when((Object)mockStream)).close();
        return mockStream;
    }

    @Listener(includeCurrentState=true, clustered=true)
    private static class StateListenerClustered
    extends StateListener {
        private StateListenerClustered() {
        }
    }

    @Listener(includeCurrentState=true, clustered=false)
    private static class StateListenerNotClustered
    extends StateListener {
        private StateListenerNotClustered() {
        }
    }

    protected static abstract class StateListener<K, V> {
        final List<CacheEntryEvent<K, V>> events = new ArrayList<CacheEntryEvent<K, V>>();
        private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

        protected StateListener() {
        }

        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        public synchronized void onCacheNotification(CacheEntryEvent<K, V> event) {
            log.tracef("Received event: %s", event);
            this.events.add(event);
        }
    }

    private static enum Operation {
        PUT(Event.Type.CACHE_ENTRY_MODIFIED){

            @Override
            public void raiseEvent(CacheNotifier notifier, Object key, Object prevValue, Object newValue, InvocationContext ctx) {
                notifier.notifyCacheEntryModified(key, newValue, null, prevValue, null, true, ctx, null);
                notifier.notifyCacheEntryModified(key, newValue, null, prevValue, null, false, ctx, null);
            }
        }
        ,
        REMOVE(Event.Type.CACHE_ENTRY_REMOVED){

            @Override
            public void raiseEvent(CacheNotifier notifier, Object key, Object prevValue, Object newValue, InvocationContext ctx) {
                notifier.notifyCacheEntryRemoved(key, prevValue, null, true, ctx, null);
                notifier.notifyCacheEntryRemoved(key, prevValue, null, false, ctx, null);
            }
        }
        ,
        CREATE(Event.Type.CACHE_ENTRY_CREATED){

            @Override
            public void raiseEvent(CacheNotifier notifier, Object key, Object prevValue, Object newValue, InvocationContext ctx) {
                notifier.notifyCacheEntryCreated(key, newValue, null, true, ctx, null);
                notifier.notifyCacheEntryCreated(key, newValue, null, false, ctx, null);
            }
        };

        private final Event.Type type;

        private Operation(Event.Type type) {
            this.type = type;
        }

        public Event.Type getType() {
            return this.type;
        }

        public abstract void raiseEvent(CacheNotifier var1, Object var2, Object var3, Object var4, InvocationContext var5);
    }
}

