/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.MockBasicComponentRegistry;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.CacheListener;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachelistener.FakeEncoderRegistry;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="notifications.cachelistener.CacheNotifierImplTest")
public class CacheNotifierImplTest
extends AbstractInfinispanTest {
    CacheNotifierImpl n;
    EncoderCache mockCache;
    CacheListener cl;
    InvocationContext ctx;

    @BeforeMethod
    public void setUp() {
        this.n = new CacheNotifierImpl();
        this.mockCache = (EncoderCache)Mockito.mock(EncoderCache.class);
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)Mockito.mock(EmbeddedCacheManager.class);
        Mockito.when((Object)this.mockCache.getCacheManager()).thenReturn((Object)cacheManager);
        Mockito.when((Object)this.mockCache.getAdvancedCache()).thenReturn((Object)this.mockCache);
        Mockito.when((Object)this.mockCache.getKeyDataConversion()).thenReturn((Object)DataConversion.IDENTITY_KEY);
        Mockito.when((Object)this.mockCache.getValueDataConversion()).thenReturn((Object)DataConversion.IDENTITY_VALUE);
        Mockito.when((Object)this.mockCache.getStatus()).thenReturn((Object)ComponentStatus.INITIALIZING);
        ComponentRegistry componentRegistry = (ComponentRegistry)Mockito.mock(ComponentRegistry.class);
        Mockito.when((Object)this.mockCache.getComponentRegistry()).thenReturn((Object)componentRegistry);
        MockBasicComponentRegistry mockRegistry = new MockBasicComponentRegistry();
        Mockito.when((Object)((BasicComponentRegistry)componentRegistry.getComponent(BasicComponentRegistry.class))).thenReturn((Object)mockRegistry);
        mockRegistry.registerMocks(RpcManager.class, CommandsFactory.class);
        mockRegistry.registerMock("org.infinispan.marshaller.internal", StreamingMarshaller.class);
        ClusteringDependentLogic.LocalLogic cdl = new ClusteringDependentLogic.LocalLogic();
        Configuration config = new ConfigurationBuilder().build();
        cdl.init(null, config, (KeyPartitioner)Mockito.mock(KeyPartitioner.class));
        ClusterEventManager cem = (ClusterEventManager)Mockito.mock(ClusterEventManager.class);
        Mockito.when((Object)cem.sendEvents(ArgumentMatchers.any())).thenReturn((Object)CompletableFutures.completedNull());
        BlockingManager handler = (BlockingManager)Mockito.mock(BlockingManager.class);
        Mockito.when((Object)handler.continueOnNonBlockingThread((CompletionStage)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)CompletableFutures.completedNull());
        TestingUtil.inject(this.n, new Object[]{this.mockCache, cdl, config, mockRegistry, Mockito.mock(InternalEntryFactory.class), cem, Mockito.mock(KeyPartitioner.class), new FakeEncoderRegistry(), TestingUtil.named("org.infinispan.executors.notification", new WithinThreadExecutor()), handler});
        this.cl = new CacheListener();
        this.n.start();
        this.addListener();
        this.ctx = new NonTxInvocationContext(null);
    }

    protected void addListener() {
        this.n.addListener((Object)this.cl);
    }

    protected Object getExpectedEventValue(Object key, Object val, Event.Type t) {
        return val;
    }

    public void testNotifyCacheEntryCreated() {
        this.n.notifyCacheEntryCreated((Object)"k", (Object)"v1", null, true, this.ctx, null);
        this.n.notifyCacheEntryCreated((Object)"k", (Object)"v1", null, false, this.ctx, null);
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPost());
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPre());
        AssertJUnit.assertEquals((int)2, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_CREATED, (Object)this.cl.getEvents().get(0).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryCreatedEvent)this.cl.getEvents().get(0)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", null, Event.Type.CACHE_ENTRY_CREATED), (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getValue());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(1).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_CREATED, (Object)this.cl.getEvents().get(1).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryCreatedEvent)this.cl.getEvents().get(1)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v1", Event.Type.CACHE_ENTRY_CREATED), (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getValue());
    }

    public void testNotifyCacheEntryModified() {
        this.n.notifyCacheEntryModified((Object)"k", (Object)"v2", null, (Object)"v1", null, true, this.ctx, null);
        this.n.notifyCacheEntryModified((Object)"k", (Object)"v2", null, (Object)"v1", null, false, this.ctx, null);
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPost());
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPre());
        AssertJUnit.assertEquals((int)2, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_MODIFIED, (Object)this.cl.getEvents().get(0).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryModifiedEvent)this.cl.getEvents().get(0)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v1", Event.Type.CACHE_ENTRY_MODIFIED), (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getValue());
        AssertJUnit.assertTrue((!((CacheEntryModifiedEvent)this.cl.getEvents().get(0)).isCreated() ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(1).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_MODIFIED, (Object)this.cl.getEvents().get(1).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryModifiedEvent)this.cl.getEvents().get(1)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v2", Event.Type.CACHE_ENTRY_MODIFIED), (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getValue());
        AssertJUnit.assertTrue((!((CacheEntryModifiedEvent)this.cl.getEvents().get(1)).isCreated() ? 1 : 0) != 0);
    }

    public void testNotifyCacheEntryRemoved() {
        this.n.notifyCacheEntryRemoved((Object)"k", (Object)"v", null, true, this.ctx, null);
        this.n.notifyCacheEntryRemoved((Object)"k", (Object)"v", null, false, this.ctx, null);
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPost());
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPre());
        AssertJUnit.assertEquals((int)2, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_REMOVED, (Object)this.cl.getEvents().get(0).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryRemovedEvent)this.cl.getEvents().get(0)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_REMOVED), (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getValue());
        AssertJUnit.assertEquals((Object)"v", (Object)((CacheEntryRemovedEvent)this.cl.getEvents().get(0)).getOldValue());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(1).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_REMOVED, (Object)this.cl.getEvents().get(1).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryRemovedEvent)this.cl.getEvents().get(1)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", null, Event.Type.CACHE_ENTRY_REMOVED), (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getValue());
        AssertJUnit.assertEquals((Object)"v", (Object)((CacheEntryRemovedEvent)this.cl.getEvents().get(1)).getOldValue());
    }

    public void testNotifyCacheEntryVisited() {
        this.n.notifyCacheEntryVisited((Object)"k", (Object)"v", true, this.ctx, null);
        this.n.notifyCacheEntryVisited((Object)"k", (Object)"v", false, this.ctx, null);
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPost());
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPre());
        AssertJUnit.assertEquals((int)2, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_VISITED, (Object)this.cl.getEvents().get(0).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_VISITED), (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getValue());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(1).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_VISITED, (Object)this.cl.getEvents().get(1).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_VISITED), (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getValue());
    }

    public void testNotifyCacheEntryEvicted() {
        this.n.notifyCacheEntriesEvicted(Collections.singleton(new ImmortalCacheEntry((Object)"k", (Object)"v")), null, null);
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPost());
        AssertJUnit.assertEquals((int)1, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_EVICTED, (Object)this.cl.getEvents().get(0).getType());
        Map entries = ((CacheEntriesEvictedEvent)this.cl.getEvents().get(0)).getEntries();
        Map.Entry entry = entries.entrySet().iterator().next();
        AssertJUnit.assertEquals((Object)"k", entry.getKey());
        AssertJUnit.assertEquals((Object)"v", entry.getValue());
    }

    public void testNotifyCacheEntriesEvicted() {
        InternalCacheEntry ice = TestInternalCacheEntryFactory.create("k", "v");
        this.n.notifyCacheEntriesEvicted(Collections.singleton(ice), null, null);
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPost());
        AssertJUnit.assertEquals((int)1, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_EVICTED, (Object)this.cl.getEvents().get(0).getType());
        Map entries = ((CacheEntriesEvictedEvent)this.cl.getEvents().get(0)).getEntries();
        Map.Entry entry = entries.entrySet().iterator().next();
        AssertJUnit.assertEquals((Object)"k", entry.getKey());
        AssertJUnit.assertEquals((Object)"v", entry.getValue());
    }

    public void testNotifyCacheEntryExpired() {
        this.n.notifyCacheEntryExpired((Object)"k", (Object)"v", null, null);
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPost());
        AssertJUnit.assertEquals((int)this.cl.getInvocationCount(), (int)1);
        AssertJUnit.assertEquals((Object)this.cl.getEvents().get(0).getCache(), (Object)this.mockCache);
        AssertJUnit.assertEquals((Object)this.cl.getEvents().get(0).getType(), (Object)Event.Type.CACHE_ENTRY_EXPIRED);
        CacheEntryExpiredEvent expiredEvent = (CacheEntryExpiredEvent)this.cl.getEvents().get(0);
        AssertJUnit.assertEquals((Object)expiredEvent.getKey(), (Object)"k");
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_EXPIRED), (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getValue());
    }

    public void testNotifyCacheEntryInvalidated() {
        this.n.notifyCacheEntryInvalidated((Object)"k", (Object)"v", null, true, this.ctx, null);
        this.n.notifyCacheEntryInvalidated((Object)"k", (Object)"v", null, false, this.ctx, null);
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPost());
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPre());
        AssertJUnit.assertEquals((int)2, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_INVALIDATED, (Object)this.cl.getEvents().get(0).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_INVALIDATED), (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getValue());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(1).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_INVALIDATED, (Object)this.cl.getEvents().get(1).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_INVALIDATED), (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getValue());
    }

    public void testNotifyCacheEntryLoaded() {
        this.n.notifyCacheEntryLoaded((Object)"k", (Object)"v", true, this.ctx, null);
        this.n.notifyCacheEntryLoaded((Object)"k", (Object)"v", false, this.ctx, null);
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPost());
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPre());
        AssertJUnit.assertEquals((int)2, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_LOADED, (Object)this.cl.getEvents().get(0).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_LOADED), (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getValue());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(1).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_LOADED, (Object)this.cl.getEvents().get(1).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_LOADED), (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getValue());
    }

    public void testNotifyCacheEntryActivated() {
        this.n.notifyCacheEntryActivated((Object)"k", (Object)"v", true, this.ctx, null);
        this.n.notifyCacheEntryActivated((Object)"k", (Object)"v", false, this.ctx, null);
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPost());
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPre());
        AssertJUnit.assertEquals((int)2, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_ACTIVATED, (Object)this.cl.getEvents().get(0).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_ACTIVATED), (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getValue());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(1).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_ACTIVATED, (Object)this.cl.getEvents().get(1).getType());
        AssertJUnit.assertEquals((Object)"k", (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_ACTIVATED), (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getValue());
    }

    public void testNotifyCacheEntryPassivated() {
        this.n.notifyCacheEntryPassivated((Object)"k", (Object)"v", true, null, null);
        this.n.notifyCacheEntryPassivated((Object)"k", (Object)"v", false, null, null);
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPost());
        AssertJUnit.assertTrue((boolean)this.cl.isReceivedPre());
        AssertJUnit.assertEquals((int)2, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_PASSIVATED, (Object)this.cl.getEvents().get(0).getType());
        CacheEntryPassivatedEvent event = (CacheEntryPassivatedEvent)this.cl.getEvents().get(0);
        AssertJUnit.assertEquals((Object)"k", (Object)event.getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_PASSIVATED), (Object)((CacheEntryEvent)this.cl.getEvents().get(0)).getValue());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(1).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_PASSIVATED, (Object)this.cl.getEvents().get(1).getType());
        event = (CacheEntryPassivatedEvent)this.cl.getEvents().get(1);
        AssertJUnit.assertEquals((Object)"k", (Object)event.getKey());
        AssertJUnit.assertEquals((Object)this.getExpectedEventValue("k", "v", Event.Type.CACHE_ENTRY_PASSIVATED), (Object)((CacheEntryEvent)this.cl.getEvents().get(1)).getValue());
    }

    public void testNotifyTransactionCompleted() {
        GlobalTransaction tx = (GlobalTransaction)Mockito.mock(GlobalTransaction.class);
        this.n.notifyTransactionCompleted(tx, true, this.ctx);
        this.n.notifyTransactionCompleted(tx, false, this.ctx);
        AssertJUnit.assertEquals((int)2, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.TRANSACTION_COMPLETED, (Object)this.cl.getEvents().get(0).getType());
        AssertJUnit.assertTrue((boolean)((TransactionCompletedEvent)this.cl.getEvents().get(0)).isTransactionSuccessful());
        AssertJUnit.assertEquals((Object)((TransactionCompletedEvent)this.cl.getEvents().get(0)).getGlobalTransaction(), (Object)tx);
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(1).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.TRANSACTION_COMPLETED, (Object)this.cl.getEvents().get(1).getType());
        AssertJUnit.assertTrue((!((TransactionCompletedEvent)this.cl.getEvents().get(1)).isTransactionSuccessful() ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)((TransactionCompletedEvent)this.cl.getEvents().get(1)).getGlobalTransaction(), (Object)tx);
    }

    public void testNotifyTransactionRegistered() {
        GlobalTransaction tx = (GlobalTransaction)Mockito.mock(GlobalTransaction.class);
        this.n.notifyTransactionRegistered(tx, false);
        this.n.notifyTransactionRegistered(tx, false);
        AssertJUnit.assertEquals((int)2, (int)this.cl.getInvocationCount());
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(0).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.TRANSACTION_REGISTERED, (Object)this.cl.getEvents().get(0).getType());
        AssertJUnit.assertEquals((Object)((TransactionRegisteredEvent)this.cl.getEvents().get(0)).getGlobalTransaction(), (Object)tx);
        AssertJUnit.assertEquals((Object)this.mockCache, (Object)this.cl.getEvents().get(1).getCache());
        AssertJUnit.assertEquals((Object)Event.Type.TRANSACTION_REGISTERED, (Object)this.cl.getEvents().get(1).getType());
        AssertJUnit.assertEquals((Object)((TransactionRegisteredEvent)this.cl.getEvents().get(1)).getGlobalTransaction(), (Object)tx);
    }
}

