/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.CacheNotifierPersistenceFilterTest")
public class CacheNotifierPersistenceFilterTest
extends MultipleCacheManagersTest {
    protected final String CACHE_NAME = "testCache";
    protected ConfigurationBuilder builderUsed;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builderUsed = new ConfigurationBuilder();
        this.builderUsed.clustering().cacheMode(CacheMode.REPL_SYNC);
        ((DummyInMemoryStoreConfigurationBuilder)this.builderUsed.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName("testCache");
        this.createClusteredCaches(3, "testCache", this.builderUsed);
    }

    @Test
    public void testPassivationBlocked() {
        String key = "key";
        String value = "value";
        Cache cache0 = this.cache(0, "testCache");
        AllCacheEntryListener listener = new AllCacheEntryListener();
        cache0.addListener((Object)listener, (CacheEventFilter)new EventKeyFilter(Event.Type.CACHE_ENTRY_PASSIVATED, key), null);
        PassivationManager passivationManager = (PassivationManager)cache0.getAdvancedCache().getComponentRegistry().getComponent(PassivationManager.class);
        CompletionStages.join((CompletionStage)passivationManager.passivateAsync((InternalCacheEntry)new ImmortalCacheEntry((Object)key, (Object)value)));
        AssertJUnit.assertEquals((int)2, (int)listener.events.size());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_PASSIVATED, (Object)((CacheEntryEvent)listener.events.get(0)).getType());
        AssertJUnit.assertEquals((Object)key, (Object)((CacheEntryEvent)listener.events.get(0)).getKey());
        AssertJUnit.assertEquals((Object)value, (Object)((CacheEntryEvent)listener.events.get(0)).getValue());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_PASSIVATED, (Object)((CacheEntryEvent)listener.events.get(1)).getType());
        AssertJUnit.assertEquals((Object)key, (Object)((CacheEntryEvent)listener.events.get(1)).getKey());
        AssertJUnit.assertNull((Object)((CacheEntryEvent)listener.events.get(1)).getValue());
        CompletionStages.join((CompletionStage)passivationManager.passivateAsync((InternalCacheEntry)new ImmortalCacheEntry((Object)("not" + key), (Object)value)));
        AssertJUnit.assertEquals((int)2, (int)listener.events.size());
    }

    @Test
    public void testActivationBlocked() {
        String key = "key";
        String value = "value";
        Cache cache0 = this.cache(0, "testCache");
        PassivationManager passivationManager = (PassivationManager)cache0.getAdvancedCache().getComponentRegistry().getComponent(PassivationManager.class);
        CompletionStages.join((CompletionStage)passivationManager.passivateAsync((InternalCacheEntry)new ImmortalCacheEntry((Object)key, (Object)value)));
        CompletionStages.join((CompletionStage)passivationManager.passivateAsync((InternalCacheEntry)new ImmortalCacheEntry((Object)("not" + key), (Object)value)));
        AllCacheEntryListener listener = new AllCacheEntryListener();
        cache0.addListener((Object)listener, (CacheEventFilter)new EventKeyFilter(Event.Type.CACHE_ENTRY_ACTIVATED, key), null);
        AssertJUnit.assertEquals((String)value, (String)((String)cache0.get((Object)("not" + key))));
        AssertJUnit.assertEquals((int)0, (int)listener.events.size());
        AssertJUnit.assertEquals((String)value, (String)((String)cache0.get((Object)key)));
        AssertJUnit.assertEquals((int)2, (int)listener.events.size());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_ACTIVATED, (Object)((CacheEntryEvent)listener.events.get(0)).getType());
        AssertJUnit.assertEquals((Object)key, (Object)((CacheEntryEvent)listener.events.get(0)).getKey());
        AssertJUnit.assertEquals((Object)value, (Object)((CacheEntryEvent)listener.events.get(0)).getValue());
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_ACTIVATED, (Object)((CacheEntryEvent)listener.events.get(0)).getType());
        AssertJUnit.assertEquals((Object)key, (Object)((CacheEntryEvent)listener.events.get(1)).getKey());
        AssertJUnit.assertEquals((Object)value, (Object)((CacheEntryEvent)listener.events.get(1)).getValue());
    }

    @Listener
    private static class AllCacheEntryListener {
        private final List<CacheEntryEvent> events = Collections.synchronizedList(new ArrayList());

        private AllCacheEntryListener() {
        }

        @CacheEntryVisited
        @CacheEntryActivated
        @CacheEntryModified
        @CacheEntryRemoved
        @CacheEntryCreated
        @CacheEntryInvalidated
        @CacheEntryPassivated
        public void listenEvent(CacheEntryEvent event) {
            this.events.add(event);
        }
    }

    @Listener
    private static class TestListener {
        private final List<CacheEntryVisitedEvent> visitedEvents = Collections.synchronizedList(new ArrayList());
        private final List<TopologyChangedEvent> topologyEvents = Collections.synchronizedList(new ArrayList());

        private TestListener() {
        }

        @CacheEntryVisited
        public void entryVisited(CacheEntryVisitedEvent event) {
            this.visitedEvents.add(event);
        }

        @TopologyChanged
        public void topologyChanged(TopologyChangedEvent event) {
            this.topologyEvents.add(event);
        }
    }

    private static class EventKeyFilter
    implements CacheEventFilter<String, String> {
        private final Event.Type type;
        private final Object key;

        public EventKeyFilter(Event.Type type, Object key) {
            this.type = type;
            this.key = key;
        }

        public boolean accept(String key, String oldValue, Metadata oldMetadata, String newValue, Metadata newMetadata, EventType eventType) {
            boolean accept = this.type == eventType.getType() && this.key.equals(key);
            return accept;
        }
    }
}

