/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.Arrays;
import java.util.Collection;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheListener;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.filter.AbstractCacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.MultipleListenerConverterTest")
public class MultipleListenerConverterTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager(new ConfigurationBuilder());
    }

    public void testMultipleListenersWithDifferentConverters() {
        CacheListener listener1 = new CacheListener();
        CacheListener listener2 = new CacheListener();
        CacheListener listener3 = new CacheListener();
        this.cache.addListener((Object)listener1, null, (CacheEventConverter)new StringConverter("listener-1"));
        this.cache.addListener((Object)listener2, null, (CacheEventConverter)new StringConverter("listener-2"));
        this.cache.addListener((Object)listener3, null, (CacheEventConverter)new StringConverter("listener-3"));
        this.insertKeyValueAndVerifyListenerNotifications(Arrays.asList(listener1, listener2, listener3));
    }

    public void testMultipleListenersWithDifferentFilterConverters() {
        CacheListener listener1 = new CacheListener();
        CacheListener listener2 = new CacheListener();
        CacheListener listener3 = new CacheListener();
        StringFilterConverter filterConverter1 = new StringFilterConverter("listener-1");
        StringFilterConverter filterConverter2 = new StringFilterConverter("listener-2");
        StringFilterConverter filterConverter3 = new StringFilterConverter("listener-3");
        this.cache.addListener((Object)listener1, (CacheEventFilter)filterConverter1, (CacheEventConverter)filterConverter1);
        this.cache.addListener((Object)listener2, (CacheEventFilter)filterConverter2, (CacheEventConverter)filterConverter2);
        this.cache.addListener((Object)listener3, (CacheEventFilter)filterConverter3, (CacheEventConverter)filterConverter3);
        this.insertKeyValueAndVerifyListenerNotifications(Arrays.asList(listener1, listener2, listener3));
    }

    private void insertKeyValueAndVerifyListenerNotifications(Collection<CacheListener> listeners) {
        this.cache.put((Object)"key", (Object)"value");
        int i = 1;
        for (CacheListener listener : listeners) {
            AssertJUnit.assertEquals((String)("Listener" + i + "failed"), (int)2, (int)listener.getEvents().size());
            Event event = listener.getEvents().get(0);
            AssertJUnit.assertEquals((String)("Listener" + i + "failed"), (Object)Event.Type.CACHE_ENTRY_CREATED, (Object)event.getType());
            CacheEntryCreatedEvent createdEvent = (CacheEntryCreatedEvent)event;
            AssertJUnit.assertTrue((String)("Listener" + i + "failed"), (boolean)createdEvent.isPre());
            AssertJUnit.assertEquals((String)("Listener" + i + "failed"), (Object)"key", (Object)createdEvent.getKey());
            AssertJUnit.assertEquals((String)("Listener" + i + "failed"), (Object)("null-listener-" + i), (Object)createdEvent.getValue());
            event = listener.getEvents().get(1);
            AssertJUnit.assertEquals((String)("Listener" + i + "failed"), (Object)Event.Type.CACHE_ENTRY_CREATED, (Object)event.getType());
            createdEvent = (CacheEntryCreatedEvent)event;
            AssertJUnit.assertFalse((String)("Listener" + i + "failed"), (boolean)createdEvent.isPre());
            AssertJUnit.assertEquals((String)("Listener" + i + "failed"), (Object)"key", (Object)createdEvent.getKey());
            AssertJUnit.assertEquals((String)("Listener" + i + "failed"), (Object)("value-listener-" + i), (Object)createdEvent.getValue());
            ++i;
        }
    }

    private static class StringFilterConverter
    extends AbstractCacheEventFilterConverter {
        private final String append;

        public StringFilterConverter(String append) {
            this.append = append;
        }

        public Object filterAndConvert(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
            return String.valueOf(newValue) + "-" + this.append;
        }
    }

    private static class StringConverter
    implements CacheEventConverter<Object, Object, String> {
        private final String append;

        public StringConverter(String append) {
            this.append = append;
        }

        public String convert(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
            return String.valueOf(newValue) + "-" + this.append;
        }
    }
}

