/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.TransactionSuspendedCacheNotifierTest")
@CleanupAfterMethod
public class TransactionSuspendedCacheNotifierTest
extends SingleCacheManagerTest {
    public void testTransactionSuspended() throws Exception {
        TestListener listener = new TestListener();
        this.cache.getAdvancedCache().addListener((Object)listener);
        AssertJUnit.assertTrue((boolean)this.cache.isEmpty());
        this.cache.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache.get((Object)"key"));
        this.cache.put((Object)"key", (Object)"new-value");
        AssertJUnit.assertEquals((Object)"new-value", (Object)this.cache.get((Object)"key"));
        this.tm().begin();
        AssertJUnit.assertEquals((Object)"new-value", (Object)this.cache.get((Object)"key"));
        this.tm().commit();
        this.cache.remove((Object)"key");
        AssertJUnit.assertNull((Object)this.cache.get((Object)"key"));
        this.cache.clear();
        AssertJUnit.assertTrue((boolean)this.cache.isEmpty());
        if (listener.list.size() > 0) {
            for (Throwable throwable : listener.list) {
                log.error((Object)"Error in listener...", throwable);
            }
            AssertJUnit.fail((String)"Listener catch some errors");
        }
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    @Listener(sync=true)
    public static class TestListener {
        private final Log log = LogFactory.getLog(TestListener.class);
        private final List<Throwable> list = Collections.synchronizedList(new ArrayList(2));

        @CacheEntryActivated
        @CacheEntryCreated
        @CacheEntriesEvicted
        @CacheEntryInvalidated
        @CacheEntryLoaded
        @CacheEntryModified
        @CacheEntryPassivated
        @CacheEntryRemoved
        @CacheEntryVisited
        @TransactionCompleted
        @TransactionRegistered
        public void handle(Event e) {
            try {
                Object value = e.getCache().getAdvancedCache().withFlags(Flag.SKIP_LISTENER_NOTIFICATION).get((Object)"key");
                this.log.debugf("Event=%s, value=%s", (Object)e, value);
            }
            catch (Throwable throwable) {
                this.list.add(throwable);
            }
        }
    }
}

