/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.MagicKey;
import org.infinispan.notifications.cachelistener.cluster.AbstractClusterListenerTest;
import org.infinispan.notifications.cachelistener.cluster.AbstractClusterListenerUtilTest;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractClusterListenerNonTxTest
extends AbstractClusterListenerTest {
    protected AbstractClusterListenerNonTxTest(boolean tx, CacheMode cacheMode) {
        super(tx, cacheMode);
    }

    @Test
    public void testPrimaryOwnerGoesDownAfterSendingEvent() throws InterruptedException, ExecutionException, TimeoutException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        CheckPoint checkPoint = new CheckPoint();
        this.waitUntilNotificationRaised(cache1, checkPoint);
        checkPoint.triggerForever("pre_raise_notification_release");
        MagicKey key = new MagicKey(cache1, cache2);
        Future<String> future = this.fork(() -> (String)cache0.put((Object)key, (Object)"first-value"));
        checkPoint.awaitStrict("post_raise_notification_invoked", 10L, TimeUnit.SECONDS);
        this.awaitForBackups(cache0);
        TestingUtil.killCacheManagers(cache1.getCacheManager());
        future.get(10L, TimeUnit.SECONDS);
        TestingUtil.waitForNoRebalance(cache0, cache2);
        AssertJUnit.assertTrue((String)("Expected 2 - 6 events, but received " + clusterListener.events), (clusterListener.events.size() >= 2 && clusterListener.events.size() <= 6 ? 1 : 0) != 0);
        this.checkEvent((CacheEntryEvent<Object, String>)clusterListener.events.get(0), key, true, false);
        Address cache0primary = TestingUtil.extractCacheTopology(cache0).getDistribution((Object)key).primary();
        Address cache2primary = TestingUtil.extractCacheTopology(cache2).getDistribution((Object)key).primary();
        AssertJUnit.assertEquals((Object)cache0primary, (Object)cache2primary);
        clusterListener.events.stream().skip(1L).forEach(e -> this.checkEvent((CacheEntryEvent<Object, String>)e, key, false, true));
    }

    protected void checkEvent(CacheEntryEvent<Object, String> event, MagicKey key, boolean isCreated, boolean isRetried) {
        if (isCreated) {
            AssertJUnit.assertEquals((Object)event.getType(), (Object)Event.Type.CACHE_ENTRY_CREATED);
            CacheEntryCreatedEvent createEvent = (CacheEntryCreatedEvent)event;
            AssertJUnit.assertEquals((boolean)createEvent.isCommandRetried(), (boolean)isRetried);
        } else {
            AssertJUnit.assertEquals((Object)event.getType(), (Object)Event.Type.CACHE_ENTRY_MODIFIED);
            CacheEntryModifiedEvent modEvent = (CacheEntryModifiedEvent)event;
            AssertJUnit.assertTrue((boolean)modEvent.isCommandRetried());
        }
        AssertJUnit.assertEquals((Object)event.getKey(), (Object)key);
        AssertJUnit.assertEquals((String)((String)event.getValue()), (String)"first-value");
    }

    protected void awaitForBackups(Cache<?, ?> cache) {
        if (TestingUtil.isTriangleAlgorithm(this.cacheMode, this.tx)) {
            CommandAckCollector collector = TestingUtil.extractComponent(cache, CommandAckCollector.class);
            List pendingCommands = collector.getPendingCommands();
            AssertJUnit.assertEquals((int)1, (int)pendingCommands.size());
            this.eventually(() -> !collector.hasPendingBackupAcks(((Long)pendingCommands.get(0)).longValue()));
        }
    }
}

