/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.MagicKey;
import org.infinispan.notifications.cachelistener.cluster.AbstractClusterListenerUtilTest;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.KeyValueFilterAsCacheEventFilter;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractClusterListenerTest
extends AbstractClusterListenerUtilTest {
    protected AbstractClusterListenerTest(boolean tx, CacheMode cacheMode) {
        super(tx, cacheMode);
    }

    protected AbstractClusterListenerUtilTest.ClusterListener listener() {
        return new AbstractClusterListenerUtilTest.ClusterListener(this);
    }

    @Test
    public void testCreateFromNonOwnerWithListenerNotOwner() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        MagicKey key = new MagicKey(cache1, cache2);
        this.verifySimpleInsertion(cache2, key, "first-value", null, clusterListener, "first-value");
    }

    @Test
    public void testCreateFromNonOwnerWithListenerAsBackupOwner() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        MagicKey key = new MagicKey(cache1, cache0);
        this.verifySimpleInsertion(cache2, key, "first-value", null, clusterListener, "first-value");
    }

    @Test
    public void testLocalNodeOwnerAndClusterListener() {
        Cache cache0 = this.cache(0, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        MagicKey key = new MagicKey(cache0);
        this.verifySimpleInsertion(cache0, key, "first-value", null, clusterListener, "first-value");
    }

    @Test
    public void testLocalNodeNonOwnerAndClusterListener() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        MagicKey key = new MagicKey(cache1, cache2);
        this.verifySimpleInsertion(cache0, key, "first-value", null, clusterListener, "first-value");
    }

    @Test
    public void testSimpleFilterNotOwner() {
        this.testSimpleFilter(new MagicKey(this.cache(1, "cluster-listener"), this.cache(2, "cluster-listener")));
    }

    @Test
    public void testSimpleFilterLocalOnly() {
        this.testSimpleFilter(new MagicKey(this.cache(0, "cluster-listener")));
    }

    @Test
    public void testMetadataFilterNotOwner() {
        String keyToFilterOut = "filter-me";
        this.testFilter("filter-me", new MagicKey(this.cache(1, "cluster-listener"), this.cache(2, "cluster-listener")), 1000L, (CacheEventFilter<? super Object, ? super String>)new KeyValueFilterAsCacheEventFilter(new AbstractClusterListenerUtilTest.LifespanFilter(100L)));
    }

    @Test
    public void testMetadataFilterLocalOnly() {
        String keyToFilterOut = "filter-me";
        this.testFilter("filter-me", new MagicKey(this.cache(0, "cluster-listener")), 1000L, (CacheEventFilter<? super Object, ? super String>)new KeyValueFilterAsCacheEventFilter(new AbstractClusterListenerUtilTest.LifespanFilter(100L)));
    }

    protected void testSimpleFilter(Object key) {
        String keyToFilterOut = "filter-me";
        this.testFilter("filter-me", key, null, this.filter(key));
    }

    protected void testFilter(Object keyToFilterOut, Object keyToUse, Long lifespan, CacheEventFilter<? super Object, ? super String> filter) {
        Cache cache0 = this.cache(0, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener, filter, null);
        cache0.put(keyToFilterOut, (Object)"first-value");
        AssertJUnit.assertEquals((int)clusterListener.events.size(), (int)0);
        this.verifySimpleInsertion(cache0, keyToUse, "first-value", lifespan, clusterListener, "first-value");
    }

    @Test
    public void testSimpleConverterNotOwner() {
        this.testSimpleConverter(new MagicKey(this.cache(1, "cluster-listener"), this.cache(2, "cluster-listener")));
    }

    @Test
    public void testSimpleConverterLocalOnly() {
        this.testSimpleConverter(new MagicKey(this.cache(0, "cluster-listener")));
    }

    @Test
    public void testMetadataConverterSuccessNotOwner() {
        long lifespan = 25000L;
        AbstractClusterListenerUtilTest.LifespanConverter converter = new AbstractClusterListenerUtilTest.LifespanConverter(true, 500L);
        this.testConverter(new MagicKey(this.cache(1, "cluster-listener"), this.cache(2, "cluster-listener")), "first-value", lifespan, lifespan, converter);
    }

    @Test
    public void testMetadataConverterSuccessLocalOnly() {
        long lifespan = 25000L;
        AbstractClusterListenerUtilTest.LifespanConverter converter = new AbstractClusterListenerUtilTest.LifespanConverter(true, 500L);
        this.testConverter(new MagicKey(this.cache(0, "cluster-listener")), "first-value", lifespan, lifespan, converter);
    }

    @Test
    public void testMetadataConverterNoPassReturnOriginalNotOwner() {
        long lifespan = 25000L;
        AbstractClusterListenerUtilTest.LifespanConverter converter = new AbstractClusterListenerUtilTest.LifespanConverter(true, Long.MAX_VALUE);
        this.testConverter(new MagicKey(this.cache(1, "cluster-listener"), this.cache(2, "cluster-listener")), "first-value", "first-value", lifespan, converter);
    }

    @Test
    public void testMetadataConverterNoPassReturnOriginalLocalOnly() {
        long lifespan = 25000L;
        AbstractClusterListenerUtilTest.LifespanConverter converter = new AbstractClusterListenerUtilTest.LifespanConverter(true, Long.MAX_VALUE);
        this.testConverter(new MagicKey(this.cache(0, "cluster-listener")), "first-value", "first-value", lifespan, converter);
    }

    @Test
    public void testMetadataConverterNoPassReturnNullNotOwner() {
        long lifespan = 25000L;
        AbstractClusterListenerUtilTest.LifespanConverter converter = new AbstractClusterListenerUtilTest.LifespanConverter(false, Long.MAX_VALUE);
        this.testConverter(new MagicKey(this.cache(1, "cluster-listener"), this.cache(2, "cluster-listener")), "first-value", null, lifespan, converter);
    }

    @Test
    public void testMetadataConverterNoPassReturnNullLocalOnly() {
        long lifespan = 25000L;
        AbstractClusterListenerUtilTest.LifespanConverter converter = new AbstractClusterListenerUtilTest.LifespanConverter(false, Long.MAX_VALUE);
        this.testConverter(new MagicKey(this.cache(0, "cluster-listener")), "first-value", null, lifespan, converter);
    }

    protected void testSimpleConverter(Object key) {
        Cache cache0 = this.cache(0, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener, null, (CacheEventConverter)new AbstractClusterListenerUtilTest.StringTruncator(0, 2));
        this.verifySimpleInsertion(cache0, key, "first-value", null, clusterListener, "first-value".substring(0, 2));
    }

    protected <C> void testConverter(Object key, String value, Object resultingValue, Long lifespan, CacheEventConverter<Object, ? super String, C> converter) {
        Cache cache0 = this.cache(0, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener, null, converter);
        this.verifySimpleInsertion(cache0, key, value, lifespan, clusterListener, resultingValue);
    }

    @Test
    public void testClusterListenerNodeGoesDown() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        int cache1ListenerSize = cache1.getAdvancedCache().getListeners().size();
        int cache2ListenerSize = cache2.getAdvancedCache().getListeners().size();
        log.info((Object)"Killing node 0 ..");
        TestingUtil.killCacheManagers(this.manager(0));
        this.cacheManagers.remove(0);
        log.info((Object)"Node 0 killed");
        TestingUtil.blockUntilViewsReceived(60000L, false, cache1, cache2);
        TestingUtil.waitForNoRebalance(cache1, cache2);
        AssertJUnit.assertEquals((int)cache1.getAdvancedCache().getListeners().size(), (int)(cache1ListenerSize - (this.cacheMode.isDistributed() ? 1 : 0)));
        AssertJUnit.assertEquals((int)cache2.getAdvancedCache().getListeners().size(), (int)(cache2ListenerSize - (this.cacheMode.isDistributed() ? 1 : 0)));
    }

    @Test
    public void testNodeComesUpWithClusterListenerAlreadyInstalled() {
        Cache cache0 = this.cache(0, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        this.addClusteredCacheManager();
        this.waitForClusterToForm("cluster-listener");
        Cache cache3 = this.cache(3, "cluster-listener");
        MagicKey key = new MagicKey(cache3);
        this.verifySimpleInsertion(cache3, key, "first-value", null, clusterListener, "first-value");
    }

    @Test
    public void testNodeComesUpWithClusterListenerAlreadyInstalledFilterAndConverter() {
        String keyToFilter = "filter-me";
        Cache cache0 = this.cache(0, "cluster-listener");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener, this.filter("filter-me"), (CacheEventConverter)new AbstractClusterListenerUtilTest.StringTruncator(0, 3));
        this.addClusteredCacheManager();
        this.waitForClusterToForm("cluster-listener");
        Cache cache3 = this.cache(3, "cluster-listener");
        MagicKey key = new MagicKey(cache3);
        cache3.put((Object)key, (Object)"first-value");
        AssertJUnit.assertEquals((int)clusterListener.events.size(), (int)0);
        this.verifySimpleInsertion(cache3, "filter-me", "first-value", null, clusterListener, "first-value".substring(0, 3));
    }

    @Test
    public void testSimpleClusterListenerRemoved() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        int initialCache0ListenerSize = cache0.getAdvancedCache().getListeners().size();
        int initialCache1ListenerSize = cache1.getAdvancedCache().getListeners().size();
        int initialCache2ListenerSize = cache2.getAdvancedCache().getListeners().size();
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        AssertJUnit.assertEquals((int)cache0.getAdvancedCache().getListeners().size(), (int)(initialCache0ListenerSize + 1));
        AssertJUnit.assertEquals((int)cache1.getAdvancedCache().getListeners().size(), (int)(initialCache1ListenerSize + (this.cacheMode.isDistributed() ? 1 : 0)));
        AssertJUnit.assertEquals((int)cache2.getAdvancedCache().getListeners().size(), (int)(initialCache2ListenerSize + (this.cacheMode.isDistributed() ? 1 : 0)));
        cache0.removeListener((Object)clusterListener);
        AssertJUnit.assertEquals((int)cache0.getAdvancedCache().getListeners().size(), (int)initialCache0ListenerSize);
        AssertJUnit.assertEquals((int)cache1.getAdvancedCache().getListeners().size(), (int)initialCache1ListenerSize);
        AssertJUnit.assertEquals((int)cache2.getAdvancedCache().getListeners().size(), (int)initialCache2ListenerSize);
    }

    @Test
    public void testClusterListenerRemovedWithMultipleInstalledOnSameNode() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        int initialCache0ListenerSize = cache0.getAdvancedCache().getListeners().size();
        int initialCache1ListenerSize = cache1.getAdvancedCache().getListeners().size();
        int initialCache2ListenerSize = cache2.getAdvancedCache().getListeners().size();
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        AssertJUnit.assertEquals((int)cache0.getAdvancedCache().getListeners().size(), (int)(initialCache0ListenerSize + 1));
        AssertJUnit.assertEquals((int)cache1.getAdvancedCache().getListeners().size(), (int)(initialCache1ListenerSize + (this.cacheMode.isDistributed() ? 1 : 0)));
        AssertJUnit.assertEquals((int)cache2.getAdvancedCache().getListeners().size(), (int)(initialCache2ListenerSize + (this.cacheMode.isDistributed() ? 1 : 0)));
        AbstractClusterListenerUtilTest.ClusterListener clusterListener2 = this.listener();
        cache0.addListener((Object)clusterListener2);
        AssertJUnit.assertEquals((int)cache0.getAdvancedCache().getListeners().size(), (int)(initialCache0ListenerSize + 2));
        AssertJUnit.assertEquals((int)cache1.getAdvancedCache().getListeners().size(), (int)(initialCache1ListenerSize + (this.cacheMode.isDistributed() ? 2 : 0)));
        AssertJUnit.assertEquals((int)cache2.getAdvancedCache().getListeners().size(), (int)(initialCache2ListenerSize + (this.cacheMode.isDistributed() ? 2 : 0)));
        MagicKey key = new MagicKey(cache2, cache1);
        cache1.put((Object)key, (Object)"first-value");
        AssertJUnit.assertEquals((int)clusterListener.events.size(), (int)1);
        AssertJUnit.assertEquals((int)clusterListener2.events.size(), (int)1);
        this.verifySimpleInsertionEvents(clusterListener, key, "first-value");
        this.verifySimpleInsertionEvents(clusterListener2, key, "first-value");
        cache0.removeListener((Object)clusterListener);
        AssertJUnit.assertEquals((int)cache0.getAdvancedCache().getListeners().size(), (int)(initialCache0ListenerSize + 1));
        AssertJUnit.assertEquals((int)cache1.getAdvancedCache().getListeners().size(), (int)(initialCache1ListenerSize + (this.cacheMode.isDistributed() ? 1 : 0)));
        AssertJUnit.assertEquals((int)cache2.getAdvancedCache().getListeners().size(), (int)(initialCache2ListenerSize + (this.cacheMode.isDistributed() ? 1 : 0)));
        cache2.put((Object)key, (Object)"second-value");
        AssertJUnit.assertEquals((int)clusterListener2.events.size(), (int)2);
        CacheEntryEvent event = clusterListener2.events.get(1);
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_MODIFIED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)key, (Object)event.getKey());
        AssertJUnit.assertEquals((Object)"second-value", (Object)((CacheEntryModifiedEvent)event).getValue());
    }

    @Test
    public void testMemberLeavesThatClusterListenerNotNotified() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        MagicKey key = new MagicKey(cache1, cache2);
        cache1.put((Object)key, (Object)"some-key");
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        log.info((Object)"Killing node 1 ..");
        TestingUtil.killCacheManagers(this.manager(1));
        this.cacheManagers.remove(1);
        log.info((Object)"Node 1 killed");
        TestingUtil.blockUntilViewsReceived(10000, false, this.cacheManagers);
        TestingUtil.waitForNoRebalance(this.caches("cluster-listener"));
        AssertJUnit.assertEquals((int)(clusterListener.hasIncludeState() ? 1 : 0), (int)clusterListener.events.size());
    }

    @Test
    public void testPreviousValueConverterEventRaisedLocalNode() {
        Cache cache0 = this.cache(0, "cluster-listener");
        String previousValue = "myOldValue";
        long previousExpiration = 10000000L;
        MagicKey key = new MagicKey(cache0);
        cache0.put((Object)key, (Object)previousValue, previousExpiration, TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener, null, (CacheEventConverter)new AbstractClusterListenerUtilTest.StringAppender());
        String newValue = "myBrandSpankingNewValue";
        long newExpiration = 314159L;
        this.verifySimpleModification(cache0, key, newValue, newExpiration, clusterListener, previousValue + previousExpiration + newValue + newExpiration);
    }

    @Test
    public void testPreviousValueConverterEventRaisedNonOwnerNode() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        String previousValue = "myOldValue";
        long previousExpiration = 10000000L;
        MagicKey key = new MagicKey(cache0, cache1);
        cache0.put((Object)key, (Object)previousValue, previousExpiration, TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache2.addListener((Object)clusterListener, null, (CacheEventConverter)new AbstractClusterListenerUtilTest.StringAppender());
        String newValue = "myBrandSpankingNewValue";
        long newExpiration = 314159L;
        this.verifySimpleModification(cache0, key, newValue, newExpiration, clusterListener, previousValue + previousExpiration + newValue + newExpiration);
    }

    @Test
    public void testPreviousValueConverterEventRaisedBackupOwnerNode() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        String previousValue = "myOldValue";
        long previousExpiration = 10000000L;
        MagicKey key = new MagicKey(cache0, cache1);
        cache0.put((Object)key, (Object)previousValue, previousExpiration, TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache1.addListener((Object)clusterListener, null, (CacheEventConverter)new AbstractClusterListenerUtilTest.StringAppender());
        String newValue = "myBrandSpankingNewValue";
        long newExpiration = 314159265L;
        this.verifySimpleModification(cache0, key, newValue, newExpiration, clusterListener, previousValue + previousExpiration + newValue + newExpiration);
    }

    @Test
    public void testPreviousValueFilterEventRaisedLocalNode() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        String previousValue = "myOldValue";
        long previousExpiration = 10000000L;
        MagicKey key = new MagicKey(cache0, cache1);
        cache0.put((Object)key, (Object)previousValue, previousExpiration, TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache1.addListener((Object)clusterListener, new AbstractClusterListenerUtilTest.NewLifespanLargerFilter(), null);
        cache0.put((Object)key, (Object)previousValue, previousExpiration - 100L, TimeUnit.MILLISECONDS);
        String newValue = "myBrandSpankingNewValue";
        long newExpiration = 314159265L;
        this.verifySimpleModification(cache0, key, newValue, newExpiration, clusterListener, newValue);
    }

    @Test
    public void testPreviousValueFilterEventRaisedNonOwnerNode() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        String previousValue = "myOldValue";
        long previousExpiration = 10000000L;
        MagicKey key = new MagicKey(cache0, cache1);
        cache0.put((Object)key, (Object)previousValue, previousExpiration, TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache2.addListener((Object)clusterListener, new AbstractClusterListenerUtilTest.NewLifespanLargerFilter(), null);
        cache0.put((Object)key, (Object)previousValue, previousExpiration - 100L, TimeUnit.MILLISECONDS);
        String newValue = "myBrandSpankingNewValue";
        long newExpiration = 314159265L;
        this.verifySimpleModification(cache0, key, newValue, newExpiration, clusterListener, newValue);
    }

    @Test
    public void testPreviousValueFilterEventRaisedBackupOwnerNode() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        String previousValue = "myOldValue";
        long previousExpiration = 10000000L;
        MagicKey key = new MagicKey(cache0, cache1);
        cache0.put((Object)key, (Object)previousValue, previousExpiration, TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache1.addListener((Object)clusterListener, new AbstractClusterListenerUtilTest.NewLifespanLargerFilter(), null);
        cache0.put((Object)key, (Object)previousValue, previousExpiration - 100L, TimeUnit.MILLISECONDS);
        String newValue = "myBrandSpankingNewValue";
        long newExpiration = 314159265L;
        this.verifySimpleModification(cache0, key, newValue, newExpiration, clusterListener, newValue);
    }

    @Test
    public void testCacheEventFilterConverter() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(0, "cluster-listener");
        Cache cache2 = this.cache(0, "cluster-listener");
        String convertedValue = "my-value";
        AbstractClusterListenerUtilTest.FilterConverter filterConverter = new AbstractClusterListenerUtilTest.FilterConverter(true, convertedValue);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener, (CacheEventFilter)filterConverter, (CacheEventConverter)filterConverter);
        MagicKey key = new MagicKey(cache1, cache2);
        this.verifySimpleInsertion(cache0, key, "doesn't-matter", null, clusterListener, convertedValue);
    }

    @Test
    public void testListenerOnPrimaryNodeReadPrimary() {
        Cache cache0 = this.cache(0, "cluster-listener");
        MagicKey key = new MagicKey(cache0);
        String expectedValue = key + "-expiring";
        cache0.put((Object)key, (Object)(key + "-expiring"), 10L, TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        this.ts0.advance(11L);
        AssertJUnit.assertNull((Object)cache0.get((Object)key));
        int expectCount = clusterListener.hasIncludeState() ? 2 : 1;
        this.eventually(() -> clusterListener.events.size() >= expectCount, 200000L);
        AssertJUnit.assertEquals((int)expectCount, (int)clusterListener.events.size());
        CacheEntryEvent event = clusterListener.events.get(clusterListener.hasIncludeState() ? 1 : 0);
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_EXPIRED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)key, (Object)event.getKey());
        AssertJUnit.assertEquals((Object)expectedValue, (Object)event.getValue());
    }

    @Test
    public void testListenerOnPrimaryNodeReadBackup() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        MagicKey key = new MagicKey(cache0, cache1);
        String expectedValue = key + "-expiring";
        cache0.put((Object)key, (Object)(key + "-expiring"), 10L, TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        this.ts1.advance(11L);
        AssertJUnit.assertNull((Object)cache1.get((Object)key));
        int expectCount = clusterListener.hasIncludeState() ? 2 : 1;
        this.eventually(() -> clusterListener.events.size() >= expectCount);
        AssertJUnit.assertEquals((int)expectCount, (int)clusterListener.events.size());
        CacheEntryEvent event = clusterListener.events.get(clusterListener.hasIncludeState() ? 1 : 0);
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_EXPIRED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)key, (Object)event.getKey());
        AssertJUnit.assertEquals((Object)expectedValue, (Object)event.getValue());
    }

    public void testListenerOnBackupOwnerNodePrimaryRead() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        MagicKey key = new MagicKey(cache0, cache1);
        String expectedValue = key + "-expiring";
        cache0.put((Object)key, (Object)(key + "-expiring"), 10L, TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache1.addListener((Object)clusterListener);
        this.ts0.advance(11L);
        this.ts1.advance(11L);
        this.ts2.advance(11L);
        AssertJUnit.assertNull((Object)cache0.get((Object)key));
        int expectCount = clusterListener.hasIncludeState() ? 2 : 1;
        this.eventually(() -> clusterListener.events.size() >= expectCount);
        AssertJUnit.assertEquals((int)expectCount, (int)clusterListener.events.size());
        CacheEntryEvent event = clusterListener.events.get(clusterListener.hasIncludeState() ? 1 : 0);
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_EXPIRED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)key, (Object)event.getKey());
        AssertJUnit.assertEquals((Object)expectedValue, (Object)event.getValue());
    }

    public void testListenerOnBackupOwnerNodeBackupRead() {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        MagicKey key = new MagicKey(cache0, cache1);
        String expectedValue = key + "-expiring";
        cache0.put((Object)key, (Object)(key + "-expiring"), 10L, TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        this.ts1.advance(11L);
        AssertJUnit.assertNull((Object)cache1.get((Object)key));
        int expectCount = clusterListener.hasIncludeState() ? 2 : 1;
        this.eventually(() -> clusterListener.events.size() >= expectCount);
        AssertJUnit.assertEquals((int)expectCount, (int)clusterListener.events.size());
        CacheEntryEvent event = clusterListener.events.get(clusterListener.hasIncludeState() ? 1 : 0);
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_EXPIRED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)key, (Object)event.getKey());
        AssertJUnit.assertEquals((Object)expectedValue, (Object)event.getValue());
    }

    public void testAllExpire() throws InterruptedException {
        Cache cache0 = this.cache(0, "cluster-listener");
        Cache cache1 = this.cache(1, "cluster-listener");
        Cache cache2 = this.cache(2, "cluster-listener");
        MagicKey key = new MagicKey(cache0);
        String expectedValue = key + "-expiring";
        cache0.put((Object)key, (Object)(key + "-expiring"), 1000L, TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener);
        this.advanceTimeServices(1001L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertNull((Object)cache0.get((Object)key));
        AssertJUnit.assertNull((Object)cache1.get((Object)key));
        AssertJUnit.assertNull((Object)cache2.get((Object)key));
        int expectCount = clusterListener.hasIncludeState() ? 2 : 1;
        this.eventually(() -> clusterListener.events.size() >= expectCount);
        CacheEntryEvent event = clusterListener.events.get(clusterListener.hasIncludeState() ? 1 : 0);
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_EXPIRED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)key, (Object)event.getKey());
        AssertJUnit.assertEquals((Object)expectedValue, (Object)event.getValue());
    }

    @Test
    public void testSimpleExpirationFilterNotOwner() {
        this.testSimpleExpirationFilter(new MagicKey(this.cache(1, "cluster-listener"), this.cache(2, "cluster-listener")));
    }

    @Test
    public void testExpirationMetadataFilterNotOwner() {
        String keyToFilterOut = "filter-me";
        this.testExpirationFilter("filter-me", 50L, new MagicKey(this.cache(1, "cluster-listener"), this.cache(2, "cluster-listener")), 1000L, (CacheEventFilter<? super Object, ? super String>)new KeyValueFilterAsCacheEventFilter(new AbstractClusterListenerUtilTest.LifespanFilter(100L)));
    }

    protected void testSimpleExpirationFilter(Object key) {
        String keyToFilterOut = "filter-me";
        long commonLifespan = 1000L;
        this.testExpirationFilter("filter-me", 1000L, key, 1000L, this.filter(key));
    }

    protected void testExpirationFilter(Object keyToFilterOut, Long keyToFilterOutLifespan, Object keyToUse, Long keyToUselifespan, CacheEventFilter<? super Object, ? super String> filter) {
        Cache cache0 = this.cache(0, "cluster-listener");
        cache0.put(keyToFilterOut, (Object)"first-value", keyToFilterOutLifespan.longValue(), TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener, filter, null);
        this.advanceTimeServices(keyToFilterOutLifespan + 1L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertNull((Object)cache0.get(keyToFilterOut));
        AssertJUnit.assertEquals((int)clusterListener.events.size(), (int)0);
        String expectedValue = keyToUse + "-expiring";
        cache0.put(keyToUse, (Object)(keyToUse + "-expiring"), keyToUselifespan.longValue(), TimeUnit.MILLISECONDS);
        this.advanceTimeServices(keyToUselifespan + 1L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertNull((Object)cache0.get(keyToUse));
        this.verifySimpleExpirationEvents(clusterListener, 2, keyToUse, expectedValue);
    }

    @Test
    public void testSimpleExpirationConverterNotOwner() {
        long lifespan = 1000L;
        AbstractClusterListenerUtilTest.StringTruncator converter = new AbstractClusterListenerUtilTest.StringTruncator(0, 2);
        this.testExpirationConverter(new MagicKey(this.cache(1, "cluster-listener"), this.cache(2, "cluster-listener")), "first-value", "first-value".substring(0, 2), lifespan, converter);
    }

    @Test
    public void testMetadataExpirationConverterSuccessNotOwner() {
        long lifespan = 25000L;
        AbstractClusterListenerUtilTest.LifespanConverter converter = new AbstractClusterListenerUtilTest.LifespanConverter(true, 500L);
        this.testExpirationConverter(new MagicKey(this.cache(1, "cluster-listener"), this.cache(2, "cluster-listener")), "first-value", lifespan, lifespan, converter);
    }

    protected <C> void testExpirationConverter(Object key, String value, Object expectedValue, Long lifespan, CacheEventConverter<Object, ? super String, C> converter) {
        Cache cache0 = this.cache(0, "cluster-listener");
        cache0.put(key, (Object)value, lifespan.longValue(), TimeUnit.MILLISECONDS);
        AbstractClusterListenerUtilTest.ClusterListener clusterListener = this.listener();
        cache0.addListener((Object)clusterListener, null, converter);
        this.advanceTimeServices(lifespan + 1L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertNull((Object)cache0.get(key));
        this.verifySimpleExpirationEvents(clusterListener, clusterListener.hasIncludeState() ? 2 : 1, key, expectedValue);
    }

    private CacheEventFilter<Object, String> filter(Object keyToFilter) {
        return (CacheEventFilter & Serializable)(k, oldValue, oldMetadata, newValue, newMetadata, eventType) -> Objects.equals(k, keyToFilter);
    }
}

