/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.ListenerHolder;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.cluster.ClusterCacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.ListenerSerializationContextImpl;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.concurrent.IsolationLevel;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;

public abstract class AbstractClusterListenerUtilTest
extends MultipleCacheManagersTest {
    protected static final String CACHE_NAME = "cluster-listener";
    protected static final String FIRST_VALUE = "first-value";
    protected static final String SECOND_VALUE = "second-value";
    protected ConfigurationBuilder builderUsed;
    protected SerializationContextInitializer sci;
    protected final boolean tx;
    protected final CacheMode cacheMode;
    protected ControlledTimeService ts0;
    protected ControlledTimeService ts1;
    protected ControlledTimeService ts2;

    protected AbstractClusterListenerUtilTest(boolean tx, CacheMode cacheMode) {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
        this.tx = tx;
        this.cacheMode = cacheMode;
        this.sci = new ListenerSerializationContextImpl();
    }

    protected void addClusteredCacheManager() {
        log.info((Object)"Adding a new node ..");
        EmbeddedCacheManager manager = this.addClusterEnabledCacheManager(this.sci);
        manager.defineConfiguration(CACHE_NAME, this.builderUsed.build());
        log.info((Object)"Added a new node");
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builderUsed = new ConfigurationBuilder();
        this.builderUsed.clustering().cacheMode(this.cacheMode);
        if (this.tx) {
            this.builderUsed.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
            this.builderUsed.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        }
        this.builderUsed.expiration().disableReaper();
        this.createClusteredCaches(3, CACHE_NAME, this.sci, this.builderUsed);
        this.injectTimeServices();
    }

    protected void injectTimeServices() {
        this.ts0 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(0), TimeService.class, this.ts0, true);
        this.ts1 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(1), TimeService.class, this.ts1, true);
        this.ts2 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(2), TimeService.class, this.ts2, true);
    }

    void advanceTimeServices(long time, TimeUnit unit) {
        long millis = unit.toMillis(time);
        this.ts0.advance(millis);
        this.ts1.advance(millis);
        this.ts2.advance(millis);
    }

    protected void verifySimpleInsertion(Cache<Object, String> cache, Object key, String value, Long lifespan, ClusterListener listener, Object expectedValue) {
        if (lifespan != null) {
            cache.put(key, (Object)value, lifespan.longValue(), TimeUnit.MILLISECONDS);
        } else {
            cache.put(key, (Object)value);
        }
        this.verifySimpleInsertionEvents(listener, key, expectedValue);
    }

    protected void verifySimpleModification(Cache<Object, String> cache, Object key, String value, Long lifespan, ClusterListener listener, Object expectedValue) {
        if (lifespan != null) {
            cache.put(key, (Object)value, lifespan.longValue(), TimeUnit.MILLISECONDS);
        } else {
            cache.put(key, (Object)value);
        }
        this.verifySimpleModificationEvents(listener, key, expectedValue);
    }

    protected void verifySimpleInsertionEvents(ClusterListener listener, Object key, Object expectedValue) {
        AssertJUnit.assertEquals((int)1, (int)listener.events.size());
        CacheEntryEvent event = listener.events.get(0);
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_CREATED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)key, (Object)event.getKey());
        AssertJUnit.assertEquals((Object)expectedValue, (Object)event.getValue());
    }

    protected void verifySimpleModificationEvents(ClusterListener listener, Object key, Object expectedValue) {
        AssertJUnit.assertEquals((int)(listener.hasIncludeState() ? 2 : 1), (int)listener.events.size());
        CacheEntryEvent event = listener.events.get(listener.hasIncludeState() ? 1 : 0);
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_MODIFIED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)key, (Object)event.getKey());
        AssertJUnit.assertEquals((Object)expectedValue, (Object)event.getValue());
    }

    protected void verifySimpleExpirationEvents(ClusterListener listener, int expectedNumEvents, Object key, Object expectedValue) {
        this.eventually(() -> listener.events.size() >= expectedNumEvents);
        CacheEntryEvent event = listener.events.get(expectedNumEvents - 1);
        AssertJUnit.assertEquals((Object)Event.Type.CACHE_ENTRY_EXPIRED, (Object)event.getType());
        AssertJUnit.assertEquals((Object)key, (Object)event.getKey());
        AssertJUnit.assertEquals((Object)expectedValue, (Object)event.getValue());
    }

    protected void waitUntilListenerInstalled(Cache<?, ?> cache, CheckPoint checkPoint) {
        CacheNotifier cn = TestingUtil.extractComponent(cache, CacheNotifier.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)cn);
        ClusterCacheNotifier mockNotifier = (ClusterCacheNotifier)Mockito.mock(ClusterCacheNotifier.class, (MockSettings)Mockito.withSettings().defaultAnswer(forwardedAnswer));
        ((ClusterCacheNotifier)Mockito.doAnswer(invocation -> {
            checkPoint.trigger("pre_add_listener_invoked_" + cache);
            checkPoint.awaitStrict("pre_add_listener_release_" + cache, 10L, TimeUnit.SECONDS);
            try {
                Object object = forwardedAnswer.answer(invocation);
                return object;
            }
            finally {
                checkPoint.trigger("post_add_listener_invoked_" + cache);
                checkPoint.awaitStrict("post_add_listener_release_" + cache, 10L, TimeUnit.SECONDS);
            }
        }).when((Object)mockNotifier)).addFilteredListener((ListenerHolder)ArgumentMatchers.notNull(), (CacheEventFilter)ArgumentMatchers.nullable(CacheEventFilter.class), (CacheEventConverter)ArgumentMatchers.nullable(CacheEventConverter.class), (Set)ArgumentMatchers.any(Set.class));
        TestingUtil.replaceComponent(cache, CacheNotifier.class, mockNotifier, true);
    }

    protected void waitUntilNotificationRaised(Cache<?, ?> cache, CheckPoint checkPoint) {
        CacheNotifier cn = TestingUtil.extractComponent(cache, CacheNotifier.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)cn);
        CacheNotifier mockNotifier = (CacheNotifier)Mockito.mock(CacheNotifier.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{ClusterCacheNotifier.class}).defaultAnswer(forwardedAnswer));
        Answer answer = invocation -> {
            checkPoint.trigger("pre_raise_notification_invoked");
            checkPoint.awaitStrict("pre_raise_notification_release", 10L, TimeUnit.SECONDS);
            try {
                Object object = forwardedAnswer.answer(invocation);
                return object;
            }
            finally {
                checkPoint.trigger("post_raise_notification_invoked");
                checkPoint.awaitStrict("post_raise_notification_release", 10L, TimeUnit.SECONDS);
            }
        };
        ((CacheNotifier)Mockito.doAnswer((Answer)answer).when((Object)mockNotifier)).notifyCacheEntryCreated(ArgumentMatchers.any(), ArgumentMatchers.any(), (Metadata)ArgumentMatchers.any(Metadata.class), Mockito.eq((boolean)false), (InvocationContext)ArgumentMatchers.any(InvocationContext.class), (FlagAffectedCommand)ArgumentMatchers.any(FlagAffectedCommand.class));
        ((CacheNotifier)Mockito.doAnswer((Answer)answer).when((Object)mockNotifier)).notifyCacheEntryModified(ArgumentMatchers.any(), ArgumentMatchers.any(), (Metadata)ArgumentMatchers.any(Metadata.class), ArgumentMatchers.any(), (Metadata)ArgumentMatchers.any(Metadata.class), Mockito.anyBoolean(), (InvocationContext)ArgumentMatchers.any(InvocationContext.class), (FlagAffectedCommand)ArgumentMatchers.any(FlagAffectedCommand.class));
        ((CacheNotifier)Mockito.doAnswer((Answer)answer).when((Object)mockNotifier)).notifyCacheEntryRemoved(ArgumentMatchers.any(), ArgumentMatchers.any(), (Metadata)ArgumentMatchers.any(Metadata.class), Mockito.eq((boolean)false), (InvocationContext)ArgumentMatchers.any(InvocationContext.class), (FlagAffectedCommand)ArgumentMatchers.any(FlagAffectedCommand.class));
        TestingUtil.replaceComponent(cache, CacheNotifier.class, mockNotifier, true);
    }

    protected void waitUntilViewChangeOccurs(CacheContainer cacheContainer, String uniqueId, CheckPoint checkPoint) {
        CacheManagerNotifier cmn = TestingUtil.extractGlobalComponent(cacheContainer, CacheManagerNotifier.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)cmn);
        CacheManagerNotifier mockNotifier = (CacheManagerNotifier)Mockito.mock(CacheManagerNotifier.class, (MockSettings)Mockito.withSettings().defaultAnswer(forwardedAnswer));
        ((CacheManagerNotifier)Mockito.doAnswer(invocation -> {
            checkPoint.trigger("pre_view_listener_invoked_" + uniqueId);
            checkPoint.awaitStrict("pre_view_listener_release_" + uniqueId, 10L, TimeUnit.SECONDS);
            try {
                Object object = forwardedAnswer.answer(invocation);
                return object;
            }
            finally {
                checkPoint.trigger("post_view_listener_invoked_" + uniqueId);
            }
        }).when((Object)mockNotifier)).notifyViewChange(ArgumentMatchers.anyList(), ArgumentMatchers.anyList(), (Address)ArgumentMatchers.any(Address.class), ArgumentMatchers.anyInt());
        TestingUtil.replaceComponent(cacheContainer, CacheManagerNotifier.class, mockNotifier, true);
    }

    @AutoProtoSchemaBuilder(dependsOn={TestDataSCI.class}, includeClasses={FilterConverter.class, LifespanConverter.class, LifespanFilter.class, NewLifespanLargerFilter.class, StringAppender.class, StringTruncator.class}, schemaFileName="core.listeners.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.core.notifications", service=false)
    static interface ListenerSerializationContext
    extends SerializationContextInitializer {
    }

    public static class FilterConverter
    implements CacheEventFilterConverter<Object, Object, Object> {
        @ProtoField(number=1, defaultValue="false")
        final boolean throwExceptionOnNonFilterAndConverterMethods;
        @ProtoField(value=2)
        final String convertedValue;

        @ProtoFactory
        FilterConverter(boolean throwExceptionOnNonFilterAndConverterMethods, String convertedValue) {
            this.throwExceptionOnNonFilterAndConverterMethods = throwExceptionOnNonFilterAndConverterMethods;
            this.convertedValue = convertedValue;
        }

        public Object filterAndConvert(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
            return this.convertedValue;
        }

        public Object convert(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
            if (this.throwExceptionOnNonFilterAndConverterMethods) {
                throw new AssertionError((Object)"Method should not have been invoked!");
            }
            return this.filterAndConvert(key, oldValue, oldMetadata, oldValue, oldMetadata, eventType);
        }

        public boolean accept(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
            if (this.throwExceptionOnNonFilterAndConverterMethods) {
                throw new AssertionError((Object)"Method should not have been invoked!");
            }
            return this.filterAndConvert(key, oldValue, oldMetadata, oldValue, oldMetadata, eventType) != null;
        }
    }

    @ProtoName(value="StringAppender")
    public static class StringAppender
    implements CacheEventConverter<Object, String, String> {
        public String convert(Object key, String oldValue, Metadata oldMetadata, String newValue, Metadata newMetadata, EventType eventType) {
            return oldValue + (oldMetadata != null ? Long.valueOf(oldMetadata.lifespan()) : "null") + newValue + (newMetadata != null ? Long.valueOf(newMetadata.lifespan()) : "null");
        }
    }

    public static class StringTruncator
    implements CacheEventConverter<Object, String, String> {
        @ProtoField(number=1, defaultValue="0")
        int beginning;
        @ProtoField(number=2, defaultValue="0")
        int length;

        @ProtoFactory
        StringTruncator(int beginning, int length) {
            this.beginning = beginning;
            this.length = length;
        }

        public String convert(Object key, String oldValue, Metadata oldMetadata, String newValue, Metadata newMetadata, EventType eventType) {
            if (newValue != null && newValue.length() > this.beginning + this.length) {
                return newValue.substring(this.beginning, this.beginning + this.length);
            }
            return newValue;
        }
    }

    public static class LifespanConverter
    implements CacheEventConverter<Object, String, Object> {
        @ProtoField(number=1, defaultValue="false")
        final boolean returnOriginalValueOrNull;
        @ProtoField(number=2, defaultValue="-1")
        final long lifespanThreshold;

        @ProtoFactory
        LifespanConverter(boolean returnOriginalValueOrNull, long lifespanThreshold) {
            this.returnOriginalValueOrNull = returnOriginalValueOrNull;
            this.lifespanThreshold = lifespanThreshold;
        }

        public Object convert(Object key, String oldValue, Metadata oldMetadata, String newValue, Metadata newMetadata, EventType eventType) {
            long metaLifespan;
            if (newMetadata != null && (metaLifespan = newMetadata.lifespan()) > this.lifespanThreshold) {
                return metaLifespan;
            }
            if (this.returnOriginalValueOrNull) {
                return newValue;
            }
            return null;
        }
    }

    @ProtoName(value="NewLifespanLargerFilter")
    protected static class NewLifespanLargerFilter<K, V>
    implements CacheEventFilter<K, V> {
        protected NewLifespanLargerFilter() {
        }

        public boolean accept(K key, V oldValue, Metadata oldMetadata, V newValue, Metadata newMetadata, EventType eventType) {
            if (oldMetadata == null || newMetadata == null) {
                return true;
            }
            return newMetadata.lifespan() > oldMetadata.lifespan();
        }
    }

    public static class LifespanFilter<K, V>
    implements KeyValueFilter<K, V> {
        @ProtoField(number=1, defaultValue="-1")
        final long lifespan;

        @ProtoFactory
        LifespanFilter(long lifespan) {
            this.lifespan = lifespan;
        }

        public boolean accept(K key, V value, Metadata metadata) {
            if (metadata == null) {
                return false;
            }
            return metadata.lifespan() > this.lifespan;
        }
    }

    @Listener(clustered=true, includeCurrentState=true)
    protected class ClusterListenerWithIncludeCurrentState
    extends ClusterListener {
        protected ClusterListenerWithIncludeCurrentState() {
        }

        @Override
        protected boolean hasIncludeState() {
            return true;
        }
    }

    @Listener(clustered=true)
    protected class ClusterListener {
        List<CacheEntryEvent> events = Collections.synchronizedList(new ArrayList());

        protected ClusterListener() {
        }

        @CacheEntryCreated
        public void onCreatedEvent(CacheEntryCreatedEvent event) {
            this.onCacheEvent((CacheEntryEvent)event);
        }

        @CacheEntryModified
        public void onModifiedEvent(CacheEntryModifiedEvent event) {
            this.onCacheEvent((CacheEntryEvent)event);
        }

        @CacheEntryRemoved
        public void onRemoveEvent(CacheEntryRemovedEvent event) {
            this.onCacheEvent((CacheEntryEvent)event);
        }

        @CacheEntryExpired
        public void onExpireEvent(CacheEntryExpiredEvent event) {
            this.onCacheEvent((CacheEntryEvent)event);
        }

        void onCacheEvent(CacheEntryEvent event) {
            log.debugf("Adding new cluster event %s", (Object)event);
            this.events.add(event);
        }

        protected boolean hasIncludeState() {
            return false;
        }
    }
}

