/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerWithDependenciesSCIImpl;
import org.infinispan.notifications.cachelistener.cluster.NoOpCacheEventFilterConverterWithDependencies;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.InCacheMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.cluster.ClusterListenerFilterWithDependenciesTest")
@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.SCATTERED_SYNC})
public class ClusterListenerFilterWithDependenciesTest
extends MultipleCacheManagersTest {
    private final int NUM_NODES = 2;
    private final int NUM_ENTRIES = 10;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfgBuilder = ClusterListenerFilterWithDependenciesTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        this.createClusteredCaches(2, new ClusterListenerWithDependenciesSCIImpl(), cfgBuilder);
    }

    public void testEventFilterCurrentState() {
        for (int i = 0; i < 10; ++i) {
            Cache cache = this.cache(i % 2);
            MagicKey key = new MagicKey(cache);
            cache.put((Object)key, (Object)("string " + i));
        }
        AssertJUnit.assertEquals((int)10, (int)this.cache(0).size());
        EntryListener listener = new EntryListener();
        NoOpCacheEventFilterConverterWithDependencies filterConverter = new NoOpCacheEventFilterConverterWithDependencies();
        this.cache(0).addListener((Object)listener, filterConverter, filterConverter);
        AssertJUnit.assertEquals((int)10, (int)listener.createEvents.size());
        this.cache(0).removeListener((Object)listener);
    }

    public void testEventFilter() {
        EntryListener listener = new EntryListener();
        NoOpCacheEventFilterConverterWithDependencies filterConverter = new NoOpCacheEventFilterConverterWithDependencies();
        this.cache(0).addListener((Object)listener, filterConverter, filterConverter);
        for (int i = 0; i < 10; ++i) {
            Cache cache = this.cache(i % 2);
            MagicKey key = new MagicKey(cache);
            cache.put((Object)key, (Object)("string " + i));
        }
        AssertJUnit.assertEquals((int)10, (int)this.cache(0).size());
        AssertJUnit.assertEquals((int)10, (int)listener.createEvents.size());
        this.cache(0).removeListener((Object)listener);
    }

    @AutoProtoSchemaBuilder(includeClasses={MagicKey.class, NoOpCacheEventFilterConverterWithDependencies.class}, schemaFileName="test.core.ClusterListenerFilterWithDependenciesTest.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.core.ClusterListenerFilterWithDependenciesTest", service=false)
    static interface ClusterListenerWithDependenciesSCI
    extends SerializationContextInitializer {
    }

    @Listener(clustered=true, includeCurrentState=true)
    public static class EntryListener {
        public final List<CacheEntryCreatedEvent> createEvents = Collections.synchronizedList(new ArrayList());

        @CacheEntryCreated
        public void handleEvent(CacheEntryCreatedEvent event) {
            if (!event.isPre()) {
                this.createEvents.add(event);
            }
        }
    }
}

