/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.InCacheMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.cachelistener.cluster.ClusteredListenerJoinsTest")
@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.SCATTERED_SYNC})
public class ClusteredListenerJoinsTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() {
        ConfigurationBuilder c = this.buildConfiguration();
        this.createCluster(c, 3);
        this.waitForClusterToForm();
    }

    private ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder c = ClusteredListenerJoinsTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        return c;
    }

    public void testJoins() {
        int cache0Size = this.cache(0).getListeners().size();
        int cache1Size = this.cache(1).getListeners().size();
        this.cache(0).addListener((Object)new NoOpListener());
        this.addClusterEnabledCacheManager(this.buildConfiguration());
        this.cache(0).addListener((Object)new NoOpListener());
        this.waitForClusterToForm();
        AssertJUnit.assertEquals((int)(cache0Size + 2), (int)this.cache(0).getListeners().size());
        AssertJUnit.assertEquals((int)(cache1Size + 2), (int)this.cache(1).getListeners().size());
    }

    @Listener(clustered=true)
    private static final class NoOpListener {
        private NoOpListener() {
        }

        @CacheEntryCreated
        public void handleEvent(CacheEntryEvent<Object, Object> e) {
        }
    }
}

