/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.partitionhandling.BaseTxPartitionAndMergeTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.testng.AssertJUnit;

public abstract class BasePessimisticTxPartitionAndMergeTest
extends BaseTxPartitionAndMergeTest {
    static final String PESSIMISTIC_TX_CACHE_NAME = "pes-cache";

    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
        ConfigurationBuilder builder = BasePessimisticTxPartitionAndMergeTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        builder.clustering().partitionHandling().whenSplit(PartitionHandling.DENY_READ_WRITES);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC).transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.defineConfigurationOnAllManagers(PESSIMISTIC_TX_CACHE_NAME, builder);
    }

    protected abstract void checkLocksDuringPartition(BaseTxPartitionAndMergeTest.SplitMode var1, BaseTxPartitionAndMergeTest.KeyInfo var2, boolean var3);

    protected abstract boolean forceRollback();

    protected abstract Class<? extends TransactionBoundaryCommand> getCommandClass();

    protected void doTest(BaseTxPartitionAndMergeTest.SplitMode splitMode, boolean txFail, boolean discard) throws Exception {
        this.waitForClusterToForm(PESSIMISTIC_TX_CACHE_NAME);
        BaseTxPartitionAndMergeTest.KeyInfo keyInfo = this.createKeys(PESSIMISTIC_TX_CACHE_NAME);
        Cache originator = this.cache(0, PESSIMISTIC_TX_CACHE_NAME);
        BaseTxPartitionAndMergeTest.FilterCollection filterCollection = this.createFilters(PESSIMISTIC_TX_CACHE_NAME, discard, this.getCommandClass(), splitMode);
        Future<Void> put = this.fork(() -> {
            TransactionManager transactionManager = originator.getAdvancedCache().getTransactionManager();
            transactionManager.begin();
            Transaction tx = transactionManager.getTransaction();
            try {
                keyInfo.putFinalValue((Cache<Object, String>)originator);
                if (this.forceRollback()) {
                    tx.setRollbackOnly();
                }
            }
            finally {
                transactionManager.commit();
            }
            return null;
        });
        filterCollection.await(30L, TimeUnit.SECONDS);
        splitMode.split(this);
        filterCollection.unblock();
        try {
            put.get();
            AssertJUnit.assertFalse((boolean)txFail);
        }
        catch (ExecutionException e) {
            AssertJUnit.assertTrue((boolean)txFail);
        }
        this.checkLocksDuringPartition(splitMode, keyInfo, discard);
        filterCollection.stopDiscard();
        this.mergeCluster(PESSIMISTIC_TX_CACHE_NAME);
        this.finalAsserts(PESSIMISTIC_TX_CACHE_NAME, keyInfo, txFail ? "init-value" : "final-value");
    }
}

