/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.partitionhandling.BaseOptimisticTxPartitionAndMergeTest;
import org.infinispan.partitionhandling.BaseTxPartitionAndMergeTest;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.OptimisticTxPartitionAndMergeDuringRollbackTest")
public class OptimisticTxPartitionAndMergeDuringRollbackTest
extends BaseOptimisticTxPartitionAndMergeTest {
    private static final Log log = LogFactory.getLog(OptimisticTxPartitionAndMergeDuringRollbackTest.class);

    public void testDegradedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED, true, true);
    }

    public void testDegradedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED, true, false);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testOriginatorIsolatedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED, true, true);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testOriginatorIsolatedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED, true, false);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testPrimaryOwnerIsolatedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED, true, true);
    }

    public void testPrimaryOwnerIsolatedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED, true, false);
    }

    public void testSplitBeforeRollback() throws Exception {
        this.waitForClusterToForm("opt-cache");
        BaseTxPartitionAndMergeTest.KeyInfo keyInfo = this.createKeys("opt-cache");
        Cache originator = this.cache(0, "opt-cache");
        EmbeddedTransactionManager transactionManager = (EmbeddedTransactionManager)originator.getAdvancedCache().getTransactionManager();
        transactionManager.begin();
        EmbeddedTransaction transaction = transactionManager.getTransaction();
        keyInfo.putFinalValue(originator);
        AssertJUnit.assertTrue((boolean)transaction.runPrepare());
        transactionManager.suspend();
        BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED.split(this);
        transactionManager.resume((Transaction)transaction);
        transaction.runCommit(true);
        this.assertEventuallyNotLocked(this.cache(1, "opt-cache"), keyInfo.getKey1());
        this.assertLocked(this.cache(2, "opt-cache"), keyInfo.getKey2());
        this.mergeCluster("opt-cache");
        this.finalAsserts("opt-cache", keyInfo, "init-value");
    }

    @Override
    protected void checkLocksDuringPartition(BaseTxPartitionAndMergeTest.SplitMode splitMode, BaseTxPartitionAndMergeTest.KeyInfo keyInfo, boolean discard) {
        if (splitMode == BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED && discard) {
            this.assertLocked(this.cache(1, "opt-cache"), keyInfo.getKey1());
        } else {
            this.assertEventuallyNotLocked(this.cache(1, "opt-cache"), keyInfo.getKey1());
        }
        if (discard) {
            this.assertLocked(this.cache(2, "opt-cache"), keyInfo.getKey2());
        } else {
            this.assertEventuallyNotLocked(this.cache(2, "opt-cache"), keyInfo.getKey2());
        }
    }

    @Override
    protected boolean forceRollback() {
        return true;
    }

    @Override
    protected Class<? extends TransactionBoundaryCommand> getCommandClass() {
        return RollbackCommand.class;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

