/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.partitionhandling.BasePessimisticTxPartitionAndMergeTest;
import org.infinispan.partitionhandling.BaseTxPartitionAndMergeTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.PessimisticTxPartitionAndMergeDuringPrepareTest")
public class PessimisticTxPartitionAndMergeDuringPrepareTest
extends BasePessimisticTxPartitionAndMergeTest {
    private static final Log log = LogFactory.getLog(PessimisticTxPartitionAndMergeDuringPrepareTest.class);

    public void testDegradedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED, false, true);
    }

    public void testDegradedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED, false, false);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testOriginatorIsolatedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED, false, true);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testOriginatorIsolatedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED, false, false);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testPrimaryOwnerIsolatedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED, false, true);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testPrimaryOwnerIsolatedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED, false, false);
    }

    public void testSplitBeforePrepare() throws Exception {
        this.waitForClusterToForm("pes-cache");
        BaseTxPartitionAndMergeTest.KeyInfo keyInfo = this.createKeys("pes-cache");
        Cache originator = this.cache(0, "pes-cache");
        TransactionManager transactionManager = originator.getAdvancedCache().getTransactionManager();
        transactionManager.begin();
        keyInfo.putFinalValue(originator);
        Transaction transaction = transactionManager.suspend();
        BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED.split(this);
        transactionManager.resume(transaction);
        transactionManager.commit();
        this.assertLocked(this.cache(1, "pes-cache"), keyInfo.getKey1());
        this.assertLocked(this.cache(2, "pes-cache"), keyInfo.getKey2());
        this.mergeCluster("pes-cache");
        this.finalAsserts("pes-cache", keyInfo, "final-value");
    }

    @Override
    protected void checkLocksDuringPartition(BaseTxPartitionAndMergeTest.SplitMode splitMode, BaseTxPartitionAndMergeTest.KeyInfo keyInfo, boolean discard) {
        if (splitMode == BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED) {
            this.assertEventuallyNotLocked(this.cache(0, "pes-cache"), keyInfo.getKey1());
            this.assertEventuallyNotLocked(this.cache(0, "pes-cache"), keyInfo.getKey2());
            this.assertEventuallyNotLocked(this.cache(1, "pes-cache"), keyInfo.getKey1());
            this.assertEventuallyNotLocked(this.cache(1, "pes-cache"), keyInfo.getKey2());
            this.assertEventuallyNotLocked(this.cache(3, "pes-cache"), keyInfo.getKey1());
            this.assertEventuallyNotLocked(this.cache(3, "pes-cache"), keyInfo.getKey2());
        } else {
            this.assertLocked(this.cache(1, "pes-cache"), keyInfo.getKey1());
            this.assertLocked(this.cache(2, "pes-cache"), keyInfo.getKey2());
        }
    }

    @Override
    protected boolean forceRollback() {
        return false;
    }

    @Override
    protected Class<? extends TransactionBoundaryCommand> getCommandClass() {
        return PrepareCommand.class;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

