/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.partitionhandling.BasePessimisticTxPartitionAndMergeTest;
import org.infinispan.partitionhandling.BaseTxPartitionAndMergeTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.PessimisticTxPartitionAndMergeDuringRollbackTest")
public class PessimisticTxPartitionAndMergeDuringRollbackTest
extends BasePessimisticTxPartitionAndMergeTest {
    private static final Log log = LogFactory.getLog(PessimisticTxPartitionAndMergeDuringRollbackTest.class);

    public void testDegradedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED, true, true);
    }

    public void testDegradedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED, true, false);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testOriginatorIsolatedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED, true, true);
    }

    public void testOriginatorIsolatedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED, true, false);
    }

    @Test(groups={"unstable"}, description="https://issues.jboss.org/browse/ISPN-8232")
    public void testPrimaryOwnerIsolatedPartitionWithDiscard() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED, true, true);
    }

    public void testPrimaryOwnerIsolatedPartition() throws Exception {
        this.doTest(BaseTxPartitionAndMergeTest.SplitMode.PRIMARY_OWNER_ISOLATED, true, false);
    }

    public void testSplitBeforeRollback() throws Exception {
        this.waitForClusterToForm("pes-cache");
        BaseTxPartitionAndMergeTest.KeyInfo keyInfo = this.createKeys("pes-cache");
        Cache originator = this.cache(0, "pes-cache");
        TransactionManager transactionManager = originator.getAdvancedCache().getTransactionManager();
        transactionManager.begin();
        keyInfo.putFinalValue(originator);
        Transaction transaction = transactionManager.suspend();
        BaseTxPartitionAndMergeTest.SplitMode.BOTH_DEGRADED.split(this);
        transactionManager.resume(transaction);
        transactionManager.rollback();
        this.assertEventuallyNotLocked(this.cache(1, "pes-cache"), keyInfo.getKey1());
        this.assertLocked(this.cache(2, "pes-cache"), keyInfo.getKey2());
        this.mergeCluster("pes-cache");
        this.finalAsserts("pes-cache", keyInfo, "init-value");
    }

    @Override
    protected void checkLocksDuringPartition(BaseTxPartitionAndMergeTest.SplitMode splitMode, BaseTxPartitionAndMergeTest.KeyInfo keyInfo, boolean discard) {
        if (splitMode == BaseTxPartitionAndMergeTest.SplitMode.ORIGINATOR_ISOLATED) {
            if (discard) {
                this.assertLocked(this.cache(1, "pes-cache"), keyInfo.getKey1());
            } else {
                this.assertEventuallyNotLocked(this.cache(1, "pes-cache"), keyInfo.getKey1());
            }
        } else {
            this.assertEventuallyNotLocked(this.cache(1, "pes-cache"), keyInfo.getKey1());
        }
        if (discard) {
            this.assertLocked(this.cache(2, "pes-cache"), keyInfo.getKey2());
        } else {
            this.assertEventuallyNotLocked(this.cache(2, "pes-cache"), keyInfo.getKey2());
        }
    }

    @Override
    protected boolean forceRollback() {
        return true;
    }

    @Override
    protected Class<? extends TransactionBoundaryCommand> getCommandClass() {
        return RollbackCommand.class;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

