/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.Collections;
import java.util.Optional;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.partitionhandling.impl.PreferConsistencyStrategy;
import org.infinispan.statetransfer.RebalanceType;
import org.infinispan.topology.ClusterCacheStatus;
import org.infinispan.topology.ClusterTopologyManagerImpl;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.PersistentUUIDManagerImpl;
import org.infinispan.topology.RebalancingStatus;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.impl.EventLogManagerImpl;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="partitionhandling.PreferConsistencyStrategyTest")
public class PreferConsistencyStrategyTest {
    private PreferConsistencyStrategy preferConsistencyStrategy;
    private ClusterCacheStatus status;

    @BeforeMethod
    public void beforeMethod() {
        EventLogManagerImpl eventLogManager = new EventLogManagerImpl();
        PersistentUUIDManagerImpl persistentUUIDManager = new PersistentUUIDManagerImpl();
        ClusterTopologyManagerImpl topologyManager = new ClusterTopologyManagerImpl();
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)Mockito.mock(EmbeddedCacheManager.class);
        this.preferConsistencyStrategy = new PreferConsistencyStrategy((EventLogManager)eventLogManager, (PersistentUUIDManager)persistentUUIDManager, null);
        this.status = new ClusterCacheStatus(cacheManager, "does-not-matter", (AvailabilityStrategy)this.preferConsistencyStrategy, RebalanceType.FOUR_PHASE, topologyManager, null, (PersistentUUIDManager)persistentUUIDManager, (EventLogManager)eventLogManager, Optional.empty(), false);
    }

    public void testAvoidingNullPointerExceptionWhenUpdatingPartitionWithNullTopology() {
        this.preferConsistencyStrategy.onPartitionMerge((AvailabilityStrategyContext)this.status, Collections.emptyMap());
        Assert.assertNull((Object)this.status.getCurrentTopology());
        Assert.assertNull((Object)this.status.getStableTopology());
        Assert.assertEquals((Object)AvailabilityMode.AVAILABLE, (Object)this.status.getAvailabilityMode());
        Assert.assertEquals((Object)RebalancingStatus.COMPLETE, (Object)this.status.getRebalancingStatus());
    }
}

