/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commands.topology.RebalancePhaseConfirmCommand;
import org.infinispan.commands.topology.RebalanceStartCommand;
import org.infinispan.commands.topology.TopologyUpdateCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.remoting.inboundhandler.BlockingInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ControlledTransport;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.jgroups.protocols.DISCARD;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.ScatteredCrashInSequenceTest")
public class ScatteredCrashInSequenceTest
extends BasePartitionHandlingTest {
    public ScatteredCrashInSequenceTest() {
        this.cacheMode = CacheMode.SCATTERED_SYNC;
    }

    public void testSplit1() throws Exception {
        this.test(0, 1, 2, 3, true);
    }

    public void testSplit2() throws Exception {
        this.test(0, 2, 1, 3, true);
    }

    public void testSplit3() throws Exception {
        this.test(1, 0, 2, 3, true);
    }

    public void testSplit4() throws Exception {
        this.test(1, 2, 0, 3, true);
    }

    public void testSplit5() throws Exception {
        this.test(0, 1, 2, 3, false);
    }

    public void testSplit6() throws Exception {
        this.test(0, 2, 1, 3, false);
    }

    public void testSplit7() throws Exception {
        this.test(1, 0, 2, 3, false);
    }

    public void testSplit8() throws Exception {
        this.test(1, 2, 0, 3, false);
    }

    @Override
    protected ConfigurationBuilder cacheConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().hash().numSegments(16);
        return builder;
    }

    @Override
    protected EmbeddedCacheManager addClusterEnabledCacheManager(ConfigurationBuilder builder, TransportFlags flags) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.transport().distributedSyncTimeout(5L, TimeUnit.SECONDS);
        return this.addClusterEnabledCacheManager(gcb, builder, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(int c1, int c2, int a1, int a2, boolean mergeInSplitOrder) throws Exception {
        Object[] keys = IntStream.range(0, this.numMembersInCluster).mapToObj(node -> {
            MagicKey key = new MagicKey(this.cache(node));
            this.cache(node).put((Object)key, (Object)"v0");
            return key;
        }).toArray(MagicKey[]::new);
        DISCARD discard1 = TestingUtil.getDiscardForCache(this.manager(c1));
        DISCARD discard2 = TestingUtil.getDiscardForCache(this.manager(c2));
        Cache coordinator = c1 == 0 ? this.cache(1) : this.cache(0);
        BlockingInboundInvocationHandler blockedRebalanceConfirmations = TestingUtil.wrapGlobalComponent((CacheContainer)coordinator.getCacheManager(), InboundInvocationHandler.class, iih -> new BlockingInboundInvocationHandler((InboundInvocationHandler)iih, this.address(coordinator)), true);
        blockedRebalanceConfirmations.blockBefore(RebalancePhaseConfirmCommand.class, c -> c.getCacheName().equals(this.getDefaultCacheName()));
        ControlledTransport blockedRebalanceStart = ControlledTransport.replace(coordinator);
        blockedRebalanceStart.blockAfter(RebalanceStartCommand.class, c -> c.getCacheName().equals(this.getDefaultCacheName()));
        ControlledTransport blockedTopologyUpdatesA1 = ControlledTransport.replace(this.cache(a1));
        AtomicBoolean shouldBlockTopologyUpdatesOnA1 = new AtomicBoolean(false);
        blockedTopologyUpdatesA1.blockBefore(TopologyUpdateCommand.class, c -> c.getCacheName().equals(this.getDefaultCacheName()) && shouldBlockTopologyUpdatesOnA1.get());
        try {
            discard1.setDiscardAll(true);
            Stream<Address> newMembers1 = this.manager(c2).getTransport().getMembers().stream().filter(n -> !n.equals(this.manager(c1).getAddress()));
            TestingUtil.installNewView(newMembers1, this.manager(c2), this.manager(a1), this.manager(a2));
            TestingUtil.installNewView(this.manager(c1));
            blockedRebalanceStart.waitForCommandToBlock();
            blockedRebalanceStart.stopBlocking();
            this.assertKeysAvailableForRead(this.cache(c2), keys);
            this.assertKeysAvailableForRead(this.cache(a1), keys);
            this.assertKeysAvailableForRead(this.cache(a2), keys);
            this.eventuallyDegraded(this.cache(c1));
            this.assertKeysNotAvailableForRead(this.cache(c1), keys);
            shouldBlockTopologyUpdatesOnA1.set(true);
            discard2.setDiscardAll(true);
            Stream<Address> newMembers2 = this.manager(a1).getTransport().getMembers().stream().filter(n -> !n.equals(this.manager(c2).getAddress()));
            TestingUtil.installNewView(newMembers2, this.manager(a1), this.manager(a2));
            TestingUtil.installNewView(this.manager(c2));
            blockedTopologyUpdatesA1.waitForCommandToBlock();
            blockedTopologyUpdatesA1.stopBlocking();
            this.eventuallyDegraded(this.cache(a1));
            this.eventuallyDegraded(this.cache(a2));
            this.eventuallyDegraded(this.cache(c2));
        }
        finally {
            blockedRebalanceConfirmations.stopBlocking();
            blockedRebalanceStart.stopBlocking();
            blockedTopologyUpdatesA1.stopBlocking();
        }
        this.assertKeysNotAvailableForRead(this.cache(a1), keys);
        this.assertKeysNotAvailableForRead(this.cache(a2), keys);
        this.assertKeysNotAvailableForRead(this.cache(c1), keys);
        this.assertKeysNotAvailableForRead(this.cache(c2), keys);
        int m1 = mergeInSplitOrder ? c1 : c2;
        int m2 = mergeInSplitOrder ? c2 : c1;
        (mergeInSplitOrder ? discard1 : discard2).setDiscardAll(false);
        TestingUtil.installNewView(this.manager(a1), this.manager(a2), this.manager(m1));
        this.eventuallyAvailable(this.cache(a1));
        this.eventuallyAvailable(this.cache(a2));
        this.eventuallyAvailable(this.cache(m1));
        this.eventuallyDegraded(this.cache(m2));
        this.assertKeysAvailableForRead(this.cache(m1), keys);
        this.assertKeysAvailableForRead(this.cache(a1), keys);
        this.assertKeysAvailableForRead(this.cache(a2), keys);
        this.assertKeysNotAvailableForRead(this.cache(m2), keys);
        (mergeInSplitOrder ? discard2 : discard1).setDiscardAll(false);
        TestingUtil.installNewView(this.manager(a1), this.manager(a2), this.manager(m1), this.manager(m2));
        this.eventuallyAvailable(this.cache(m2));
        this.assertKeysAvailableForRead(this.cache(m2), keys);
        this.assertKeysAvailableForRead(this.cache(m1), keys);
        this.assertKeysAvailableForRead(this.cache(a1), keys);
        this.assertKeysAvailableForRead(this.cache(a2), keys);
    }

    private void eventuallyDegraded(Cache<?, ?> c) {
        this.eventually(() -> {
            AvailabilityMode currentMode = this.partitionHandlingManager(c).getAvailabilityMode();
            log.tracef("Current availability mode: %s", (Object)currentMode);
            return AvailabilityMode.DEGRADED_MODE.equals((Object)currentMode);
        });
    }

    private void eventuallyAvailable(Cache<?, ?> c) {
        this.eventually(() -> {
            AvailabilityMode currentMode = this.partitionHandlingManager(c).getAvailabilityMode();
            log.tracef("Current availability mode: %s", (Object)currentMode);
            return AvailabilityMode.AVAILABLE.equals((Object)currentMode);
        });
    }

    private void assertKeysAvailableForRead(Cache<?, ?> cache, Object ... keys) {
        for (Object key : keys) {
            Assert.assertNotNull((Object)cache.get(key), (String)key.toString());
        }
        Assert.assertEquals((int)cache.getAdvancedCache().getAll(new HashSet<Object>(Arrays.asList(keys))).size(), (int)keys.length);
    }

    private void assertKeysNotAvailableForRead(Cache<?, ?> cache, Object ... keys) {
        for (Object key : keys) {
            Exceptions.expectException(AvailabilityException.class, () -> cache.get(key));
        }
        Exceptions.expectException(AvailabilityException.class, () -> cache.getAdvancedCache().getAll(new HashSet<Object>(Arrays.asList(keys))));
    }
}

