/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.MagicKey;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.partitionhandling.DelayedAvailabilityUpdateTest;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.concurrent.StateSequencer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.ScatteredDelayedAvailabilityUpdateTest")
public class ScatteredDelayedAvailabilityUpdateTest
extends DelayedAvailabilityUpdateTest {
    public ScatteredDelayedAvailabilityUpdateTest() {
        this.cacheMode = CacheMode.SCATTERED_SYNC;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new ScatteredDelayedAvailabilityUpdateTest().biasAcquisition(BiasAcquisition.NEVER), new ScatteredDelayedAvailabilityUpdateTest().biasAcquisition(BiasAcquisition.ON_WRITE)};
    }

    @Override
    protected void testDelayedAvailabilityUpdate(BasePartitionHandlingTest.PartitionDescriptor p0, BasePartitionHandlingTest.PartitionDescriptor p1) throws Exception {
        MagicKey k0Existing = new MagicKey("k0Existing", this.cache(p0.node(0)));
        MagicKey k1Existing = new MagicKey("k1Existing", this.cache(p0.node(1)));
        MagicKey k2Existing = new MagicKey("k2Existing", this.cache(p1.node(0)));
        MagicKey k3Existing = new MagicKey("k3Existing", this.cache(p1.node(1)));
        MagicKey k0Missing = new MagicKey("k0Missing", this.cache(p0.node(0)));
        MagicKey k1Missing = new MagicKey("k1Missing", this.cache(p0.node(1)));
        MagicKey k2Missing = new MagicKey("k2Missing", this.cache(p1.node(0)));
        MagicKey k3Missing = new MagicKey("k3Missing", this.cache(p1.node(1)));
        Cache cacheP0N0 = this.cache(p0.node(0));
        cacheP0N0.put((Object)k0Existing, (Object)"v0");
        cacheP0N0.put((Object)k1Existing, (Object)"v1");
        cacheP0N0.put((Object)k2Existing, (Object)"v2");
        cacheP0N0.put((Object)k3Existing, (Object)"v3");
        StateSequencer ss = new StateSequencer();
        ss.logicalThread("main", "main:block_availability_update_p0n0", "main:after_availability_update_p0n1", "main:check_before_topology_update_p0n1", "main:resume_topology_update_p0n1", "main:check_availability", "main:resume_availability_update_p0n0");
        log.debugf("Delaying the availability mode update on node %s", (Object)this.address(p0.node(0)));
        this.cache(p0.node(0)).addListener((Object)new DelayedAvailabilityUpdateTest.BlockAvailabilityChangeListener(true, ss, "main:block_availability_update_p0n0", "main:resume_availability_update_p0n0"));
        this.cache(p0.node(1)).addListener((Object)new DelayedAvailabilityUpdateTest.BlockAvailabilityChangeListener(false, ss, "main:after_availability_update_p0n1", "main:resume_topology_update_p0n1"));
        DistributionManager dmP0N0 = this.advancedCache(p0.node(0)).getDistributionManager();
        DistributionManager dmP0N1 = this.advancedCache(p0.node(1)).getDistributionManager();
        int topologyBeforeSplit = dmP0N1.getCacheTopology().getTopologyId();
        this.splitCluster(p0.getNodes(), p1.getNodes());
        ss.enter("main:check_before_topology_update_p0n1");
        int currentTopologyP0N0 = dmP0N0.getCacheTopology().getTopologyId();
        int currentTopologyP0N1 = dmP0N1.getCacheTopology().getTopologyId();
        log.debugf("Topology before split: %d, now on P0N0: %d, P0N1: %d", topologyBeforeSplit, currentTopologyP0N0, currentTopologyP0N1);
        if (currentTopologyP0N0 == topologyBeforeSplit + 1 && currentTopologyP0N1 == topologyBeforeSplit + 1) {
            this.assertKeyNotAvailableForRead(this.cache(p0.node(1)), k0Existing);
            this.assertKeyNotAvailableForRead(this.cache(p0.node(1)), k0Missing);
        }
        CompletableFuture topologyUpdateFuture = TestingUtil.extractComponent(this.cache(p0.node(1)), StateTransferLock.class).topologyFuture(currentTopologyP0N1 + 1).toCompletableFuture();
        ss.exit("main:check_before_topology_update_p0n1");
        topologyUpdateFuture.get(10L, TimeUnit.SECONDS);
        ss.enter("main:check_availability");
        this.eventuallyEquals(2, () -> dmP0N1.getCacheTopology().getActualMembers().size());
        AssertJUnit.assertEquals((Object)AvailabilityMode.AVAILABLE, (Object)this.partitionHandlingManager(p0.node(0)).getAvailabilityMode());
        ArrayList<Check> checks = new ArrayList<Check>();
        this.assertKeyAvailableForRead(this.cache(p0.node(0)), k0Existing, "v0");
        checks.add(new Check("p0n1 k0Existing", this.fork(() -> this.assertKeyNotAvailableForRead(this.cache(p0.node(1)), k0Existing))));
        if (this.biasAcquisition == BiasAcquisition.NEVER) {
            this.assertKeyNotAvailableForRead(this.cache(p0.node(0)), k1Existing);
        } else {
            this.assertKeyAvailableForRead(this.cache(p0.node(0)), k1Existing, "v1");
        }
        this.assertKeyNotAvailableForRead(this.cache(p0.node(1)), k1Existing);
        if (this.biasAcquisition == BiasAcquisition.NEVER) {
            checks.add(new Check("p0n0 k2Existing", this.fork(() -> this.assertKeyNotAvailableForRead(this.cache(p0.node(0)), k2Existing))));
            checks.add(new Check("p0n0 k3Existing", this.fork(() -> this.assertKeyNotAvailableForRead(this.cache(p0.node(0)), k3Existing))));
        } else {
            this.assertKeyAvailableForRead(this.cache(p0.node(0)), k2Existing, "v2");
            this.assertKeyAvailableForRead(this.cache(p0.node(0)), k3Existing, "v3");
        }
        this.assertKeyNotAvailableForRead(this.cache(p0.node(1)), k2Existing);
        this.assertKeyNotAvailableForRead(this.cache(p0.node(1)), k3Existing);
        this.assertKeyAvailableForRead(this.cache(p0.node(0)), k0Missing, null);
        checks.add(new Check("p0n1 k0Missing", this.fork(() -> this.assertKeyNotAvailableForRead(this.cache(p0.node(1)), k0Missing))));
        this.assertKeyNotAvailableForRead(this.cache(p0.node(0)), k1Missing);
        this.assertKeyNotAvailableForRead(this.cache(p0.node(1)), k1Missing);
        checks.add(new Check("p0n0 k2Missing", this.fork(() -> this.assertKeyNotAvailableForRead(this.cache(p0.node(0)), k2Missing))));
        checks.add(new Check("p0n0 k3Missing", this.fork(() -> this.assertKeyNotAvailableForRead(this.cache(p0.node(0)), k3Missing))));
        this.assertKeyNotAvailableForRead(this.cache(p0.node(1)), k2Missing);
        this.assertKeyNotAvailableForRead(this.cache(p0.node(1)), k3Missing);
        Thread.sleep(100L);
        for (Check check : checks) {
            AssertJUnit.assertFalse((String)(check.description + " has completed"), (boolean)check.f.isDone());
        }
        ss.exit("main:check_availability");
        for (Check check : checks) {
            try {
                check.f.get(10L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                AssertJUnit.fail((String)(check.description + " timed out"));
            }
            catch (Exception e) {
                log.error((Object)check.description, (Throwable)e);
                AssertJUnit.fail((String)(check.description + " " + e.getMessage()));
            }
        }
        this.partition(0).assertDegradedMode();
        this.partition(1).assertDegradedMode();
    }

    private static class Check {
        private final String description;
        private final Future<?> f;

        private Check(String description, Future<?> f) {
            this.description = description;
            this.f = f;
        }
    }
}

