/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.MagicKey;
import org.infinispan.partitionhandling.AvailabilityException;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="ScatteredSplitAndMergeTest")
public class ScatteredSplitAndMergeTest
extends BasePartitionHandlingTest {
    private static Log log = LogFactory.getLog(ScatteredSplitAndMergeTest.class);

    public ScatteredSplitAndMergeTest() {
        this.cacheMode = CacheMode.SCATTERED_SYNC;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new ScatteredSplitAndMergeTest().biasAcquisition(BiasAcquisition.NEVER), new ScatteredSplitAndMergeTest().biasAcquisition(BiasAcquisition.ON_WRITE)};
    }

    public void testSplitAndMerge1() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.DEGRADED_MODE, 0, 1), new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.DEGRADED_MODE, 2), new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.DEGRADED_MODE, 3));
    }

    public void testSplitAndMerge2() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.DEGRADED_MODE, 1, 2), new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.DEGRADED_MODE, 0), new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.DEGRADED_MODE, 3));
    }

    public void testSplitAndMerge3() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.DEGRADED_MODE, 0, 1), new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.DEGRADED_MODE, 2, 3));
    }

    public void testSplitAndMerge4() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.AVAILABLE, 0, 1, 2), new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.DEGRADED_MODE, 3));
    }

    public void testSplitAndMerge5() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.AVAILABLE, 1, 2, 3), new BasePartitionHandlingTest.PartitionDescriptor(AvailabilityMode.DEGRADED_MODE, 0));
    }

    private void testSplitAndMerge(BasePartitionHandlingTest.PartitionDescriptor ... descriptors) throws Exception {
        int i2;
        MagicKey[] keys = (MagicKey[])IntStream.range(0, this.numMembersInCluster).mapToObj(i -> {
            MagicKey key = new MagicKey("k" + i, this.cache(i));
            this.cache(i).put((Object)key, (Object)"v0");
            return key;
        }).toArray(MagicKey[]::new);
        Object[] lastWrittenValues = new String[keys.length];
        Arrays.fill(lastWrittenValues, "v0");
        log.trace((Object)"Before split.");
        this.splitCluster(descriptors);
        for (i2 = 0; i2 < descriptors.length; ++i2) {
            descriptors[i2].assertAvailabilityMode(this.partition(i2));
        }
        for (i2 = 0; i2 < keys.length; ++i2) {
            MagicKey key = keys[i2];
            for (BasePartitionHandlingTest.PartitionDescriptor descriptor : descriptors) {
                for (int node : descriptor.getNodes()) {
                    try {
                        Assert.assertEquals((Object)lastWrittenValues[i2], (Object)this.cache(node).put((Object)key, (Object)"v1"));
                        lastWrittenValues[i2] = "v1";
                        Assert.assertEquals((Object)AvailabilityMode.AVAILABLE, (Object)descriptor.expectedMode, (String)descriptor.toString());
                    }
                    catch (AvailabilityException ae) {
                        Assert.assertEquals((Object)AvailabilityMode.DEGRADED_MODE, (Object)descriptor.expectedMode);
                    }
                }
            }
        }
        for (MagicKey key : keys) {
            for (BasePartitionHandlingTest.PartitionDescriptor descriptor : descriptors) {
                for (int node : descriptor.getNodes()) {
                    try {
                        Assert.assertEquals((Object)this.cache(node).get((Object)key), (Object)"v1");
                        Assert.assertEquals((Object)AvailabilityMode.AVAILABLE, (Object)descriptor.expectedMode);
                    }
                    catch (AvailabilityException ae) {
                        Assert.assertEquals((Object)AvailabilityMode.DEGRADED_MODE, (Object)descriptor.expectedMode);
                    }
                }
            }
        }
        int merge = 1;
        while (this.partitions.length > 1) {
            log.tracef("Before merge #%d", merge);
            int prevPartitions = this.partitions.length;
            this.partition(0).merge(this.partition(1));
            Assert.assertEquals((int)this.partitions.length, (int)(prevPartitions - 1));
            log.tracef("After merge #%d", merge);
            this.partition(0).assertAvailabilityMode(AvailabilityMode.AVAILABLE);
            if (this.partitions.length > 1) {
                this.partition(1).assertAvailabilityMode(AvailabilityMode.DEGRADED_MODE);
            }
            for (int i3 = 0; i3 < keys.length; ++i3) {
                MagicKey key = keys[i3];
                this.partition(0).assertKeyAvailableForRead(key, lastWrittenValues[i3]);
                String newValue = "v" + (merge + 1);
                this.partition(0).assertKeyAvailableForWrite(key, newValue);
                lastWrittenValues[i3] = newValue;
                if (this.partitions.length <= 1) continue;
                this.partition(1).assertKeyNotAvailableForRead(key);
                this.partition(1).assertKeyNotAvailableForWrite(key);
            }
            this.partition(0).assertConsistentHashMembers(this.partition(0).getAddresses());
            if (this.partitions.length > 1) {
                this.partition(1).assertConsistentHashMembers(Arrays.asList(this.address(0), this.address(1), this.address(2), this.address(3)));
            }
            ++merge;
        }
    }
}

