/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import org.infinispan.distribution.MagicKey;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.TwoWaySplitAndMergeTest")
public class TwoWaySplitAndMergeTest
extends BasePartitionHandlingTest {
    @Override
    public Object[] factory() {
        return new Object[]{new TwoWaySplitAndMergeTest().partitionHandling(PartitionHandling.DENY_READ_WRITES), new TwoWaySplitAndMergeTest().partitionHandling(PartitionHandling.ALLOW_READS)};
    }

    public void testSplitAndMerge0() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(0, 1), new BasePartitionHandlingTest.PartitionDescriptor(2, 3));
    }

    public void testSplitAndMerge1() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(0, 2), new BasePartitionHandlingTest.PartitionDescriptor(1, 3));
    }

    public void testSplitAndMerge2() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(0, 3), new BasePartitionHandlingTest.PartitionDescriptor(1, 2));
    }

    public void testSplitAndMerge3() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(1, 2), new BasePartitionHandlingTest.PartitionDescriptor(0, 3));
    }

    public void testSplitAndMerge4() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(1, 3), new BasePartitionHandlingTest.PartitionDescriptor(0, 2));
    }

    public void testSplitAndMerge5() throws Exception {
        this.testSplitAndMerge(new BasePartitionHandlingTest.PartitionDescriptor(2, 3), new BasePartitionHandlingTest.PartitionDescriptor(0, 1));
    }

    private void testSplitAndMerge(BasePartitionHandlingTest.PartitionDescriptor p0, BasePartitionHandlingTest.PartitionDescriptor p1) throws Exception {
        MagicKey k0 = new MagicKey(this.cache(p0.node(0)), this.cache(p0.node(1)));
        this.cache(0).put((Object)k0, (Object)0);
        MagicKey k1 = new MagicKey(this.cache(p0.node(1)), this.cache(p1.node(0)));
        this.cache(1).put((Object)k1, (Object)1);
        MagicKey k2 = new MagicKey(this.cache(p1.node(0)), this.cache(p1.node(1)));
        this.cache(2).put((Object)k2, (Object)2);
        MagicKey k3 = new MagicKey(this.cache(p1.node(1)), this.cache(p0.node(0)));
        this.cache(3).put((Object)k3, (Object)3);
        List allMembers = this.advancedCache(0).getRpcManager().getMembers();
        Assert.assertEquals(new HashSet(this.partitionHandlingManager(0).getLastStableTopology().getMembers()), new HashSet(allMembers));
        Assert.assertEquals(new HashSet(this.partitionHandlingManager(1).getLastStableTopology().getMembers()), new HashSet(allMembers));
        Assert.assertEquals(new HashSet(this.partitionHandlingManager(2).getLastStableTopology().getMembers()), new HashSet(allMembers));
        Assert.assertEquals(new HashSet(this.partitionHandlingManager(3).getLastStableTopology().getMembers()), new HashSet(allMembers));
        this.eventually(() -> {
            for (int i = 0; i < this.numMembersInCluster; ++i) {
                if (this.partitionHandlingManager(i).getAvailabilityMode() == AvailabilityMode.AVAILABLE) continue;
                return false;
            }
            return true;
        });
        this.splitCluster(p0.getNodes(), p1.getNodes());
        this.partition(0).assertDegradedMode();
        this.partition(1).assertDegradedMode();
        Assert.assertEquals((Collection)this.partitionHandlingManager(0).getLastStableTopology().getMembers(), (Collection)allMembers);
        Assert.assertEquals((Collection)this.partitionHandlingManager(1).getLastStableTopology().getMembers(), (Collection)allMembers);
        Assert.assertEquals((Collection)this.partitionHandlingManager(2).getLastStableTopology().getMembers(), (Collection)allMembers);
        Assert.assertEquals((Collection)this.partitionHandlingManager(3).getLastStableTopology().getMembers(), (Collection)allMembers);
        this.partition(0).assertKeyAvailableForRead(k0, 0);
        this.partition(1).assertKeyAvailableForRead(k2, 2);
        if (this.partitionHandling == PartitionHandling.DENY_READ_WRITES) {
            this.partition(0).assertKeysNotAvailableForRead(k1, k2, k3);
            this.partition(1).assertKeysNotAvailableForRead(k0, k1, k3);
        } else {
            IntStream.range(0, 2).forEach(i -> {
                this.partition(i).assertKeyAvailableForRead(k1, 1);
                this.partition(i).assertKeyAvailableForRead(k3, 3);
            });
            this.partition(0).assertKeyNotAvailableForRead(k2);
            this.partition(1).assertKeyNotAvailableForRead(k0);
        }
        Assert.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k0));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k1));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k2));
        Assert.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k3));
        Assert.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k0));
        Assert.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k1));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k2));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k3));
        Assert.assertFalse((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k0));
        Assert.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k1));
        Assert.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k2));
        Assert.assertFalse((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k3));
        Assert.assertFalse((boolean)this.dataContainer(p1.node(1)).containsKey((Object)k0));
        Assert.assertFalse((boolean)this.dataContainer(p1.node(1)).containsKey((Object)k1));
        Assert.assertTrue((boolean)this.dataContainer(p1.node(1)).containsKey((Object)k2));
        Assert.assertTrue((boolean)this.dataContainer(p1.node(1)).containsKey((Object)k3));
        this.partition(0).assertKeyAvailableForWrite(k0, -1);
        this.partition(0).assertKeyNotAvailableForWrite(k1);
        this.partition(0).assertKeyNotAvailableForWrite(k2);
        this.partition(0).assertKeyNotAvailableForWrite(k3);
        this.partition(1).assertKeyAvailableForWrite(k2, -1);
        this.partition(1).assertKeyNotAvailableForWrite(k0);
        this.partition(1).assertKeyNotAvailableForWrite(k1);
        this.partition(1).assertKeyNotAvailableForWrite(k3);
        this.partition(0).merge(this.partition(1));
        Assert.assertEquals(new HashSet(this.partitionHandlingManager(0).getLastStableTopology().getMembers()), new HashSet(allMembers));
        Assert.assertEquals(new HashSet(this.partitionHandlingManager(1).getLastStableTopology().getMembers()), new HashSet(allMembers));
        Assert.assertEquals(new HashSet(this.partitionHandlingManager(2).getLastStableTopology().getMembers()), new HashSet(allMembers));
        Assert.assertEquals(new HashSet(this.partitionHandlingManager(3).getLastStableTopology().getMembers()), new HashSet(allMembers));
        this.partition(0).assertAvailabilityMode(AvailabilityMode.AVAILABLE);
        this.assertExpectedValue(-1, k0);
        this.assertExpectedValue(1, k1);
        this.assertExpectedValue(-1, k2);
        this.assertExpectedValue(3, k3);
        Assert.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k0));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k1));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k2));
        Assert.assertTrue((boolean)this.dataContainer(p0.node(0)).containsKey((Object)k3));
        Assert.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k0));
        Assert.assertTrue((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k1));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k2));
        Assert.assertFalse((boolean)this.dataContainer(p0.node(1)).containsKey((Object)k3));
        Assert.assertFalse((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k0));
        Assert.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k1));
        Assert.assertTrue((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k2));
        Assert.assertFalse((boolean)this.dataContainer(p1.node(0)).containsKey((Object)k3));
        Assert.assertFalse((boolean)this.dataContainer(p1.node(1)).containsKey((Object)k0));
        Assert.assertFalse((boolean)this.dataContainer(p1.node(1)).containsKey((Object)k1));
        Assert.assertTrue((boolean)this.dataContainer(p1.node(1)).containsKey((Object)k2));
        Assert.assertTrue((boolean)this.dataContainer(p1.node(1)).containsKey((Object)k3));
        this.cache(0).put((Object)k0, (Object)10);
        this.cache(1).put((Object)k1, (Object)100);
        this.cache(2).put((Object)k2, (Object)1000);
        this.cache(3).put((Object)k3, (Object)10000);
        this.assertExpectedValue(10, k0);
        this.assertExpectedValue(100, k1);
        this.assertExpectedValue(1000, k2);
        this.assertExpectedValue(10000, k3);
    }
}

