/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.PassivationCacheLoaderInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.ActivationDuringEvictTest")
public class ActivationDuringEvictTest
extends SingleCacheManagerTest {
    public static final String KEY = "a";
    public static final String VALUE = "b";
    SlowDownInterceptor sdi;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.sdi = new SlowDownInterceptor();
        ConfigurationBuilder config = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)config.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).customInterceptors().addInterceptor().interceptor((AsyncInterceptor)this.sdi).after(PassivationCacheLoaderInterceptor.class).transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        return TestCacheManagerFactory.createCacheManager(config);
    }

    public void testActivationDuringEvict() throws Exception {
        DataContainer dc = this.cache.getAdvancedCache().getDataContainer();
        DummyInMemoryStore cl = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        this.cache.put((Object)KEY, (Object)VALUE);
        AssertJUnit.assertEquals((Object)VALUE, (Object)this.cache.get((Object)KEY));
        MarshallableEntry se = cl.loadEntry(KEY);
        AssertJUnit.assertNull(se);
        this.cache.evict((Object)KEY);
        this.assertPassivated(dc, cl, KEY, VALUE);
        this.sdi.enabled = true;
        Future<Void> future = this.fork(() -> {
            log.info((Object)"before the evict");
            this.cache.evict((Object)KEY);
            log.info((Object)"after the evict");
        });
        if (!this.sdi.evictLatch.await(10L, TimeUnit.SECONDS)) {
            throw new org.infinispan.util.concurrent.TimeoutException();
        }
        log.info((Object)"doing the get");
        Object value = this.cache.get((Object)KEY);
        AssertJUnit.assertEquals((Object)VALUE, (Object)value);
        this.sdi.getLatch.countDown();
        future.get(10L, TimeUnit.SECONDS);
        this.sdi.enabled = false;
        this.assertPassivated(dc, cl, KEY, VALUE);
    }

    private void assertPassivated(DataContainer dc, DummyInMemoryStore cl, String key, String expected) {
        AssertJUnit.assertFalse((boolean)dc.containsKey((Object)key));
        MarshallableEntry se = cl.loadEntry(key);
        AssertJUnit.assertNotNull(se);
        AssertJUnit.assertEquals((Object)expected, (Object)se.getValue());
    }

    static class SlowDownInterceptor
    extends DDAsyncInterceptor {
        private static final Log log = LogFactory.getLog(SlowDownInterceptor.class);
        volatile boolean enabled = false;
        CountDownLatch getLatch = new CountDownLatch(1);
        CountDownLatch evictLatch = new CountDownLatch(1);

        SlowDownInterceptor() {
        }

        public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
            if (this.enabled) {
                this.evictLatch.countDown();
                log.trace((Object)"Wait for get to finish...");
                if (!this.getLatch.await(10L, TimeUnit.SECONDS)) {
                    throw new TimeoutException("Didn't see evict!");
                }
            }
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
    }
}

