/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.ClusteredCacheLoaderInterceptor;
import org.infinispan.interceptors.impl.PassivationCacheLoaderInterceptor;
import org.infinispan.interceptors.impl.PassivationClusteredCacheLoaderInterceptor;
import org.infinispan.interceptors.impl.PassivationWriterInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.AddStoreTest")
public class AddStoreTest
extends AbstractInfinispanTest {
    public void testAddStore() {
        ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
        ConfigurationBuilder toAddBuilder = new ConfigurationBuilder();
        toAddBuilder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        this.addAndCheckStore(cacheBuilder, (StoreConfiguration)toAddBuilder.build().persistence().stores().get(0), this::checkStore);
    }

    public void testAddAsyncStore() {
        ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
        ConfigurationBuilder toAddBuilder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
        ((DummyInMemoryStoreConfigurationBuilder)toAddBuilder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).async().enable();
        this.addAndCheckStore(cacheBuilder, (StoreConfiguration)toAddBuilder.build().persistence().stores().get(0), this::checkStore);
    }

    @Test
    public void testAddStoreWithToClusteredCache() {
        ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
        cacheBuilder.clustering().cacheMode(CacheMode.DIST_SYNC);
        ConfigurationBuilder toAddBuilder = new ConfigurationBuilder();
        toAddBuilder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        this.addAndCheckStore(cacheBuilder, (StoreConfiguration)toAddBuilder.build().persistence().stores().get(0), this::checkClustered);
    }

    @Test
    public void testAddStoreWithToRrplCache() {
        ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
        cacheBuilder.clustering().cacheMode(CacheMode.REPL_SYNC);
        ConfigurationBuilder toAddBuilder = new ConfigurationBuilder();
        toAddBuilder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        this.addAndCheckStore(cacheBuilder, (StoreConfiguration)toAddBuilder.build().persistence().stores().get(0), this::checkClustered);
    }

    @Test
    public void testAddStoreWithPassivation() {
        this.testPassivation(new ConfigurationBuilder());
    }

    @Test
    public void testAddStoreWithPassivationToClusteredCache() {
        ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
        cacheBuilder.clustering().cacheMode(CacheMode.DIST_SYNC);
        this.testPassivation(cacheBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testAddExtraStoreToCache() {
        String location = null;
        try {
            ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
            cacheBuilder.clustering().cacheMode(CacheMode.DIST_SYNC);
            location = CommonsTestingUtil.tmpDirectory(this.getClass());
            ((SingleFileStoreConfigurationBuilder)cacheBuilder.persistence().addStore(SingleFileStoreConfigurationBuilder.class)).location(location);
            ConfigurationBuilder toAddBuilder = new ConfigurationBuilder();
            toAddBuilder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
            this.addAndCheckStore(cacheBuilder, (StoreConfiguration)toAddBuilder.build().persistence().stores().get(0), this::checkClustered);
            if (location == null) return;
        }
        catch (Throwable throwable) {
            if (location == null) throw throwable;
            Util.recursiveFileRemove(location);
            throw throwable;
        }
        Util.recursiveFileRemove((String)location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={CompletionException.class}, expectedExceptionsMessageRegExp=".*Cache.*is non empty.*")
    public void testAddToNonEmptyCache() {
        EmbeddedCacheManager cm = null;
        try {
            ConfigurationBuilder cacheBuilder = new ConfigurationBuilder();
            cacheBuilder.clustering().cacheMode(CacheMode.DIST_SYNC);
            cm = TestCacheManagerFactory.createClusteredCacheManager(cacheBuilder);
            Cache cache = cm.getCache();
            cache.put((Object)"k", (Object)"v");
            PersistenceManager persistenceManager = TestingUtil.extractComponent(cache, PersistenceManager.class);
            ConfigurationBuilder storeBuilder = new ConfigurationBuilder();
            storeBuilder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
            CompletionStages.join((CompletionStage)persistenceManager.addStore((StoreConfiguration)storeBuilder.build().persistence().stores().get(0)));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAndCheckStore(ConfigurationBuilder builder, StoreConfiguration storeConfiguration, Consumer<Cache<?, ?>> check) {
        EmbeddedCacheManager cm = null;
        try {
            builder.statistics().enable();
            cm = !builder.clustering().cacheMode().isClustered() ? TestCacheManagerFactory.createCacheManager(builder) : TestCacheManagerFactory.createClusteredCacheManager(builder);
            Cache cache = cm.getCache();
            PersistenceManager persistenceManager = TestingUtil.extractComponent(cache, PersistenceManager.class);
            CompletionStages.join((CompletionStage)persistenceManager.addStore(storeConfiguration));
            int storesBefore = cache.getCacheConfiguration().persistence().stores().size();
            int storeSizeAfterAdding = this.countStores(persistenceManager);
            AssertJUnit.assertEquals((int)(storesBefore + 1), (int)storeSizeAfterAdding);
            check.accept(cache);
            cache.put((Object)"key1", (Object)"value1");
            cache.put((Object)"key2", (Object)"value2");
            int expected = cache.getCacheConfiguration().persistence().passivation() ? 1 : 2;
            AssertJUnit.assertEquals((long)expected, (long)this.getDummyStoreSize(persistenceManager, cache.getCacheConfiguration().clustering().hash().numSegments()));
            CompletionStages.join((CompletionStage)persistenceManager.disableStore(DummyInMemoryStore.class.getName()));
            AssertJUnit.assertEquals((int)storesBefore, (int)this.countStores(persistenceManager));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(cm);
            throw throwable;
        }
        TestingUtil.killCacheManagers(cm);
    }

    private int countStores(PersistenceManager pm) {
        return pm.getStoresAsString().size();
    }

    private Class loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private long getDummyStoreSize(PersistenceManager persistenceManager, int numSegments) {
        return persistenceManager.getStoresAsString().stream().filter(s -> s.equals(DummyInMemoryStore.class.getName())).map(this::loadClass).map(s -> persistenceManager.getStores(s).iterator().next()).map(store -> {
            if (store instanceof DummyInMemoryStore) {
                DummyInMemoryStore dummyInMemoryStore = (DummyInMemoryStore)store;
                return dummyInMemoryStore.size();
            }
            if (store instanceof SingleFileStore) {
                SingleFileStore singleFileStore = (SingleFileStore)store;
                return (Long)CompletionStages.join((CompletionStage)singleFileStore.size(IntSets.immutableRangeSet((int)numSegments)));
            }
            return -1L;
        }).findFirst().orElse(-1L);
    }

    private void checkStore(Cache<?, ?> cache) {
        AsyncInterceptorChain asyncInterceptorChain = cache.getAdvancedCache().getAdvancedCache().getAsyncInterceptorChain();
        AssertJUnit.assertNotNull((Object)asyncInterceptorChain.findInterceptorWithClass(CacheLoaderInterceptor.class));
        AssertJUnit.assertNotNull((Object)asyncInterceptorChain.findInterceptorWithClass(CacheWriterInterceptor.class));
    }

    private void checkPassivation(Cache<?, ?> cache) {
        AsyncInterceptorChain asyncInterceptorChain = cache.getAdvancedCache().getAdvancedCache().getAsyncInterceptorChain();
        AssertJUnit.assertNotNull((Object)asyncInterceptorChain.findInterceptorWithClass(PassivationWriterInterceptor.class));
        if (cache.getAdvancedCache().getCacheConfiguration().clustering().cacheMode().isClustered()) {
            AssertJUnit.assertNotNull((Object)asyncInterceptorChain.findInterceptorWithClass(PassivationClusteredCacheLoaderInterceptor.class));
        } else {
            AssertJUnit.assertNotNull((Object)asyncInterceptorChain.findInterceptorWithClass(PassivationCacheLoaderInterceptor.class));
        }
    }

    private void checkClustered(Cache<?, ?> cache) {
        AsyncInterceptorChain asyncInterceptorChain = cache.getAdvancedCache().getAdvancedCache().getAsyncInterceptorChain();
        AssertJUnit.assertNotNull((Object)asyncInterceptorChain.findInterceptorWithClass(ClusteredCacheLoaderInterceptor.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPassivation(ConfigurationBuilder cacheBuilder) {
        String location = null;
        try {
            location = CommonsTestingUtil.tmpDirectory(this.getClass());
            ((SingleFileStoreConfigurationBuilder)cacheBuilder.persistence().passivation(true).addStore(SingleFileStoreConfigurationBuilder.class)).location(location);
            cacheBuilder.memory().maxCount(1L);
            ConfigurationBuilder toAddBuilder = new ConfigurationBuilder();
            toAddBuilder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
            this.addAndCheckStore(cacheBuilder, (StoreConfiguration)toAddBuilder.build().persistence().stores().get(0), this::checkPassivation);
        }
        finally {
            if (location != null) {
                Util.recursiveFileRemove((String)location);
            }
        }
    }
}

