/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.impl.InternalEntryFactoryImpl;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryFactoryImpl;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.EnsureNonBlockingStore;
import org.infinispan.persistence.support.NonBlockingStoreAdapter;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Key;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.PersistenceMockUtil;
import org.reactivestreams.Publisher;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.BaseNonBlockingStoreTest")
public abstract class BaseNonBlockingStoreTest
extends AbstractInfinispanTest {
    protected static final int WRITE_DELETE_BATCH_MIN_ENTRIES = 80;
    protected static final int WRITE_DELETE_BATCH_MAX_ENTRIES = 120;
    protected TestObjectStreamMarshaller marshaller;
    protected EnsureNonBlockingStore<Object, Object> store;
    protected ControlledTimeService timeService;
    protected InternalEntryFactory internalEntryFactory;
    protected MarshallableEntryFactory<?, ?> marshallableEntryFactory;
    protected Configuration configuration;
    protected int segmentCount;
    protected InitializationContext initializationContext;
    protected KeyPartitioner keyPartitioner = k -> Math.abs(k.hashCode() % this.segmentCount);
    protected Set<NonBlockingStore.Characteristic> characteristics;
    private IntSet segments;

    protected static <K, V> NonBlockingStore<K, V> asNonBlockingStore(CacheLoader<K, V> loader) {
        return new NonBlockingStoreAdapter(loader);
    }

    protected static <K, V> NonBlockingStore<K, V> asNonBlockingStore(CacheWriter<K, V> writer) {
        return new NonBlockingStoreAdapter(writer);
    }

    protected abstract NonBlockingStore<Object, Object> createStore() throws Exception;

    protected abstract Configuration buildConfig(ConfigurationBuilder var1);

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.marshaller = new TestObjectStreamMarshaller(this.getSerializationContextInitializer());
        this.timeService = this.getTimeService();
        this.internalEntryFactory = new InternalEntryFactoryImpl();
        TestingUtil.inject(this.internalEntryFactory, new Object[]{this.timeService});
        this.marshallableEntryFactory = new MarshalledEntryFactoryImpl();
        TestingUtil.inject(this.marshallableEntryFactory, this.marshaller);
        try {
            NonBlockingStore<Object, Object> nonBlockingStore = this.createStore();
            this.store = new EnsureNonBlockingStore<Object, Object>(nonBlockingStore, this.keyPartitioner);
            this.startStore(this.store);
        }
        catch (Exception e) {
            log.error((Object)"Error creating store", (Throwable)e);
            throw e;
        }
    }

    protected void startStore(EnsureNonBlockingStore<?, ?> store) {
        if (this.configuration == null) {
            ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(false);
            this.setConfiguration(this.buildConfig(builder));
        }
        store.startAndWait(this.createContext(this.configuration));
        this.characteristics = store.characteristics();
    }

    protected Object keyToStorage(Object key) {
        return key;
    }

    protected Object valueToStorage(Object value) {
        return value;
    }

    protected void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.segmentCount = configuration.clustering().hash().numSegments();
        this.segments = IntSets.immutableRangeSet((int)this.segmentCount);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws PersistenceException {
        try {
            if (this.store != null) {
                this.store.clearAndWait();
                this.store.stopAndWait();
            }
            if (this.marshaller != null) {
                this.marshaller.stop();
            }
        }
        finally {
            this.store = null;
        }
    }

    protected PersistenceMarshaller getMarshaller() {
        return this.marshaller;
    }

    protected SerializationContextInitializer getSerializationContextInitializer() {
        return TestDataSCI.INSTANCE;
    }

    protected ControlledTimeService getTimeService() {
        return new ControlledTimeService();
    }

    protected Object wrap(Object key, Object value) {
        return value;
    }

    public void testLoadAndStoreImmortal() throws PersistenceException {
        this.assertIsEmpty();
        this.store.write(this.marshalledEntry("k", "v"));
        MarshallableEntry entry = this.store.loadEntry(this.keyToStorage("k"));
        AssertJUnit.assertEquals((Object)this.valueToStorage("v"), (Object)entry.getValue());
        AssertJUnit.assertTrue((String)"Expected an immortalEntry", (entry.getMetadata() == null || entry.expiryTime() == -1L || entry.getMetadata().maxIdle() == -1L ? 1 : 0) != 0);
        this.assertContains("k", true);
        AssertJUnit.assertNotSame((Object)Boolean.TRUE, (Object)this.store.delete(this.keyToStorage("k2")));
    }

    public void testLoadAndStoreWithLifespan() throws Exception {
        if (!this.characteristics.contains(NonBlockingStore.Characteristic.EXPIRATION)) {
            return;
        }
        this.assertIsEmpty();
        long lifespan = 120000L;
        InternalCacheEntry<String, Object> se = this.internalCacheEntry("k", "v", lifespan);
        this.assertExpired(se, false);
        this.store.write(this.marshalledEntry(se));
        this.assertContains("k", true);
        this.assertCorrectExpiry(this.store.loadEntry(this.keyToStorage("k")), "v", lifespan, -1L, false);
        this.assertCorrectExpiry(TestingUtil.allEntries(this.store, this.segments).iterator().next(), "v", lifespan, -1L, false);
        this.timeService.advance(lifespan + 1L);
        lifespan = 2000L;
        se = this.internalCacheEntry("k", "v", lifespan);
        this.assertExpired(se, false);
        this.store.write(this.marshalledEntry(se));
        this.timeService.advance(lifespan + 1L);
        this.purgeExpired("k");
        this.assertExpired(se, true);
        this.assertEventuallyExpires("k");
        this.assertContains("k", false);
        this.assertIsEmpty();
    }

    private void assertCorrectExpiry(MarshallableEntry<?, ?> me, String value, long lifespan, long maxIdle, boolean expired) {
        AssertJUnit.assertNotNull((String)String.valueOf(me), me);
        AssertJUnit.assertEquals((String)(me + ".getValue()"), (Object)this.valueToStorage(value), (Object)me.getValue());
        if (lifespan > -1L) {
            AssertJUnit.assertNotNull((String)(me + ".getMetadata()"), (Object)me.getMetadata());
            AssertJUnit.assertEquals((String)(me + ".getMetadata().lifespan()"), (long)lifespan, (long)me.getMetadata().lifespan());
            AssertJUnit.assertTrue((String)(me + ".created() > -1"), (me.created() > -1L ? 1 : 0) != 0);
        }
        if (maxIdle > -1L) {
            AssertJUnit.assertNotNull((String)(me + ".getMetadata()"), (Object)me.getMetadata());
            AssertJUnit.assertEquals((String)(me + ".getMetadata().maxIdle()"), (long)maxIdle, (long)me.getMetadata().maxIdle());
            AssertJUnit.assertTrue((String)(me + ".lastUsed() > -1"), (me.lastUsed() > -1L ? 1 : 0) != 0);
        }
        if (me.getMetadata() != null) {
            AssertJUnit.assertEquals((String)(me + ".isExpired() "), (boolean)expired, (boolean)me.isExpired(this.timeService.wallClockTime()));
        }
    }

    public void testLoadAndStoreWithIdle() throws Exception {
        if (!this.characteristics.contains(NonBlockingStore.Characteristic.EXPIRATION)) {
            return;
        }
        this.assertIsEmpty();
        long idle = 120000L;
        InternalCacheEntry<Object, Object> se = this.internalCacheEntry("k", "v", -1L, idle);
        this.assertExpired(se, false);
        this.store.write(this.marshalledEntry(se));
        this.assertContains("k", true);
        this.assertCorrectExpiry(this.store.loadEntry(this.keyToStorage("k")), "v", -1L, idle, false);
        this.assertCorrectExpiry(TestingUtil.allEntries(this.store, this.segments).iterator().next(), "v", -1L, idle, false);
        this.timeService.advance(idle + 1L);
        idle = 1000L;
        se = this.internalCacheEntry("k", "v", -1L, idle);
        this.assertExpired(se, false);
        this.store.write(this.marshalledEntry(se));
        this.timeService.advance(idle + 1L);
        this.purgeExpired("k");
        this.assertExpired(se, true);
        this.assertEventuallyExpires("k");
        this.assertContains("k", false);
        this.assertIsEmpty();
    }

    private void assertIsEmpty() {
        this.assertEmpty(TestingUtil.allEntries(this.store, this.segments), true);
    }

    protected void assertEventuallyExpires(String key) throws Exception {
        Object storageKey = this.keyToStorage(key);
        this.eventually(() -> this.store.loadEntry(storageKey) == null);
    }

    protected boolean storePurgesAllExpired() {
        return true;
    }

    protected void purgeExpired(String ... expiredKeys) {
        Set expired = Stream.of(expiredKeys).map(this::keyToStorage).collect(Collectors.toSet());
        List expiredList = this.store.purge();
        expiredList.removeIf(me -> expired.remove(me.getKey()));
        this.assertEmpty(expiredList, true);
        if (this.storePurgesAllExpired()) {
            this.assertEmpty(expired, true);
        }
        AssertJUnit.assertEquals(Collections.emptyList(), (Object)expiredList);
    }

    public void testLoadAndStoreWithLifespanAndIdle() throws Exception {
        if (!this.characteristics.contains(NonBlockingStore.Characteristic.EXPIRATION)) {
            return;
        }
        this.assertIsEmpty();
        long lifespan = 200000L;
        long idle = 120000L;
        InternalCacheEntry<Object, Object> se = this.internalCacheEntry("k", "v", lifespan, idle);
        InternalCacheValue icv = se.toInternalCacheValue();
        AssertJUnit.assertEquals((long)se.getCreated(), (long)icv.getCreated());
        AssertJUnit.assertEquals((long)se.getLastUsed(), (long)icv.getLastUsed());
        this.assertExpired(se, false);
        this.store.write(this.marshalledEntry(se));
        this.assertContains("k", true);
        this.assertCorrectExpiry(this.store.loadEntry(this.keyToStorage("k")), "v", lifespan, idle, false);
        this.assertCorrectExpiry(TestingUtil.allEntries(this.store, this.segments).iterator().next(), "v", lifespan, idle, false);
        this.timeService.advance(idle + 1L);
        idle = 1000L;
        lifespan = 4000L;
        se = this.internalCacheEntry("k", "v", lifespan, idle);
        this.assertExpired(se, false);
        this.store.write(this.marshalledEntry(se));
        this.timeService.advance(idle + 1L);
        this.purgeExpired("k");
        this.assertExpired(se, true);
        this.assertEventuallyExpires("k");
        this.assertContains("k", false);
        this.assertIsEmpty();
    }

    public void testLoadAndStoreWithLifespanAndIdle2() throws Exception {
        if (!this.characteristics.contains(NonBlockingStore.Characteristic.EXPIRATION)) {
            return;
        }
        this.assertContains("k", false);
        long lifespan = 2000L;
        long idle = 2000L;
        InternalCacheEntry<Object, Object> se = this.internalCacheEntry("k", "v", lifespan, idle);
        InternalCacheValue icv = se.toInternalCacheValue();
        AssertJUnit.assertEquals((long)se.getCreated(), (long)icv.getCreated());
        AssertJUnit.assertEquals((long)se.getLastUsed(), (long)icv.getLastUsed());
        this.assertExpired(se, false);
        this.store.write(this.marshalledEntry(se));
        this.assertContains("k", true);
        this.assertCorrectExpiry(this.store.loadEntry(this.keyToStorage("k")), "v", lifespan, idle, false);
        this.assertCorrectExpiry(TestingUtil.allEntries(this.store, this.segments).iterator().next(), "v", lifespan, idle, false);
        idle = 4000L;
        lifespan = 2000L;
        se = this.internalCacheEntry("k", "v", lifespan, idle);
        this.assertExpired(se, false);
        this.store.write(this.marshalledEntry(se));
        this.timeService.advance(lifespan + 1L);
        this.assertExpired(se, true);
        this.purgeExpired("k");
        this.assertEventuallyExpires("k");
        this.assertContains("k", false);
        this.assertIsEmpty();
    }

    public void testStopStartDoesNotNukeValues() throws InterruptedException, PersistenceException {
        this.assertIsEmpty();
        long lifespan = 1000L;
        long idle = 1000L;
        InternalCacheEntry<String, Object> se1 = this.internalCacheEntry("k1", "v1", lifespan);
        InternalCacheEntry<String, Object> se2 = this.internalCacheEntry("k2", "v2", -1L);
        InternalCacheEntry<Object, Object> se3 = this.internalCacheEntry("k3", "v3", -1L, idle);
        InternalCacheEntry<Object, Object> se4 = this.internalCacheEntry("k4", "v4", lifespan, idle);
        this.assertExpired(se1, false);
        this.assertExpired(se2, false);
        this.assertExpired(se3, false);
        this.assertExpired(se4, false);
        this.store.write(this.marshalledEntry(se1));
        this.store.write(this.marshalledEntry(se2));
        this.store.write(this.marshalledEntry(se3));
        this.store.write(this.marshalledEntry(se4));
        this.timeService.advance(lifespan + 1L);
        this.assertExpired(se1, true);
        this.assertExpired(se2, false);
        this.assertExpired(se3, true);
        this.assertExpired(se4, true);
        this.store.stopAndWait();
        this.startStore(this.store);
        this.assertExpired(se1, true);
        AssertJUnit.assertNull((Object)this.store.loadEntry(this.keyToStorage("k1")));
        this.assertContains("k1", false);
        this.assertExpired(se2, false);
        AssertJUnit.assertNotNull((Object)this.store.loadEntry(this.keyToStorage("k2")));
        this.assertContains("k2", true);
        AssertJUnit.assertEquals((Object)this.valueToStorage("v2"), (Object)this.store.loadEntry(this.keyToStorage("k2")).getValue());
        this.assertExpired(se3, true);
        AssertJUnit.assertNull((Object)this.store.loadEntry(this.keyToStorage("k3")));
        this.assertContains("k3", false);
        this.assertExpired(se4, true);
        AssertJUnit.assertNull((Object)this.store.loadEntry(this.keyToStorage("k4")));
        this.assertContains("k4", false);
    }

    public void testPreload() throws Exception {
        this.assertIsEmpty();
        this.store.write(this.marshalledEntry("k1", "v1"));
        this.store.write(this.marshalledEntry("k2", "v2"));
        this.store.write(this.marshalledEntry("k3", "v3"));
        Set<MarshallableEntry<Object, Object>> set = TestingUtil.allEntries(this.store, this.segments);
        this.assertSize(set, 3);
        Set expected = Stream.of("k1", "k2", "k3").map(this::keyToStorage).collect(Collectors.toSet());
        for (MarshallableEntry<Object, Object> se : set) {
            AssertJUnit.assertTrue((boolean)expected.remove(se.getKey()));
        }
        this.assertEmpty(expected, true);
    }

    public void testStoreAndRemove() throws PersistenceException {
        this.assertIsEmpty();
        this.store.write(this.marshalledEntry("k1", "v1"));
        this.store.write(this.marshalledEntry("k2", "v2"));
        this.store.write(this.marshalledEntry("k3", "v3"));
        this.store.write(this.marshalledEntry("k4", "v4"));
        Set<MarshallableEntry<Object, Object>> set = TestingUtil.allEntries(this.store, this.segments);
        this.assertSize(set, 4);
        Set expected = Stream.of("k1", "k2", "k3", "k4").map(this::keyToStorage).collect(Collectors.toSet());
        for (MarshallableEntry<Object, Object> se : set) {
            AssertJUnit.assertTrue((boolean)expected.remove(se.getKey()));
        }
        this.assertEmpty(expected, true);
        this.store.delete(this.keyToStorage("k1"));
        this.store.delete(this.keyToStorage("k2"));
        this.store.delete(this.keyToStorage("k3"));
        set = TestingUtil.allEntries(this.store, this.segments);
        this.assertSize(set, 1);
        AssertJUnit.assertEquals((Object)this.keyToStorage("k4"), (Object)set.iterator().next().getKey());
        AssertJUnit.assertEquals((int)1, (int)this.store.publishKeysWait(this.segments, null).size());
    }

    public void testSizeApproximation() {
        this.assertIsEmpty();
        this.store.write(this.marshalledEntry("k1", "v1"));
        this.store.write(this.marshalledEntry("k2", "v2"));
        this.store.write(this.marshalledEntry("k3", "v3"));
        this.store.write(this.marshalledEntry("k4", "v4"));
        AssertJUnit.assertEquals((long)4L, (long)this.store.approximateSizeWait(this.segments));
    }

    public void testPurgeExpired() throws Exception {
        if (!this.characteristics.contains(NonBlockingStore.Characteristic.EXPIRATION)) {
            return;
        }
        this.assertIsEmpty();
        long lifespan = 7000L;
        long idle = 2000L;
        InternalCacheEntry<String, Object> ice1 = this.internalCacheEntry("k1", "v1", lifespan);
        this.store.write(this.marshalledEntry(ice1));
        this.assertContains("k1", true);
        InternalCacheEntry<Object, Object> ice2 = this.internalCacheEntry("k2", "v2", -1L, idle);
        this.store.write(this.marshalledEntry(ice2));
        this.assertContains("k2", true);
        InternalCacheEntry<Object, Object> ice3 = this.internalCacheEntry("k3", "v3", lifespan, idle);
        this.store.write(this.marshalledEntry(ice3));
        this.assertContains("k3", true);
        InternalCacheEntry<Object, Object> ice4 = this.internalCacheEntry("k4", "v4", -1L, -1L);
        this.store.write(this.marshalledEntry(ice4));
        this.assertContains("k4", true);
        InternalCacheEntry<Object, Object> ice5 = this.internalCacheEntry("k5", "v5", lifespan * 1000L, idle * 1000L);
        this.store.write(this.marshalledEntry(ice5));
        this.assertContains("k5", true);
        this.timeService.advance(lifespan + 1L);
        this.assertContains("k1", false);
        this.assertContains("k2", false);
        this.assertContains("k3", false);
        this.assertContains("k4", true);
        this.assertContains("k5", true);
        this.purgeExpired("k1", "k2", "k3");
        this.assertContains("k1", false);
        this.assertContains("k2", false);
        this.assertContains("k3", false);
        this.assertContains("k4", true);
        this.assertContains("k5", true);
    }

    public void testLoadAll() throws PersistenceException {
        this.assertIsEmpty();
        this.store.write(this.marshalledEntry("k1", "v1"));
        this.store.write(this.marshalledEntry("k2", "v2"));
        this.store.write(this.marshalledEntry("k3", "v3"));
        this.store.write(this.marshalledEntry("k4", "v4"));
        this.store.write(this.marshalledEntry("k5", "v5"));
        Set<MarshallableEntry<Object, Object>> s = TestingUtil.allEntries(this.store, this.segments);
        this.assertSize(s, 5);
        s = TestingUtil.allEntries(this.store, this.segments, k -> true);
        this.assertSize(s, 5);
        Object storedK3 = this.keyToStorage("k3");
        s = TestingUtil.allEntries(this.store, this.segments, k -> !storedK3.equals(k));
        this.assertSize(s, 4);
        for (MarshallableEntry<Object, Object> me : s) {
            AssertJUnit.assertFalse((boolean)me.getKey().equals(storedK3));
        }
    }

    public void testReplaceEntry() {
        this.assertIsEmpty();
        InternalCacheEntry<String, Object> tmpIce = this.internalCacheEntry("ok", "v1", -1L);
        this.store.write(this.marshalledEntry(tmpIce));
        InternalCacheEntry<String, Object> ice = this.internalCacheEntry("k1", "v1", -1L);
        this.store.write(this.marshalledEntry(ice));
        AssertJUnit.assertEquals((Object)this.valueToStorage("v1"), (Object)this.store.loadEntry(this.keyToStorage("k1")).getValue());
        InternalCacheEntry<String, Object> ice2 = this.internalCacheEntry("k1", "v2", -1L);
        this.store.write(this.marshalledEntry(ice2));
        AssertJUnit.assertEquals((Object)this.valueToStorage("v2"), (Object)this.store.loadEntry(this.keyToStorage("k1")).getValue());
    }

    public void testReplaceExpiredEntry() throws Exception {
        this.assertIsEmpty();
        long lifespan = 3000L;
        InternalCacheEntry<String, Object> ice = this.internalCacheEntry("k1", "v1", 3000L);
        this.assertExpired(ice, false);
        this.store.write(this.marshalledEntry(ice));
        Object storedKey = this.keyToStorage("k1");
        AssertJUnit.assertEquals((Object)"v1", (Object)this.store.loadEntry(storedKey).getValue());
        this.timeService.advance(3001L);
        this.assertExpired(ice, true);
        AssertJUnit.assertNull((Object)this.store.loadEntry(storedKey));
        InternalCacheEntry<String, Object> ice2 = this.internalCacheEntry("k1", "v2", 3000L);
        this.assertExpired(ice2, false);
        this.store.write(this.marshalledEntry(ice2));
        AssertJUnit.assertEquals((Object)this.valueToStorage("v2"), (Object)this.store.loadEntry(storedKey).getValue());
        this.timeService.advance(3001L);
        this.assertExpired(ice2, true);
        AssertJUnit.assertNull((Object)this.store.loadEntry(storedKey));
    }

    public void testLoadAndStoreBytesValues() throws PersistenceException, IOException, InterruptedException {
        this.assertIsEmpty();
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        TestDataSCI sci = TestDataSCI.INSTANCE;
        sci.registerSchema(ctx);
        sci.registerMarshallers(ctx);
        ProtoStreamMarshaller userMarshaller = new ProtoStreamMarshaller(ctx);
        WrappedByteArray key = new WrappedByteArray(userMarshaller.objectToByteBuffer((Object)new Key("key")));
        WrappedByteArray key2 = new WrappedByteArray(userMarshaller.objectToByteBuffer((Object)new Key("key2")));
        WrappedByteArray value = new WrappedByteArray(userMarshaller.objectToByteBuffer((Object)new Person()));
        AssertJUnit.assertFalse((boolean)this.store.contains(key));
        PersistenceMarshaller persistenceMarshaller = this.getMarshaller();
        this.store.write(MarshalledEntryUtil.create(key, value, (Marshaller)persistenceMarshaller));
        AssertJUnit.assertEquals((Object)value, (Object)this.store.loadEntry(key).getValue());
        MarshallableEntry entry = this.store.loadEntry(key);
        AssertJUnit.assertTrue((String)"Expected an immortalEntry", (entry.getMetadata() == null || entry.expiryTime() == -1L || entry.getMetadata().maxIdle() == -1L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)this.store.contains(key));
        AssertJUnit.assertNotSame((Object)Boolean.TRUE, (Object)this.store.delete(key2));
        AssertJUnit.assertNotSame((Object)Boolean.FALSE, (Object)this.store.delete(key));
    }

    public void testWriteAndDeleteBatch() {
        int numberOfEntries = 2 * ThreadLocalRandom.current().nextInt(40, 61);
        this.testBatch(numberOfEntries, () -> this.store.batchUpdate(this.segmentCount, (Publisher)Flowable.empty(), TestingUtil.multipleSegmentPublisher(Flowable.range((int)0, (int)numberOfEntries).map(i -> this.marshalledEntry(i.toString(), "Val" + i)), MarshallableEntry::getKey, this.keyPartitioner)));
    }

    public void testWriteAndDeleteBatchIterable() {
        int numberOfEntries = 2 * ThreadLocalRandom.current().nextInt(40, 61);
        this.testBatch(numberOfEntries, () -> this.store.batchUpdate(this.segmentCount, (Publisher)Flowable.empty(), TestingUtil.multipleSegmentPublisher(Flowable.range((int)0, (int)numberOfEntries).map(i -> this.marshalledEntry(i.toString(), "Val" + i)), MarshallableEntry::getKey, this.keyPartitioner)));
    }

    public void testEmptyWriteAndDeleteBatchIterable() {
        this.assertIsEmpty();
        AssertJUnit.assertNull((String)"should not be present in the store", (Object)this.store.loadEntry(this.keyToStorage(0)));
        this.store.batchUpdate(1, (Publisher)Flowable.empty(), (Publisher)Flowable.empty());
        AssertJUnit.assertEquals((long)0L, (long)this.store.sizeWait(this.segments));
    }

    private void testBatch(int numberOfEntries, Runnable createBatch) {
        this.assertIsEmpty();
        AssertJUnit.assertNull((String)"should not be present in the store", (Object)this.store.loadEntry(this.keyToStorage(0)));
        createBatch.run();
        Set<MarshallableEntry<Object, Object>> set = TestingUtil.allEntries(this.store, this.segments);
        this.assertSize(set, numberOfEntries);
        AssertJUnit.assertNotNull((Object)this.store.loadEntry(this.keyToStorage("56")));
        int batchSize = numberOfEntries / 2;
        List keys = IntStream.range(0, batchSize).mapToObj(Integer::toString).map(this::keyToStorage).collect(Collectors.toList());
        this.store.batchUpdate(this.segmentCount, TestingUtil.multipleSegmentPublisher(Flowable.fromIterable(keys), Function.identity(), this.keyPartitioner), (Publisher)Flowable.empty());
        set = TestingUtil.allEntries(this.store, this.segments);
        this.assertSize(set, batchSize);
        AssertJUnit.assertNull((Object)this.store.loadEntry(this.keyToStorage("20")));
    }

    public void testIsAvailable() {
        AssertJUnit.assertTrue((boolean)this.store.checkAvailable());
    }

    protected final InitializationContext createContext(Configuration configuration) {
        PersistenceMockUtil.InvocationContextBuilder builder = new PersistenceMockUtil.InvocationContextBuilder(this.getClass(), configuration, this.getMarshaller()).setTimeService((TimeService)this.timeService).setKeyPartitioner(this.keyPartitioner);
        this.modifyInitializationContext(builder);
        this.initializationContext = builder.build();
        return this.initializationContext;
    }

    protected void modifyInitializationContext(PersistenceMockUtil.InvocationContextBuilder contextBuilder) {
    }

    protected final void assertContains(Object k, boolean expected) {
        Object transformedKey = this.keyToStorage(k);
        AssertJUnit.assertEquals((String)("contains(" + transformedKey + ")"), (boolean)expected, (boolean)this.store.contains(transformedKey));
    }

    protected final <K> InternalCacheEntry<K, Object> internalCacheEntry(K key, Object value, long lifespan) {
        Object transformedKey = this.keyToStorage(key);
        Object transformedValue = this.valueToStorage(value);
        return TestInternalCacheEntryFactory.create(this.internalEntryFactory, transformedKey, this.wrap(transformedKey, transformedValue), lifespan);
    }

    private InternalCacheEntry<Object, Object> internalCacheEntry(String key, String value, long lifespan, long idle) {
        Object transformedKey = this.keyToStorage(key);
        Object transformedValue = this.valueToStorage(value);
        return TestInternalCacheEntryFactory.create(this.internalEntryFactory, transformedKey, this.wrap(transformedKey, transformedValue), lifespan, idle);
    }

    private MarshallableEntry<Object, Object> marshalledEntry(String key, String value) {
        Object transformedKey = this.keyToStorage(key);
        Object transformedValue = this.valueToStorage(value);
        return MarshalledEntryUtil.create(transformedKey, this.wrap(transformedKey, transformedValue), (Marshaller)this.getMarshaller());
    }

    protected final MarshallableEntry<Object, Object> marshalledEntry(InternalCacheEntry<Object, Object> entry) {
        return MarshalledEntryUtil.create(entry, (Marshaller)this.getMarshaller());
    }

    private void assertSize(Collection<?> collection, int expected) {
        AssertJUnit.assertEquals((String)(collection + ".size()"), (int)expected, (int)collection.size());
    }

    private void assertExpired(InternalCacheEntry<Object, Object> entry, boolean expected) {
        AssertJUnit.assertEquals((String)(entry + ".isExpired() "), (boolean)expected, (boolean)entry.isExpired(this.timeService.wallClockTime()));
    }

    private void assertEmpty(Collection<?> collection, boolean expected) {
        AssertJUnit.assertEquals((String)(collection + ".isEmpty()"), (boolean)expected, (boolean)collection.isEmpty());
    }
}

