/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.ByRef;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerStub;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.WaitDelegatingNonBlockingStore;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Person;
import org.infinispan.test.data.Sex;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit", "smoke"}, testName="persistence.BaseStoreFunctionalTest")
public abstract class BaseStoreFunctionalTest
extends SingleCacheManagerTest {
    private static final SerializationContextInitializer CONTEXT_INITIALIZER = TestDataSCI.INSTANCE;

    protected abstract PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder var1, String var2, boolean var3);

    protected ConfigurationBuilder getDefaultCacheConfiguration() {
        return TestCacheManagerFactory.getDefaultCacheConfiguration(false);
    }

    protected Object wrap(String key, String value) {
        return value;
    }

    protected String unwrap(Object wrapped) {
        return (String)wrapped;
    }

    protected BaseStoreFunctionalTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    @Override
    protected void teardown() {
        TestingUtil.clearContent(this.cacheManager);
        super.teardown();
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory(this.getClass()));
        global.serialization().addContextInitializer(this.getSerializationContextInitializer());
        return this.createCacheManager(false, global, new ConfigurationBuilder());
    }

    protected EmbeddedCacheManager createCacheManager(boolean start, GlobalConfigurationBuilder global, ConfigurationBuilder cb) {
        return TestCacheManagerFactory.newDefaultCacheManager(start, global, cb);
    }

    protected SerializationContextInitializer getSerializationContextInitializer() {
        return CONTEXT_INITIALIZER;
    }

    public void testTwoCachesSameCacheStore() {
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        cb.read(this.cacheManager.getDefaultCacheConfiguration());
        this.createCacheStoreConfig(cb.persistence(), "testTwoCachesSameCacheStore", false);
        Configuration c = cb.build();
        this.cacheManager.defineConfiguration("testTwoCachesSameCacheStore-1", c);
        this.cacheManager.defineConfiguration("testTwoCachesSameCacheStore-2", c);
        Cache first = this.cacheManager.getCache("testTwoCachesSameCacheStore-1");
        Cache second = this.cacheManager.getCache("testTwoCachesSameCacheStore-2");
        first.start();
        second.start();
        first.put((Object)"key", this.wrap("key", "val"));
        AssertJUnit.assertEquals((String)"val", (String)this.unwrap(first.get((Object)"key")));
        AssertJUnit.assertNull((Object)second.get((Object)"key"));
        second.put((Object)"key2", this.wrap("key2", "val2"));
        AssertJUnit.assertEquals((String)"val2", (String)this.unwrap(second.get((Object)"key2")));
        AssertJUnit.assertNull((Object)first.get((Object)"key2"));
    }

    public void testPreloadAndExpiry() {
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), "testPreloadAndExpiry", true);
        this.cacheManager.defineConfiguration("testPreloadAndExpiry", cb.build());
        Cache cache = this.cacheManager.getCache("testPreloadAndExpiry");
        cache.start();
        assert (cache.getCacheConfiguration().persistence().preload().booleanValue());
        cache.put((Object)"k1", this.wrap("k1", "v"));
        cache.put((Object)"k2", this.wrap("k2", "v"), 111111L, TimeUnit.MILLISECONDS);
        cache.put((Object)"k3", this.wrap("k3", "v"), -1L, TimeUnit.MILLISECONDS, 222222L, TimeUnit.MILLISECONDS);
        cache.put((Object)"k4", this.wrap("k4", "v"), 333333L, TimeUnit.MILLISECONDS, 444444L, TimeUnit.MILLISECONDS);
        this.assertCacheEntry(cache, "k1", "v", -1L, -1L);
        this.assertCacheEntry(cache, "k2", "v", 111111L, -1L);
        this.assertCacheEntry(cache, "k3", "v", -1L, 222222L);
        this.assertCacheEntry(cache, "k4", "v", 333333L, 444444L);
        cache.stop();
        cache.start();
        this.assertCacheEntry(cache, "k1", "v", -1L, -1L);
        this.assertCacheEntry(cache, "k2", "v", 111111L, -1L);
        this.assertCacheEntry(cache, "k3", "v", -1L, 222222L);
        this.assertCacheEntry(cache, "k4", "v", 333333L, 444444L);
    }

    public void testPreloadStoredAsBinary() {
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), "testPreloadStoredAsBinary", true).memory().storageType(StorageType.BINARY);
        this.cacheManager.defineConfiguration("testPreloadStoredAsBinary", cb.build());
        Cache cache = this.cacheManager.getCache("testPreloadStoredAsBinary");
        cache.start();
        assert (cache.getCacheConfiguration().persistence().preload().booleanValue());
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)cache.getCacheConfiguration().memory().storageType());
        byte[] pictureBytes = new byte[]{1, 82, 123, 19};
        cache.put((Object)"k1", (Object)new Person("1"));
        cache.put((Object)"k2", (Object)new Person("2", null, pictureBytes, null, null), 111111L, TimeUnit.MILLISECONDS);
        cache.put((Object)"k3", (Object)new Person("3", null, null, Sex.MALE, null), -1L, TimeUnit.MILLISECONDS, 222222L, TimeUnit.MILLISECONDS);
        cache.put((Object)"k4", (Object)new Person("4", new Address("Street", "City", 12345), null, null, null), 333333L, TimeUnit.MILLISECONDS, 444444L, TimeUnit.MILLISECONDS);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("EST"));
        calendar.set(2009, 2, 18, 3, 22, 57);
        calendar.setTimeInMillis(calendar.getTimeInMillis() / 1000L * 1000L);
        Date infinispanBirthDate = calendar.getTime();
        cache.put((Object)"Infinispan", (Object)new Person("Infinispan", null, null, null, infinispanBirthDate));
        cache.getAdvancedCache().getDataContainer().clear();
        AssertJUnit.assertEquals((Object)this.createEmptyPerson("1"), (Object)cache.get((Object)"k1"));
        Person person2 = this.createEmptyPerson("2");
        person2.setPicture(pictureBytes);
        AssertJUnit.assertEquals((Object)person2, (Object)cache.get((Object)"k2"));
        Person person3 = this.createEmptyPerson("3");
        person3.setSex(Sex.MALE);
        AssertJUnit.assertEquals((Object)person3, (Object)cache.get((Object)"k3"));
        AssertJUnit.assertEquals((Object)new Person("4", new Address("Street", "City", 12345), null, null, null), (Object)cache.get((Object)"k4"));
        Person infinispanPerson = this.createEmptyPerson("Infinispan");
        infinispanPerson.setBirthDate(infinispanBirthDate);
        AssertJUnit.assertEquals((Object)infinispanPerson, (Object)cache.get((Object)"Infinispan"));
        cache.stop();
        cache.start();
        AssertJUnit.assertEquals((int)5, (int)cache.entrySet().size());
        AssertJUnit.assertEquals((Object)this.createEmptyPerson("1"), (Object)cache.get((Object)"k1"));
        AssertJUnit.assertEquals((Object)person2, (Object)cache.get((Object)"k2"));
        AssertJUnit.assertEquals((Object)person3, (Object)cache.get((Object)"k3"));
        AssertJUnit.assertEquals((Object)new Person("4", new Address("Street", "City", 12345), null, null, null), (Object)cache.get((Object)"k4"));
        AssertJUnit.assertEquals((Object)infinispanPerson, (Object)cache.get((Object)"Infinispan"));
    }

    protected Person createEmptyPerson(String name) {
        return new Person(name);
    }

    public void testStoreByteArrays(Method m) throws PersistenceException {
        ConfigurationBuilder base = this.getDefaultCacheConfiguration();
        this.cacheManager.defineConfiguration(m.getName(), this.configureCacheLoader(base, m.getName(), true).build());
        Cache cache = this.cacheManager.getCache(m.getName());
        byte[] key = new byte[]{1, 2, 3};
        byte[] value = new byte[]{4, 5, 6};
        cache.put((Object)key, (Object)value);
        byte[] lookupKey = new byte[]{1, 2, 3};
        byte[] found = (byte[])cache.get((Object)lookupKey);
        AssertJUnit.assertNotNull((Object)found);
        AssertJUnit.assertArrayEquals((byte[])value, (byte[])found);
        cache.evict((Object)key);
        found = (byte[])cache.get((Object)lookupKey);
        AssertJUnit.assertNotNull((Object)found);
        AssertJUnit.assertArrayEquals((byte[])value, (byte[])found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveCache() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory(this.getClass()));
        global.serialization().addContextInitializer(this.getSerializationContextInitializer());
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        String cacheName = "testRemoveCache";
        this.createCacheStoreConfig(cb.persistence(), "testRemoveCache", true);
        EmbeddedCacheManager local = this.createCacheManager(true, global, cb);
        try {
            local.defineConfiguration("testRemoveCache", local.getDefaultCacheConfiguration());
            Cache cache = local.getCache("testRemoveCache");
            AssertJUnit.assertTrue((boolean)local.isRunning("testRemoveCache"));
            cache.put((Object)"1", this.wrap("1", "v1"));
            this.assertCacheEntry(cache, "1", "v1", -1L, -1L);
            local.administration().removeCache("testRemoveCache");
            AssertJUnit.assertFalse((boolean)local.isRunning("testRemoveCache"));
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(local);
            throw throwable;
        }
        TestingUtil.killCacheManagers(local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveCacheWithPassivation() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalState().persistentLocation(CommonsTestingUtil.tmpDirectory(this.getClass()));
        global.serialization().addContextInitializer(this.getSerializationContextInitializer());
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        String cacheName = "testRemoveCacheWithPassivation";
        this.createCacheStoreConfig(cb.persistence().passivation(true), "testRemoveCacheWithPassivation", true);
        EmbeddedCacheManager local = this.createCacheManager(true, global, cb);
        try {
            local.defineConfiguration("testRemoveCacheWithPassivation", local.getDefaultCacheConfiguration());
            Cache cache = local.getCache("testRemoveCacheWithPassivation");
            AssertJUnit.assertTrue((boolean)local.isRunning("testRemoveCacheWithPassivation"));
            cache.put((Object)"1", this.wrap("1", "v1"));
            this.assertCacheEntry(cache, "1", "v1", -1L, -1L);
            ByRef passivate = new ByRef((Object)false);
            PersistenceManager actual = (PersistenceManager)cache.getAdvancedCache().getComponentRegistry().getComponent(PersistenceManager.class);
            DelegatingPersistenceManager stub = new DelegatingPersistenceManager(actual, (ByRef<Boolean>)passivate);
            TestingUtil.replaceComponent(cache, PersistenceManager.class, stub, true);
            local.administration().removeCache("testRemoveCacheWithPassivation");
            AssertJUnit.assertFalse((boolean)local.isRunning("testRemoveCacheWithPassivation"));
            AssertJUnit.assertFalse((boolean)((Boolean)passivate.get()));
            AssertJUnit.assertEquals((int)-1, (int)((Long)CompletionStages.join((CompletionStage)actual.size())).intValue());
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers(local);
            throw throwable;
        }
        TestingUtil.killCacheManagers(local);
    }

    public void testPutAllBatch() {
        int numberOfEntries = 100;
        String cacheName = "testPutAllBatch";
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), cacheName, false);
        this.cacheManager.defineConfiguration(cacheName, cb.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        Map<String, Object> entriesMap = IntStream.range(0, numberOfEntries).boxed().collect(Collectors.toMap(Object::toString, i -> this.wrap(i.toString(), "Val" + i)));
        cache.putAll(entriesMap);
        AssertJUnit.assertEquals((int)numberOfEntries, (int)cache.size());
        WaitDelegatingNonBlockingStore store = TestingUtil.getFirstStoreWait(cache);
        for (int i2 = 0; i2 < numberOfEntries; ++i2) {
            AssertJUnit.assertNotNull((String)("Entry for key: " + i2 + " was null"), store.loadEntry(this.toStorage(cache, Integer.toString(i2))));
        }
    }

    Object fromStorage(Cache<?, ?> cache, Object value) {
        return cache.getAdvancedCache().getValueDataConversion().withRequestMediaType(MediaType.APPLICATION_OBJECT).fromStorage(value);
    }

    Object toStorage(Cache<?, ?> cache, Object key) {
        return cache.getAdvancedCache().getKeyDataConversion().withRequestMediaType(MediaType.APPLICATION_OBJECT).toStorage(key);
    }

    public void testLoadEntrySet() {
        int numberOfEntries = 10;
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), "testLoadEntrySet", true);
        Configuration configuration = cb.build();
        this.cacheManager.defineConfiguration("testLoadEntrySet", configuration);
        Cache cache = this.cacheManager.getCache("testLoadEntrySet");
        Map<String, Object> entriesMap = IntStream.range(0, numberOfEntries).boxed().collect(Collectors.toMap(Object::toString, i -> this.wrap(i.toString(), "Val" + i)));
        cache.putAll(entriesMap);
        cache.stop();
        cache.start();
        CacheSet set = cache.entrySet();
        AssertJUnit.assertEquals((int)numberOfEntries, (int)cache.size());
        AssertJUnit.assertEquals((int)numberOfEntries, (int)set.size());
        set.forEach(e -> AssertJUnit.assertEquals(entriesMap.get(e.getKey()), e.getValue()));
    }

    public void testReloadWithEviction() {
        int numberOfEntries = 10;
        ConfigurationBuilder cb = this.getDefaultCacheConfiguration();
        this.createCacheStoreConfig(cb.persistence(), "testReloadWithEviction", false).memory().size((long)(numberOfEntries / 2)).evictionType(EvictionType.COUNT);
        this.cacheManager.defineConfiguration("testReloadWithEviction", cb.build());
        Cache cache = this.cacheManager.getCache("testReloadWithEviction");
        Map<String, Object> entriesMap = IntStream.range(0, numberOfEntries).boxed().collect(Collectors.toMap(Object::toString, i -> this.wrap(i.toString(), "Val" + i)));
        cache.putAll(entriesMap);
        AssertJUnit.assertEquals((int)numberOfEntries, (int)cache.size());
        entriesMap.forEach((k, v) -> AssertJUnit.assertEquals((Object)v, (Object)cache.get(k)));
        cache.stop();
        cache.start();
        AssertJUnit.assertEquals((int)numberOfEntries, (int)cache.size());
        entriesMap.forEach((k, v) -> AssertJUnit.assertEquals((Object)v, (Object)cache.get(k)));
    }

    protected ConfigurationBuilder configureCacheLoader(ConfigurationBuilder base, String cacheName, boolean purge) {
        ConfigurationBuilder cfg = base == null ? this.getDefaultCacheConfiguration() : base;
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        this.createCacheStoreConfig(cfg.persistence(), cacheName, false);
        ((StoreConfigurationBuilder)cfg.persistence().stores().get(0)).purgeOnStartup(purge);
        return cfg;
    }

    private void assertCacheEntry(Cache cache, String key, String value, long lifespanMillis, long maxIdleMillis) {
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.get(this.toStorage(cache, key));
        AssertJUnit.assertNotNull((Object)ice);
        AssertJUnit.assertEquals((String)value, (String)this.unwrap(this.fromStorage(cache, ice.getValue())));
        AssertJUnit.assertEquals((long)lifespanMillis, (long)ice.getLifespan());
        AssertJUnit.assertEquals((long)maxIdleMillis, (long)ice.getMaxIdle());
        if (lifespanMillis > -1L) assert (ice.getCreated() > -1L) : "Lifespan is set but created time is not";
        if (maxIdleMillis > -1L) assert (ice.getLastUsed() > -1L) : "Max idle is set but last used is not";
    }

    @SurvivesRestarts
    static class DelegatingPersistenceManager
    extends PersistenceManagerStub {
        private final PersistenceManager actual;
        private final ByRef<Boolean> passivate;

        public DelegatingPersistenceManager(PersistenceManager actual, ByRef<Boolean> passivate) {
            this.actual = actual;
            this.passivate = passivate;
        }

        public void stop() {
            this.actual.stop();
        }

        public <K, V> CompletionStage<Void> writeEntries(Iterable<MarshallableEntry<K, V>> iterable, Predicate<? super StoreConfiguration> predicate) {
            this.passivate.set((Object)true);
            return super.writeEntries(iterable, predicate);
        }
    }
}

