/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.impl.InternalEntryFactoryImpl;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.spi.AdvancedCacheExpirationWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Key;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.PersistenceMockUtil;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.reactivestreams.Publisher;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.BaseStoreTest")
public abstract class BaseStoreTest
extends AbstractInfinispanTest {
    protected static final int WRITE_DELETE_BATCH_MIN_ENTRIES = 80;
    protected static final int WRITE_DELETE_BATCH_MAX_ENTRIES = 120;
    protected TestObjectStreamMarshaller marshaller;
    protected AdvancedLoadWriteStore<Object, Object> cl;
    protected ControlledTimeService timeService;
    private InternalEntryFactory factory;

    protected abstract AdvancedLoadWriteStore createStore() throws Exception;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.marshaller = new TestObjectStreamMarshaller(this.getSerializationContextInitializer());
        this.timeService = this.getTimeService();
        this.factory = new InternalEntryFactoryImpl();
        TestingUtil.inject(this.factory, new Object[]{this.timeService});
        try {
            this.cl = this.createStore();
            this.cl.start();
        }
        catch (Exception e) {
            log.error((Object)"Error creating store", (Throwable)e);
            throw e;
        }
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws PersistenceException {
        try {
            if (this.cl != null) {
                this.cl.clear();
                this.cl.destroy();
            }
            if (this.marshaller != null) {
                this.marshaller.stop();
            }
        }
        finally {
            this.cl = null;
        }
    }

    protected PersistenceMarshaller getMarshaller() {
        return this.marshaller;
    }

    protected SerializationContextInitializer getSerializationContextInitializer() {
        return TestDataSCI.INSTANCE;
    }

    protected ControlledTimeService getTimeService() {
        return new ControlledTimeService();
    }

    protected Object wrap(String key, String value) {
        return value;
    }

    protected String unwrap(Object wrapped) {
        return (String)wrapped;
    }

    public void testLoadAndStoreImmortal() throws PersistenceException {
        this.assertIsEmpty();
        this.cl.write(this.marshalledEntry("k", "v"));
        MarshallableEntry entry = this.cl.loadEntry((Object)"k");
        AssertJUnit.assertEquals((String)"v", (String)this.unwrap(entry.getValue()));
        AssertJUnit.assertTrue((String)"Expected an immortalEntry", (entry.getMetadata() == null || entry.expiryTime() == -1L || entry.getMetadata().maxIdle() == -1L ? 1 : 0) != 0);
        this.assertContains("k", true);
        AssertJUnit.assertFalse((boolean)this.cl.delete((Object)"k2"));
    }

    public void testLoadAndStoreWithLifespan() throws Exception {
        this.assertIsEmpty();
        long lifespan = 120000L;
        InternalCacheEntry<Object, Object> se = this.internalCacheEntry("k", "v", lifespan);
        this.assertExpired(se, false);
        this.cl.write(this.marshalledEntry(se));
        this.assertContains("k", true);
        this.assertCorrectExpiry(this.cl.loadEntry((Object)"k"), "v", lifespan, -1L, false);
        this.assertCorrectExpiry(TestingUtil.allEntries(this.cl).iterator().next(), "v", lifespan, -1L, false);
        this.timeService.advance(lifespan + 1L);
        lifespan = 2000L;
        se = this.internalCacheEntry("k", "v", lifespan);
        this.assertExpired(se, false);
        this.cl.write(this.marshalledEntry(se));
        this.timeService.advance(lifespan + 1L);
        this.purgeExpired("k");
        this.assertExpired(se, true);
        this.assertEventuallyExpires("k");
        this.assertContains("k", false);
        this.assertIsEmpty();
    }

    private void assertCorrectExpiry(MarshallableEntry me, String value, long lifespan, long maxIdle, boolean expired) {
        AssertJUnit.assertNotNull((String)String.valueOf(me), (Object)me);
        AssertJUnit.assertEquals((String)(me + ".getValue()"), (String)value, (String)this.unwrap(me.getValue()));
        if (lifespan > -1L) {
            AssertJUnit.assertNotNull((String)(me + ".getMetadata()"), (Object)me.getMetadata());
            AssertJUnit.assertEquals((String)(me + ".getMetadata().lifespan()"), (long)lifespan, (long)me.getMetadata().lifespan());
            AssertJUnit.assertTrue((String)(me + ".created() > -1"), (me.created() > -1L ? 1 : 0) != 0);
        }
        if (maxIdle > -1L) {
            AssertJUnit.assertNotNull((String)(me + ".getMetadata()"), (Object)me.getMetadata());
            AssertJUnit.assertEquals((String)(me + ".getMetadata().maxIdle()"), (long)maxIdle, (long)me.getMetadata().maxIdle());
            AssertJUnit.assertTrue((String)(me + ".lastUsed() > -1"), (me.lastUsed() > -1L ? 1 : 0) != 0);
        }
        if (me.getMetadata() != null) {
            AssertJUnit.assertEquals((String)(me + ".isExpired() "), (boolean)expired, (boolean)me.isExpired(this.timeService.wallClockTime()));
        }
    }

    public void testLoadAndStoreWithIdle() throws Exception {
        this.assertIsEmpty();
        long idle = 120000L;
        InternalCacheEntry<Object, Object> se = this.internalCacheEntry("k", "v", -1L, idle);
        this.assertExpired(se, false);
        this.cl.write(this.marshalledEntry(se));
        this.assertContains("k", true);
        this.assertCorrectExpiry(this.cl.loadEntry((Object)"k"), "v", -1L, idle, false);
        this.assertCorrectExpiry(TestingUtil.allEntries(this.cl).iterator().next(), "v", -1L, idle, false);
        this.timeService.advance(idle + 1L);
        idle = 1000L;
        se = this.internalCacheEntry("k", "v", -1L, idle);
        this.assertExpired(se, false);
        this.cl.write(this.marshalledEntry(se));
        this.timeService.advance(idle + 1L);
        this.purgeExpired("k");
        this.assertExpired(se, true);
        this.assertEventuallyExpires("k");
        this.assertContains("k", false);
        this.assertIsEmpty();
    }

    private void assertIsEmpty() {
        this.assertEmpty(TestingUtil.allEntries(this.cl), true);
    }

    protected void assertEventuallyExpires(String key) throws Exception {
        this.eventually(() -> this.cl.loadEntry((Object)key) == null);
    }

    protected boolean storePurgesAllExpired() {
        return true;
    }

    protected void purgeExpired(String ... expiredKeys) throws Exception {
        final HashSet<String> expired = new HashSet<String>(Arrays.asList(expiredKeys));
        final HashSet incorrect = new HashSet();
        if (this.cl instanceof AdvancedCacheExpirationWriter) {
            AdvancedCacheExpirationWriter.ExpirationPurgeListener purgeListener = new AdvancedCacheExpirationWriter.ExpirationPurgeListener(){

                public void marshalledEntryPurged(MarshallableEntry entry) {
                    Object key = entry.getKey();
                    if (!expired.remove(key)) {
                        incorrect.add(key);
                    }
                }

                public void entryPurged(Object key) {
                    if (!expired.remove(key)) {
                        incorrect.add(key);
                    }
                }
            };
            ((AdvancedCacheExpirationWriter)this.cl).purge((Executor)new WithinThreadExecutor(), purgeListener);
        } else {
            this.cl.purge((Executor)new WithinThreadExecutor(), key -> {
                if (!expired.remove(key)) {
                    incorrect.add(key);
                }
            });
        }
        this.assertEmpty(incorrect, true);
        AssertJUnit.assertTrue((expired.isEmpty() || !this.storePurgesAllExpired() ? 1 : 0) != 0);
        AssertJUnit.assertEquals(Collections.emptySet(), incorrect);
    }

    public void testLoadAndStoreWithLifespanAndIdle() throws Exception {
        this.assertIsEmpty();
        long lifespan = 200000L;
        long idle = 120000L;
        InternalCacheEntry<Object, Object> se = this.internalCacheEntry("k", "v", lifespan, idle);
        InternalCacheValue icv = se.toInternalCacheValue();
        AssertJUnit.assertEquals((long)se.getCreated(), (long)icv.getCreated());
        AssertJUnit.assertEquals((long)se.getLastUsed(), (long)icv.getLastUsed());
        this.assertExpired(se, false);
        this.cl.write(this.marshalledEntry(se));
        this.assertContains("k", true);
        this.assertCorrectExpiry(this.cl.loadEntry((Object)"k"), "v", lifespan, idle, false);
        this.assertCorrectExpiry(TestingUtil.allEntries(this.cl).iterator().next(), "v", lifespan, idle, false);
        this.timeService.advance(idle + 1L);
        idle = 1000L;
        lifespan = 4000L;
        se = this.internalCacheEntry("k", "v", lifespan, idle);
        this.assertExpired(se, false);
        this.cl.write(this.marshalledEntry(se));
        this.timeService.advance(idle + 1L);
        this.purgeExpired("k");
        this.assertExpired(se, true);
        this.assertEventuallyExpires("k");
        this.assertContains("k", false);
        this.assertIsEmpty();
    }

    public void testLoadAndStoreWithLifespanAndIdle2() throws Exception {
        this.assertContains("k", false);
        long lifespan = 2000L;
        long idle = 2000L;
        InternalCacheEntry<Object, Object> se = this.internalCacheEntry("k", "v", lifespan, idle);
        InternalCacheValue icv = se.toInternalCacheValue();
        AssertJUnit.assertEquals((long)se.getCreated(), (long)icv.getCreated());
        AssertJUnit.assertEquals((long)se.getLastUsed(), (long)icv.getLastUsed());
        this.assertExpired(se, false);
        this.cl.write(this.marshalledEntry(se));
        this.assertContains("k", true);
        this.assertCorrectExpiry(this.cl.loadEntry((Object)"k"), "v", lifespan, idle, false);
        this.assertCorrectExpiry(TestingUtil.allEntries(this.cl).iterator().next(), "v", lifespan, idle, false);
        idle = 4000L;
        lifespan = 2000L;
        se = this.internalCacheEntry("k", "v", lifespan, idle);
        this.assertExpired(se, false);
        this.cl.write(this.marshalledEntry(se));
        this.timeService.advance(lifespan + 1L);
        this.assertExpired(se, true);
        this.purgeExpired("k");
        this.assertEventuallyExpires("k");
        this.assertContains("k", false);
        this.assertIsEmpty();
    }

    public void testStopStartDoesNotNukeValues() throws InterruptedException, PersistenceException {
        this.assertIsEmpty();
        long lifespan = 1000L;
        long idle = 1000L;
        InternalCacheEntry<Object, Object> se1 = this.internalCacheEntry("k1", "v1", lifespan);
        InternalCacheEntry<Object, Object> se2 = this.internalCacheEntry("k2", "v2", -1L);
        InternalCacheEntry<Object, Object> se3 = this.internalCacheEntry("k3", "v3", -1L, idle);
        InternalCacheEntry<Object, Object> se4 = this.internalCacheEntry("k4", "v4", lifespan, idle);
        this.assertExpired(se1, false);
        this.assertExpired(se2, false);
        this.assertExpired(se3, false);
        this.assertExpired(se4, false);
        this.cl.write(this.marshalledEntry(se1));
        this.cl.write(this.marshalledEntry(se2));
        this.cl.write(this.marshalledEntry(se3));
        this.cl.write(this.marshalledEntry(se4));
        this.timeService.advance(lifespan + 1L);
        this.assertExpired(se1, true);
        this.assertExpired(se2, false);
        this.assertExpired(se3, true);
        this.assertExpired(se4, true);
        this.cl.stop();
        this.cl.start();
        this.assertExpired(se1, true);
        AssertJUnit.assertNull((Object)this.cl.loadEntry((Object)"k1"));
        this.assertContains("k1", false);
        this.assertExpired(se2, false);
        AssertJUnit.assertNotNull((Object)this.cl.loadEntry((Object)"k2"));
        this.assertContains("k2", true);
        AssertJUnit.assertEquals((String)"v2", (String)this.unwrap(this.cl.loadEntry((Object)"k2").getValue()));
        this.assertExpired(se3, true);
        AssertJUnit.assertNull((Object)this.cl.loadEntry((Object)"k3"));
        this.assertContains("k3", false);
        this.assertExpired(se4, true);
        AssertJUnit.assertNull((Object)this.cl.loadEntry((Object)"k4"));
        this.assertContains("k4", false);
    }

    public void testPreload() throws Exception {
        this.assertIsEmpty();
        this.cl.write(this.marshalledEntry("k1", "v1"));
        this.cl.write(this.marshalledEntry("k2", "v2"));
        this.cl.write(this.marshalledEntry("k3", "v3"));
        Set<MarshallableEntry<Object, Object>> set = TestingUtil.allEntries(this.cl);
        this.assertSize(set, 3);
        HashSet<String> expected = new HashSet<String>(Arrays.asList("k1", "k2", "k3"));
        for (MarshallableEntry<Object, Object> se : set) {
            AssertJUnit.assertTrue((boolean)expected.remove(se.getKey()));
        }
        this.assertEmpty(expected, true);
    }

    public void testStoreAndRemove() throws PersistenceException {
        this.assertIsEmpty();
        this.cl.write(this.marshalledEntry("k1", "v1"));
        this.cl.write(this.marshalledEntry("k2", "v2"));
        this.cl.write(this.marshalledEntry("k3", "v3"));
        this.cl.write(this.marshalledEntry("k4", "v4"));
        Set<MarshallableEntry<Object, Object>> set = TestingUtil.allEntries(this.cl);
        this.assertSize(set, 4);
        HashSet<String> expected = new HashSet<String>(Arrays.asList("k1", "k2", "k3", "k4"));
        for (MarshallableEntry<Object, Object> se : set) {
            AssertJUnit.assertTrue((boolean)expected.remove(se.getKey()));
        }
        this.assertEmpty(expected, true);
        this.cl.delete((Object)"k1");
        this.cl.delete((Object)"k2");
        this.cl.delete((Object)"k3");
        set = TestingUtil.allEntries(this.cl);
        this.assertSize(set, 1);
        AssertJUnit.assertEquals((Object)"k4", (Object)set.iterator().next().getKey());
        AssertJUnit.assertEquals((int)1, (int)PersistenceUtil.toKeySet(this.cl, null).size());
        AssertJUnit.assertEquals((int)1, (int)((Long)Flowable.fromPublisher((Publisher)this.cl.publishKeys(null)).count().blockingGet()).intValue());
    }

    public void testPurgeExpired() throws Exception {
        this.assertIsEmpty();
        long lifespan = 7000L;
        long idle = 2000L;
        InternalCacheEntry<Object, Object> ice1 = this.internalCacheEntry("k1", "v1", lifespan);
        this.cl.write(this.marshalledEntry(ice1));
        this.assertContains("k1", true);
        InternalCacheEntry<Object, Object> ice2 = this.internalCacheEntry("k2", "v2", -1L, idle);
        this.cl.write(this.marshalledEntry(ice2));
        this.assertContains("k2", true);
        InternalCacheEntry<Object, Object> ice3 = this.internalCacheEntry("k3", "v3", lifespan, idle);
        this.cl.write(this.marshalledEntry(ice3));
        this.assertContains("k3", true);
        InternalCacheEntry<Object, Object> ice4 = this.internalCacheEntry("k4", "v4", -1L, -1L);
        this.cl.write(this.marshalledEntry(ice4));
        this.assertContains("k4", true);
        InternalCacheEntry<Object, Object> ice5 = this.internalCacheEntry("k5", "v5", lifespan * 1000L, idle * 1000L);
        this.cl.write(this.marshalledEntry(ice5));
        this.assertContains("k5", true);
        this.timeService.advance(lifespan + 1L);
        this.assertContains("k1", false);
        this.assertContains("k2", false);
        this.assertContains("k3", false);
        this.assertContains("k4", true);
        this.assertContains("k5", true);
        this.purgeExpired("k1", "k2", "k3");
        this.assertContains("k1", false);
        this.assertContains("k2", false);
        this.assertContains("k3", false);
        this.assertContains("k4", true);
        this.assertContains("k5", true);
    }

    public void testLoadAll() throws PersistenceException {
        this.assertIsEmpty();
        this.cl.write(this.marshalledEntry("k1", "v1"));
        this.cl.write(this.marshalledEntry("k2", "v2"));
        this.cl.write(this.marshalledEntry("k3", "v3"));
        this.cl.write(this.marshalledEntry("k4", "v4"));
        this.cl.write(this.marshalledEntry("k5", "v5"));
        Set<MarshallableEntry<Object, Object>> s = TestingUtil.allEntries(this.cl);
        this.assertSize(s, 5);
        s = TestingUtil.allEntries(this.cl, k -> true);
        this.assertSize(s, 5);
        s = TestingUtil.allEntries(this.cl, k -> !"k3".equals(k));
        this.assertSize(s, 4);
        for (MarshallableEntry<Object, Object> me : s) {
            AssertJUnit.assertFalse((boolean)me.getKey().equals("k3"));
        }
    }

    public void testReplaceEntry() {
        this.assertIsEmpty();
        InternalCacheEntry<Object, Object> ice = this.internalCacheEntry("k1", "v1", -1L);
        this.cl.write(this.marshalledEntry(ice));
        AssertJUnit.assertEquals((String)"v1", (String)this.unwrap(this.cl.loadEntry((Object)"k1").getValue()));
        InternalCacheEntry<Object, Object> ice2 = this.internalCacheEntry("k1", "v2", -1L);
        this.cl.write(this.marshalledEntry(ice2));
        AssertJUnit.assertEquals((String)"v2", (String)this.unwrap(this.cl.loadEntry((Object)"k1").getValue()));
    }

    public void testReplaceExpiredEntry() throws Exception {
        this.assertIsEmpty();
        long lifespan = 3000L;
        InternalCacheEntry<Object, Object> ice = this.internalCacheEntry("k1", "v1", 3000L);
        this.assertExpired(ice, false);
        this.cl.write(this.marshalledEntry(ice));
        AssertJUnit.assertEquals((String)"v1", (String)this.unwrap(this.cl.loadEntry((Object)"k1").getValue()));
        this.timeService.advance(3001L);
        this.assertExpired(ice, true);
        AssertJUnit.assertNull((Object)this.cl.loadEntry((Object)"k1"));
        InternalCacheEntry<Object, Object> ice2 = this.internalCacheEntry("k1", "v2", 3000L);
        this.assertExpired(ice2, false);
        this.cl.write(this.marshalledEntry(ice2));
        AssertJUnit.assertEquals((String)"v2", (String)this.unwrap(this.cl.loadEntry((Object)"k1").getValue()));
        this.timeService.advance(3001L);
        this.assertExpired(ice2, true);
        AssertJUnit.assertNull((Object)this.cl.loadEntry((Object)"k1"));
    }

    public void testLoadAndStoreBytesValues() throws PersistenceException, IOException, InterruptedException {
        this.assertIsEmpty();
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        TestDataSCI sci = TestDataSCI.INSTANCE;
        sci.registerSchema(ctx);
        sci.registerMarshallers(ctx);
        ProtoStreamMarshaller userMarshaller = new ProtoStreamMarshaller(ctx);
        WrappedByteArray key = new WrappedByteArray(userMarshaller.objectToByteBuffer((Object)new Key("key")));
        WrappedByteArray key2 = new WrappedByteArray(userMarshaller.objectToByteBuffer((Object)new Key("key2")));
        WrappedByteArray value = new WrappedByteArray(userMarshaller.objectToByteBuffer((Object)new Person()));
        AssertJUnit.assertFalse((boolean)this.cl.contains((Object)key));
        PersistenceMarshaller persistenceMarshaller = this.getMarshaller();
        this.cl.write(MarshalledEntryUtil.create(key, value, (Marshaller)persistenceMarshaller));
        AssertJUnit.assertEquals((Object)value, (Object)this.cl.loadEntry((Object)key).getValue());
        MarshallableEntry entry = this.cl.loadEntry((Object)key);
        AssertJUnit.assertTrue((String)"Expected an immortalEntry", (entry.getMetadata() == null || entry.expiryTime() == -1L || entry.getMetadata().maxIdle() == -1L ? 1 : 0) != 0);
        this.assertContains(key, true);
        AssertJUnit.assertFalse((boolean)this.cl.delete((Object)key2));
        AssertJUnit.assertTrue((boolean)this.cl.delete((Object)key));
    }

    public void testWriteAndDeleteBatch() {
        int numberOfEntries = 2 * ThreadLocalRandom.current().nextInt(40, 61);
        this.testBatch(numberOfEntries, () -> this.cl.bulkUpdate((Publisher)Flowable.range((int)0, (int)numberOfEntries).map(i -> this.marshalledEntry(i.toString(), "Val" + i))));
    }

    public void testWriteAndDeleteBatchIterable() {
        int numberOfEntries = 2 * ThreadLocalRandom.current().nextInt(40, 61);
        this.testBatch(numberOfEntries, () -> this.cl.bulkUpdate((Publisher)Flowable.range((int)0, (int)numberOfEntries).map(i -> this.marshalledEntry(i.toString(), "Val" + i))));
    }

    public void testEmptyWriteAndDeleteBatchIterable() {
        this.assertIsEmpty();
        AssertJUnit.assertNull((String)"should not be present in the store", (Object)this.cl.loadEntry((Object)0));
        this.cl.bulkUpdate((Publisher)Flowable.empty());
        AssertJUnit.assertEquals((int)0, (int)this.cl.size());
        this.cl.deleteBatch(Collections.emptyList());
        AssertJUnit.assertEquals((int)0, (int)this.cl.size());
    }

    private <R> void testBatch(int numberOfEntries, Runnable createBatch) {
        this.assertIsEmpty();
        AssertJUnit.assertNull((String)"should not be present in the store", (Object)this.cl.loadEntry((Object)0));
        createBatch.run();
        Set<MarshallableEntry<Object, Object>> set = TestingUtil.allEntries(this.cl);
        this.assertSize(set, numberOfEntries);
        AssertJUnit.assertNotNull((Object)this.cl.loadEntry((Object)"56"));
        int batchSize = numberOfEntries / 2;
        List keys = IntStream.range(0, batchSize).mapToObj(Integer::toString).collect(Collectors.toList());
        this.cl.deleteBatch(keys);
        set = TestingUtil.allEntries(this.cl);
        this.assertSize(set, batchSize);
        AssertJUnit.assertNull((Object)this.cl.loadEntry((Object)"20"));
    }

    public void testIsAvailable() {
        AssertJUnit.assertTrue((boolean)this.cl.isAvailable());
    }

    protected final InitializationContext createContext(Configuration configuration) {
        return PersistenceMockUtil.createContext(this.getClass(), configuration, this.getMarshaller(), (TimeService)this.timeService);
    }

    protected final void assertContains(Object k, boolean expected) {
        AssertJUnit.assertEquals((String)("contains(" + k + ")"), (boolean)expected, (boolean)this.cl.contains(k));
    }

    protected final InternalCacheEntry<Object, Object> internalCacheEntry(String key, String value, long lifespan) {
        return TestInternalCacheEntryFactory.create(this.factory, key, this.wrap(key, value), lifespan);
    }

    private InternalCacheEntry<Object, Object> internalCacheEntry(String key, String value, long lifespan, long idle) {
        return TestInternalCacheEntryFactory.create(this.factory, key, this.wrap(key, value), lifespan, idle);
    }

    private MarshallableEntry<Object, Object> marshalledEntry(String key, String value) {
        return MarshalledEntryUtil.create(key, this.wrap(key, value), (Marshaller)this.getMarshaller());
    }

    protected final MarshallableEntry<Object, Object> marshalledEntry(InternalCacheEntry entry) {
        return MarshalledEntryUtil.create(entry, (Marshaller)this.getMarshaller());
    }

    private void assertSize(Collection<?> collection, int expected) {
        AssertJUnit.assertEquals((String)(collection + ".size()"), (int)expected, (int)collection.size());
    }

    private void assertExpired(InternalCacheEntry entry, boolean expected) {
        AssertJUnit.assertEquals((String)(entry + ".isExpired() "), (boolean)expected, (boolean)entry.isExpired(this.timeService.wallClockTime()));
    }

    private void assertEmpty(Collection<?> collection, boolean expected) {
        AssertJUnit.assertEquals((String)(collection + ".isEmpty()"), (boolean)expected, (boolean)collection.isEmpty());
    }
}

