/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.CacheLoaderFunctionalTest")
public class CacheLoaderFunctionalTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(CacheLoaderFunctionalTest.class);
    private boolean segmented;
    Cache<String, String> cache;
    DummyInMemoryStore store;
    DummyInMemoryStore writer;
    TransactionManager tm;
    ConfigurationBuilder cfg;
    EmbeddedCacheManager cm;
    long lifespan = 60000000L;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.cfg = this.getConfiguration();
        this.configure(this.cfg);
        this.cm = TestCacheManagerFactory.createCacheManager(this.cfg);
        this.cache = this.getCache(this.cm);
        this.store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        this.writer = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        this.tm = TestingUtil.getTransactionManager(this.cache);
    }

    public CacheLoaderFunctionalTest segmented(boolean segmented) {
        this.segmented = segmented;
        return this;
    }

    @Override
    protected String parameters() {
        return "[" + this.segmented + "]";
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new CacheLoaderFunctionalTest().segmented(true), new CacheLoaderFunctionalTest().segmented(false)};
    }

    protected ConfigurationBuilder getConfiguration() {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)cfg.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).segmented(this.segmented)).storeName(this.getClass().getName()).transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        return cfg;
    }

    protected Cache<String, String> getCache(EmbeddedCacheManager cm) {
        return cm.getCache();
    }

    protected Cache<String, String> getCache(EmbeddedCacheManager cm, String name) {
        return cm.getCache(name);
    }

    protected void configure(ConfigurationBuilder cb) {
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws PersistenceException {
        if (this.writer != null) {
            this.writer.clear();
        }
        TestingUtil.killCacheManagers(this.cm);
        this.cache = null;
        this.cm = null;
        this.cfg = null;
        this.tm = null;
        this.store = null;
    }

    private void assertInCacheAndStore(String key, Object value) throws PersistenceException {
        this.assertInCacheAndStore(key, value, -1L);
    }

    private void assertInCacheAndStore(String key, Object value, long lifespanMillis) throws PersistenceException {
        this.assertInCacheAndStore(this.cache, this.store, key, value, lifespanMillis);
    }

    private <K> void assertInCacheAndStore(Cache<? super K, ?> cache, DummyInMemoryStore store, K key, Object value) throws PersistenceException {
        this.assertInCacheAndStore(cache, store, key, value, -1L);
    }

    private <K> void assertInCacheAndStore(Cache<? super K, ?> cache, DummyInMemoryStore loader, K key, Object value, long lifespanMillis) throws PersistenceException {
        InternalCacheEntry se = cache.getAdvancedCache().getDataContainer().get(key);
        this.testStoredEntry(se.getValue(), value, se.getLifespan(), lifespanMillis, "Cache", key);
        MarshallableEntry load = loader.loadEntry(key);
        this.testStoredEntry(load.getValue(), value, load.getMetadata() == null ? -1L : load.getMetadata().lifespan(), lifespanMillis, "Store", key);
    }

    private void testStoredEntry(Object value, Object expectedValue, long lifespan, long expectedLifespan, String src, Object key) {
        AssertJUnit.assertEquals((String)("Wrong value on " + src), (Object)expectedValue, (Object)value);
        AssertJUnit.assertEquals((String)("Wrong lifespan on " + src), (long)expectedLifespan, (long)lifespan);
    }

    private static <K> void assertNotInCacheAndStore(Cache<? super K, ?> cache, DummyInMemoryStore store, K ... keys) throws PersistenceException {
        for (K key : keys) {
            AssertJUnit.assertFalse((String)("Cache should not contain key " + key), (boolean)cache.getAdvancedCache().getDataContainer().containsKey(key));
            AssertJUnit.assertFalse((String)("Store should not contain key " + key), (boolean)store.contains(key));
        }
    }

    private void assertNotInCacheAndStore(String ... keys) throws PersistenceException {
        CacheLoaderFunctionalTest.assertNotInCacheAndStore(this.cache, this.store, keys);
    }

    private void assertInStoreNotInCache(String ... keys) throws PersistenceException {
        CacheLoaderFunctionalTest.assertInStoreNotInCache(this.cache, this.store, keys);
    }

    private static <K> void assertInStoreNotInCache(Cache<? super K, ?> cache, DummyInMemoryStore store, K ... keys) throws PersistenceException {
        for (K key : keys) {
            AssertJUnit.assertFalse((String)("Cache should not contain key " + key), (boolean)cache.getAdvancedCache().getDataContainer().containsKey(key));
            AssertJUnit.assertTrue((String)("Store should contain key " + key), (boolean)store.contains(key));
        }
    }

    private void assertInCacheAndNotInStore(String ... keys) throws PersistenceException {
        CacheLoaderFunctionalTest.assertInCacheAndNotInStore(this.cache, this.store, keys);
    }

    private static <K> void assertInCacheAndNotInStore(Cache<? super K, ?> cache, DummyInMemoryStore store, K ... keys) throws PersistenceException {
        for (K key : keys) {
            assert (cache.getAdvancedCache().getDataContainer().containsKey(key)) : "Cache should not contain key " + key;
            AssertJUnit.assertFalse((String)("Store should contain key " + key), (boolean)store.contains(key));
        }
    }

    public void testStoreAndRetrieve() throws PersistenceException {
        int i;
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4", "k5", "k6", "k7");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.cache.putAll(Collections.singletonMap("k3", "v3"));
        this.cache.putAll(Collections.singletonMap("k4", "v4"), this.lifespan, TimeUnit.MILLISECONDS);
        this.cache.putIfAbsent((Object)"k5", (Object)"v5");
        this.cache.putIfAbsent((Object)"k6", (Object)"v6", this.lifespan, TimeUnit.MILLISECONDS);
        this.cache.putIfAbsent((Object)"k5", (Object)"v5-SHOULD-NOT-PUT");
        this.cache.putIfAbsent((Object)"k6", (Object)"v6-SHOULD-NOT-PUT", this.lifespan, TimeUnit.MILLISECONDS);
        this.cache.putForExternalRead((Object)"k7", (Object)"v7");
        this.cache.putForExternalRead((Object)"k7", (Object)"v7-SHOULD-NOT-PUT");
        for (i = 1; i < 8; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore("k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore("k" + i, "v" + i, this.lifespan);
        }
        assert (!this.cache.remove((Object)"k1", (Object)"some rubbish"));
        for (i = 1; i < 8; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore("k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore("k" + i, "v" + i, this.lifespan);
        }
        log.debugf("cache.get(\"k1\") = %s", this.cache.get((Object)"k1"));
        boolean removed = this.cache.remove((Object)"k1", (Object)"v1");
        AssertJUnit.assertTrue((boolean)removed);
        log.debugf("cache.get(\"k1\") = %s", this.cache.get((Object)"k1"));
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.cache.remove((Object)"k2")));
        this.assertNotInCacheAndStore("k1", "k2");
        for (int i2 = 3; i2 < 8; ++i2) {
            if (i2 % 2 == 1) {
                this.assertInCacheAndStore("k" + i2, "v" + i2);
                continue;
            }
            this.assertInCacheAndStore("k" + i2, "v" + i2, this.lifespan);
        }
        this.cache.clear();
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4", "k5", "k6", "k7");
    }

    public void testReplaceMethods() throws PersistenceException {
        int i;
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4");
        this.cache.replace((Object)"k1", (Object)"v1-SHOULD-NOT-STORE");
        LockAssert.assertNoLocks(this.cache);
        this.cache.replace((Object)"k2", (Object)"v2-SHOULD-NOT-STORE", this.lifespan, TimeUnit.MILLISECONDS);
        LockAssert.assertNoLocks(this.cache);
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4");
        this.cache.put((Object)"k1", (Object)"v1");
        LockAssert.assertNoLocks(this.cache);
        this.cache.put((Object)"k2", (Object)"v2");
        LockAssert.assertNoLocks(this.cache);
        this.cache.put((Object)"k3", (Object)"v3");
        LockAssert.assertNoLocks(this.cache);
        this.cache.put((Object)"k4", (Object)"v4");
        LockAssert.assertNoLocks(this.cache);
        for (i = 1; i < 5; ++i) {
            this.assertInCacheAndStore("k" + i, "v" + i);
        }
        this.cache.replace((Object)"k1", (Object)"v1-SHOULD-NOT-STORE", (Object)"v1-STILL-SHOULD-NOT-STORE");
        LockAssert.assertNoLocks(this.cache);
        this.cache.replace((Object)"k2", (Object)"v2-SHOULD-NOT-STORE", (Object)"v2-STILL-SHOULD-NOT-STORE", this.lifespan, TimeUnit.MILLISECONDS);
        LockAssert.assertNoLocks(this.cache);
        for (i = 1; i < 5; ++i) {
            this.assertInCacheAndStore("k" + i, "v" + i);
        }
        this.cache.replace((Object)"k1", (Object)"v1-REPLACED");
        LockAssert.assertNoLocks(this.cache);
        this.cache.replace((Object)"k2", (Object)"v2-REPLACED", this.lifespan, TimeUnit.MILLISECONDS);
        this.assertInCacheAndStore("k2", "v2-REPLACED", this.lifespan);
        LockAssert.assertNoLocks(this.cache);
        this.cache.replace((Object)"k3", (Object)"v3", (Object)"v3-REPLACED");
        LockAssert.assertNoLocks(this.cache);
        this.cache.replace((Object)"k4", (Object)"v4", (Object)"v4-REPLACED", this.lifespan, TimeUnit.MILLISECONDS);
        LockAssert.assertNoLocks(this.cache);
        for (i = 1; i < 5; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore("k" + i, "v" + i + "-REPLACED");
                continue;
            }
            this.assertInCacheAndStore("k" + i, "v" + i + "-REPLACED", this.lifespan);
        }
        LockAssert.assertNoLocks(this.cache);
    }

    public void testLoading() throws PersistenceException {
        int i;
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4");
        if (Configurations.isTxVersioned((Configuration)this.cache.getCacheConfiguration())) {
            for (i = 1; i < 5; ++i) {
                this.writer.write(MarshalledEntryUtil.createWithVersion("k" + i, "v" + i, this.cache));
            }
        } else {
            for (i = 1; i < 5; ++i) {
                this.writer.write(MarshalledEntryUtil.create("k" + i, "v" + i, this.cache));
            }
        }
        for (i = 1; i < 5; ++i) {
            AssertJUnit.assertEquals((String)("v" + i), (String)((String)this.cache.get((Object)("k" + i))));
        }
        LockAssert.assertNoLocks(this.cache);
        for (i = 1; i < 5; ++i) {
            this.cache.evict((Object)("k" + i));
        }
        LockAssert.assertNoLocks(this.cache);
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.cache.putIfAbsent((Object)"k1", (Object)"v1-SHOULD-NOT-STORE")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.cache.remove((Object)"k2")));
        AssertJUnit.assertEquals((String)"v3", (String)((String)this.cache.replace((Object)"k3", (Object)"v3-REPLACED")));
        AssertJUnit.assertTrue((boolean)this.cache.replace((Object)"k4", (Object)"v4", (Object)"v4-REPLACED"));
        LockAssert.assertNoLocks(this.cache);
        int size = this.cache.size();
        AssertJUnit.assertEquals((String)("Expected the cache to contain 3 elements but contained " + this.cache.entrySet()), (int)3, (int)size);
        for (int i2 = 1; i2 < 5; ++i2) {
            this.cache.evict((Object)("k" + i2));
        }
        LockAssert.assertNoLocks(this.cache);
        AssertJUnit.assertEquals((int)0, (int)this.cache.getAdvancedCache().getDataContainer().size());
        this.cache.clear();
        this.assertNotInCacheAndStore("k1", "k2", "k3", "k4");
        LockAssert.assertNoLocks(this.cache);
    }

    public void testPreloading() throws Exception {
        ConfigurationBuilder preloadingCfg = this.newPreloadConfiguration(this.cfg.build(), this.getClass().getName() + "preloadingCache");
        this.doPreloadingTest(preloadingCfg.build(), "preloadingCache");
    }

    public void testPreloadingWithoutAutoCommit() throws Exception {
        ConfigurationBuilder preloadingCfg = this.newPreloadConfiguration(this.cfg.build(), this.getClass().getName() + "preloadingCache_2");
        preloadingCfg.transaction().autoCommit(false);
        this.doPreloadingTest(preloadingCfg.build(), "preloadingCache_2");
    }

    public void testPreloadingWithEvictionAndOneMaxEntry() throws Exception {
        ConfigurationBuilder preloadingCfg = this.newPreloadConfiguration(this.cfg.build(), this.getClass().getName() + "preloadingCache_3");
        preloadingCfg.memory().size(1L);
        this.doPreloadingTestWithEviction(preloadingCfg.build(), "preloadingCache_3");
    }

    public void testPreloadingWithEviction() throws Exception {
        ConfigurationBuilder preloadingCfg = this.newPreloadConfiguration(this.cfg.build(), this.getClass().getName() + "preloadingCache_4");
        preloadingCfg.memory().size(3L);
        this.doPreloadingTestWithEviction(preloadingCfg.build(), "preloadingCache_4");
    }

    ConfigurationBuilder newPreloadConfiguration(Configuration configuration, String storeName) {
        ConfigurationBuilder preloadingCfg = new ConfigurationBuilder();
        preloadingCfg.read(configuration);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)preloadingCfg.persistence().clearStores().addStore(DummyInMemoryStoreConfigurationBuilder.class)).segmented(this.segmented)).preload(true)).storeName(storeName);
        return preloadingCfg;
    }

    @Test(groups={"unstable"})
    public void testPurgeOnStartup() throws PersistenceException {
        ConfigurationBuilder purgingCfg = new ConfigurationBuilder();
        purgingCfg.read(this.cfg.build());
        ((DummyInMemoryStoreConfigurationBuilder)purgingCfg.persistence().clearStores().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName("purgingCache").purgeOnStartup(true);
        this.cm.defineConfiguration("purgingCache", purgingCfg.build());
        Cache<String, String> purgingCache = this.getCache(this.cm, "purgingCache");
        DummyInMemoryStore purgingLoader = (DummyInMemoryStore)TestingUtil.getFirstStore(purgingCache);
        CacheLoaderFunctionalTest.assertNotInCacheAndStore(purgingCache, purgingLoader, "k1", "k2", "k3", "k4");
        purgingCache.put((Object)"k1", (Object)"v1");
        purgingCache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        purgingCache.put((Object)"k3", (Object)"v3");
        purgingCache.put((Object)"k4", (Object)"v4", this.lifespan, TimeUnit.MILLISECONDS);
        for (int i = 1; i < 5; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore(purgingCache, purgingLoader, "k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore(purgingCache, purgingLoader, "k" + i, "v" + i, this.lifespan);
        }
        DataContainer c = purgingCache.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((int)4, (int)c.size());
        purgingCache.stop();
        AssertJUnit.assertEquals((int)0, (int)c.size());
        purgingCache.start();
        purgingLoader = (DummyInMemoryStore)TestingUtil.getFirstStore(purgingCache);
        c = purgingCache.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((int)0, (int)c.size());
        CacheLoaderFunctionalTest.assertNotInCacheAndStore(purgingCache, purgingLoader, "k1", "k2", "k3", "k4");
    }

    public void testTransactionalWrites() throws Exception {
        AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING, (Object)this.cache.getStatus());
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        Transaction t = this.tm.suspend();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.resume(t);
        this.tm.commit();
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2", this.lifespan);
        this.tm.begin();
        this.cache.remove((Object)"k1");
        this.cache.remove((Object)"k2");
        t = this.tm.suspend();
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2", this.lifespan);
        this.tm.resume(t);
        this.tm.commit();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        t = this.tm.suspend();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.resume(t);
        this.tm.rollback();
        this.assertNotInCacheAndStore("k1", "k2");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2", this.lifespan);
        this.tm.begin();
        this.cache.remove((Object)"k1");
        this.cache.remove((Object)"k2");
        t = this.tm.suspend();
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2", this.lifespan);
        this.tm.resume(t);
        this.tm.rollback();
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2", this.lifespan);
    }

    public void testTransactionalReplace(Method m) throws Exception {
        AssertJUnit.assertEquals((Object)ComponentStatus.RUNNING, (Object)this.cache.getStatus());
        this.assertNotInCacheAndStore(TestingUtil.k(m, 1));
        this.assertNotInCacheAndStore(TestingUtil.k(m, 2));
        this.cache.put((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m));
        this.tm.begin();
        this.cache.put((Object)TestingUtil.k(m, 1), (Object)TestingUtil.v(m, 1));
        this.cache.replace((Object)TestingUtil.k(m, 2), (Object)TestingUtil.v(m, 1));
        Transaction t = this.tm.suspend();
        this.assertNotInCacheAndStore(TestingUtil.k(m, 1));
        this.assertInCacheAndStore(TestingUtil.k(m, 2), TestingUtil.v(m));
        this.tm.resume(t);
        this.tm.commit();
        this.assertInCacheAndStore(TestingUtil.k(m, 1), TestingUtil.v(m, 1));
        this.assertInCacheAndStore(TestingUtil.k(m, 2), TestingUtil.v(m, 1));
    }

    public void testEvictAndRemove() throws PersistenceException {
        this.assertNotInCacheAndStore("k1", "k2");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.cache.evict((Object)"k1");
        this.cache.evict((Object)"k2");
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.cache.remove((Object)"k1")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.cache.remove((Object)"k2")));
    }

    public void testLoadingToMemory() throws PersistenceException {
        this.assertNotInCacheAndStore("k1", "k2");
        this.store.write(MarshalledEntryUtil.create("k1", "v1", this.cache));
        this.store.write(MarshalledEntryUtil.create("k2", "v2", this.cache));
        this.assertInStoreNotInCache("k1", "k2");
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.cache.get((Object)"k1")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.cache.get((Object)"k2")));
        this.assertInCacheAndStore("k1", "v1");
        this.assertInCacheAndStore("k2", "v2");
        this.store.delete("k1");
        this.store.delete("k2");
        this.assertInCacheAndNotInStore("k1", "k2");
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.cache.get((Object)"k1")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.cache.get((Object)"k2")));
    }

    public void testSkipLocking(Method m) {
        String name = m.getName();
        AdvancedCache advancedCache = this.cache.getAdvancedCache();
        advancedCache.put((Object)("k-" + name), (Object)("v-" + name));
        advancedCache.withFlags(Flag.SKIP_LOCKING).put((Object)("k-" + name), (Object)("v2-" + name));
    }

    public void testDuplicatePersistence(Method m) throws Exception {
        String key = "k-" + m.getName();
        String value = "v-" + m.getName();
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.get((Object)key)));
        this.cache.stop();
        this.cache.start();
        this.writer = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        this.tm.begin();
        this.cache.containsKey((Object)key);
        this.cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).get((Object)key);
        this.cache.put((Object)key, (Object)value);
        this.tm.commit();
        AssertJUnit.assertEquals((String)value, (String)((String)this.cache.get((Object)key)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testNullFoundButLoaderReceivedValueLaterInTransaction() throws SystemException, NotSupportedException {
        this.assertNotInCacheAndStore("k1");
        this.tm.begin();
        try {
            Assert.assertNull((Object)this.cache.get((Object)"k1"));
            this.store.write(MarshalledEntryUtil.create("k1", "v1", this.cache));
            IsolationLevel level = this.cache.getCacheConfiguration().locking().isolationLevel();
            switch (level) {
                case READ_COMMITTED: {
                    AssertJUnit.assertEquals((String)"v1", (String)((String)this.cache.get((Object)"k1")));
                    return;
                }
                case REPEATABLE_READ: {
                    Assert.assertNull((Object)this.cache.get((Object)"k1"));
                    return;
                }
                default: {
                    Assert.fail((String)("Unsupported isolation " + level + " - please change test to add desired outcome for isolation level"));
                    return;
                }
            }
        }
        finally {
            this.tm.rollback();
        }
    }

    public void testValuesForCacheLoader() {
        this.cache.putIfAbsent((Object)"k1", (Object)"v1");
        List<String> copy1 = this.copyValues(this.cache);
        AssertJUnit.assertEquals((int)1, (int)copy1.size());
        AssertJUnit.assertEquals((String)"v1", (String)copy1.get(0));
        this.cache.putIfAbsent((Object)"k2", (Object)"v2");
        List<String> copy2 = this.copyValues(this.cache);
        AssertJUnit.assertEquals((int)2, (int)copy2.size());
        AssertJUnit.assertEquals(Arrays.asList("v1", "v2"), copy2);
    }

    private List<String> copyValues(Cache<?, String> cache) {
        return new ArrayList<String>((Collection<String>)cache.values());
    }

    protected void doPreloadingTest(Configuration preloadingCfg, String cacheName) throws Exception {
        AssertJUnit.assertTrue((String)"Preload not enabled for preload test", (boolean)preloadingCfg.persistence().preload());
        this.cm.defineConfiguration(cacheName, preloadingCfg);
        Cache<String, String> preloadingCache = this.getCache(this.cm, cacheName);
        DummyInMemoryStore preloadingCacheLoader = (DummyInMemoryStore)TestingUtil.getFirstStore(preloadingCache);
        assert (preloadingCache.getCacheConfiguration().persistence().preload().booleanValue());
        CacheLoaderFunctionalTest.assertNotInCacheAndStore(preloadingCache, preloadingCacheLoader, "k1", "k2", "k3", "k4");
        preloadingCache.getAdvancedCache().getTransactionManager().begin();
        preloadingCache.put((Object)"k1", (Object)"v1");
        preloadingCache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        preloadingCache.put((Object)"k3", (Object)"v3");
        preloadingCache.put((Object)"k4", (Object)"v4", this.lifespan, TimeUnit.MILLISECONDS);
        preloadingCache.getAdvancedCache().getTransactionManager().commit();
        for (int i = 1; i < 5; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore(preloadingCache, preloadingCacheLoader, "k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore(preloadingCache, preloadingCacheLoader, "k" + i, "v" + i, this.lifespan);
        }
        DataContainer c = preloadingCache.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((int)4, (int)c.size());
        preloadingCache.stop();
        AssertJUnit.assertEquals((int)0, (int)c.size());
        preloadingCache.start();
        preloadingCacheLoader = (DummyInMemoryStore)TestingUtil.getFirstStore(preloadingCache);
        assert (preloadingCache.getCacheConfiguration().persistence().preload().booleanValue());
        c = preloadingCache.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((int)4, (int)c.size());
        for (int i = 1; i < 5; ++i) {
            if (i % 2 == 1) {
                this.assertInCacheAndStore(preloadingCache, preloadingCacheLoader, "k" + i, "v" + i);
                continue;
            }
            this.assertInCacheAndStore(preloadingCache, preloadingCacheLoader, "k" + i, "v" + i, this.lifespan);
        }
    }

    protected void doPreloadingTestWithEviction(Configuration preloadingCfg, String cacheName) throws Exception {
        MarshallableEntry load;
        InternalCacheEntry se;
        boolean found;
        long lifespan;
        String value;
        String key;
        int i;
        AssertJUnit.assertTrue((String)"Preload not enabled for preload with eviction test", (boolean)preloadingCfg.persistence().preload());
        AssertJUnit.assertTrue((String)"Eviction not enabled for preload with eviction test", (boolean)preloadingCfg.memory().isEvictionEnabled());
        this.cm.defineConfiguration(cacheName, preloadingCfg);
        Cache<String, String> preloadingCache = this.getCache(this.cm, cacheName);
        long expectedEntriesInContainer = Math.min(4L, preloadingCfg.memory().size());
        DummyInMemoryStore preloadingCacheLoader = (DummyInMemoryStore)TestingUtil.getFirstStore(preloadingCache);
        AssertJUnit.assertTrue((String)"Preload not enabled in cache configuration", (boolean)preloadingCache.getCacheConfiguration().persistence().preload());
        CacheLoaderFunctionalTest.assertNotInCacheAndStore(preloadingCache, preloadingCacheLoader, "k1", "k2", "k3", "k4");
        preloadingCache.getAdvancedCache().getTransactionManager().begin();
        preloadingCache.put((Object)"k1", (Object)"v1");
        preloadingCache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        preloadingCache.put((Object)"k3", (Object)"v3");
        preloadingCache.put((Object)"k4", (Object)"v4", this.lifespan, TimeUnit.MILLISECONDS);
        preloadingCache.getAdvancedCache().getTransactionManager().commit();
        DataContainer c = preloadingCache.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((String)"Wrong number of entries in data container", (long)expectedEntriesInContainer, (long)c.size());
        for (i = 1; i < 5; ++i) {
            key = "k" + i;
            value = "v" + i;
            lifespan = i % 2 == 1 ? -1L : this.lifespan;
            found = false;
            se = preloadingCache.getAdvancedCache().getDataContainer().get((Object)key);
            load = preloadingCacheLoader.loadEntry(key);
            if (se != null) {
                this.testStoredEntry(se.getValue(), value, se.getLifespan(), lifespan, "Cache", key);
                found = true;
            }
            if (load != null) {
                this.testStoredEntry(load.getValue(), value, load.getMetadata().lifespan(), lifespan, "Store", key);
                found = true;
            }
            AssertJUnit.assertTrue((String)"Key not found.", (boolean)found);
        }
        preloadingCache.stop();
        AssertJUnit.assertEquals((String)"DataContainer still has entries after stop", (int)0, (int)c.size());
        preloadingCache.start();
        preloadingCacheLoader = (DummyInMemoryStore)TestingUtil.getFirstStore(preloadingCache);
        AssertJUnit.assertTrue((String)"Preload not enabled in cache configuration", (boolean)preloadingCache.getCacheConfiguration().persistence().preload());
        c = preloadingCache.getAdvancedCache().getDataContainer();
        AssertJUnit.assertEquals((String)"Wrong number of entries in data container", (long)expectedEntriesInContainer, (long)c.size());
        for (i = 1; i < 5; ++i) {
            key = "k" + i;
            value = "v" + i;
            lifespan = i % 2 == 1 ? -1L : this.lifespan;
            found = false;
            se = preloadingCache.getAdvancedCache().getDataContainer().get((Object)key);
            load = preloadingCacheLoader.loadEntry(key);
            if (se != null) {
                this.testStoredEntry(se.getValue(), value, se.getLifespan(), lifespan, "Cache", key);
                found = true;
            }
            if (load != null) {
                this.testStoredEntry(load.getValue(), value, load.getMetadata().lifespan(), lifespan, "Store", key);
                found = true;
            }
            AssertJUnit.assertTrue((String)"Key not found.", (boolean)found);
        }
    }
}

