/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.ClusterCacheLoaderTest")
@InCacheMode(value={CacheMode.INVALIDATION_SYNC, CacheMode.DIST_SYNC, CacheMode.REPL_SYNC, CacheMode.SCATTERED_SYNC})
public class ClusterCacheLoaderTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        EmbeddedCacheManager cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager();
        EmbeddedCacheManager cacheManager2 = TestCacheManagerFactory.createClusteredCacheManager();
        this.registerCacheManager(new CacheContainer[]{cacheManager1, cacheManager2});
        ConfigurationBuilder config1 = ClusterCacheLoaderTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        config1.persistence().addClusterLoader().segmented(false);
        ConfigurationBuilder config2 = ClusterCacheLoaderTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        config2.persistence().addClusterLoader().segmented(false);
        config2.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        cacheManager1.defineConfiguration("clusteredCl", config1.build());
        cacheManager2.defineConfiguration("clusteredCl", config2.build());
        this.waitForClusterToForm("clusteredCl");
    }

    public void testRemoteLoad() {
        Cache cache1 = this.cache(0, "clusteredCl");
        Cache cache2 = this.cache(1, "clusteredCl");
        Assert.assertNull((Object)cache1.get((Object)"key"));
        Assert.assertNull((Object)cache1.get((Object)"key"));
        cache2.put((Object)"key", (Object)"value");
        Assert.assertEquals((String)((String)cache1.get((Object)"key")), (String)"value");
    }

    public void testRemoteLoadFromCacheLoader() throws Exception {
        Cache cache1 = this.cache(0, "clusteredCl");
        Cache cache2 = this.cache(1, "clusteredCl");
        DummyInMemoryStore writer = (DummyInMemoryStore)TestingUtil.getStore(cache2, 1, false);
        Assert.assertNull((Object)cache1.get((Object)"key"));
        Assert.assertNull((Object)cache2.get((Object)"key"));
        writer.write(MarshalledEntryUtil.create("key", "value", cache2));
        Assert.assertEquals((Object)writer.loadEntry("key").getValue(), (Object)"value");
        Assert.assertEquals((String)((String)cache1.get((Object)"key")), (String)"value");
    }
}

