/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.Ownership;
import org.infinispan.eviction.impl.ActivationManager;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.SkipException;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.ClusteredConditionalCommandTest")
@InCacheMode(value={CacheMode.DIST_SYNC, CacheMode.SCATTERED_SYNC})
public class ClusteredConditionalCommandTest
extends MultipleCacheManagersTest {
    private static final String PRIVATE_STORE_CACHE_NAME = "private-store-cache";
    private static final String SHARED_STORE_CACHE_NAME = "shared-store-cache";
    private final String key = this.getClass().getSimpleName() + "-key";
    private final String value1 = this.getClass().getSimpleName() + "-value1";
    private final String value2 = this.getClass().getSimpleName() + "-value2";
    private final boolean passivation;

    public ClusteredConditionalCommandTest() {
        this(false, false);
    }

    protected ClusteredConditionalCommandTest(boolean transactional, boolean passivation) {
        this.transactional = transactional;
        this.passivation = passivation;
        this.cacheMode = CacheMode.DIST_SYNC;
    }

    private ConfigurationBuilder createConfiguration(String storeName, boolean shared, boolean transactional, boolean passivation, int storePrefix) {
        ConfigurationBuilder builder = ClusteredConditionalCommandTest.getDefaultClusteredCacheConfig(this.cacheMode, transactional);
        builder.statistics().enable();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(passivation).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(storeName + (shared ? "-shared" : Integer.valueOf(storePrefix))).fetchPersistentState(false)).shared(shared);
        builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        return builder;
    }

    @AfterMethod
    public void afterMethod() {
        if (this.passivation) {
            for (EmbeddedCacheManager cacheManager : this.cacheManagers) {
                ActivationManager activationManager = TestingUtil.extractComponent(cacheManager.getCache(PRIVATE_STORE_CACHE_NAME), ActivationManager.class);
                this.eventuallyEquals(0L, () -> ((ActivationManager)activationManager).getPendingActivationCount());
            }
        }
    }

    private static <K, V> void writeToStore(CacheHelper<K, V> cacheHelper, Ownership ownership, K key, V value) {
        MarshallableEntry<K, V> entry = MarshalledEntryUtil.create(key, value, ((CacheHelper)cacheHelper).cache(ownership));
        ((CacheHelper)cacheHelper).cacheStore(ownership).write(entry);
    }

    private <K, V> CacheHelper<K, V> create(List<Cache<K, V>> cacheList) {
        CacheHelper<K, V> cacheHelper = new CacheHelper<K, V>();
        for (Cache<K, V> cache : cacheList) {
            ClusteringDependentLogic clusteringDependentLogic = TestingUtil.extractComponent(cache, ClusteringDependentLogic.class);
            DistributionInfo distributionInfo = clusteringDependentLogic.getCacheTopology().getDistribution((Object)this.key);
            log.debugf("owners for key %s are %s", (Object)this.key, (Object)distributionInfo.writeOwners());
            if (distributionInfo.isPrimary()) {
                log.debug((Object)("Cache " + this.address(cache) + " is the primary owner"));
                AssertJUnit.assertTrue((boolean)cacheHelper.addCache(Ownership.PRIMARY, cache));
                continue;
            }
            if (distributionInfo.isWriteBackup()) {
                log.debug((Object)("Cache " + this.address(cache) + " is the backup owner"));
                AssertJUnit.assertTrue((boolean)cacheHelper.addCache(Ownership.BACKUP, cache));
                continue;
            }
            log.debug((Object)("Cache " + this.address(cache) + " is the non owner"));
            AssertJUnit.assertTrue((cacheHelper.addCache(Ownership.NON_OWNER, cache) || this.cacheMode.isScattered() ? 1 : 0) != 0);
        }
        return cacheHelper;
    }

    private void doTest(String cacheName, ConditionalOperation operation, Ownership ownership, Flag flag, boolean shared) {
        if (shared && this.passivation) {
            return;
        }
        List cacheList = this.getCaches(cacheName);
        if (shared && this.passivation) {
            throw new SkipException("Shared passivation is not supported");
        }
        TestingUtil.waitForNoRebalance(cacheList);
        CacheHelper<String, String> cacheHelper = this.create(cacheList);
        boolean skipLoad = flag == Flag.SKIP_CACHE_LOAD || flag == Flag.SKIP_CACHE_STORE;
        this.assertEmpty(cacheList);
        this.initStore(cacheHelper, shared);
        try {
            if (flag != null) {
                operation.execute(((CacheHelper)cacheHelper).cache(ownership).getAdvancedCache().withFlags(flag), this.key, this.value1, this.value2);
            } else {
                operation.execute(((CacheHelper)cacheHelper).cache(ownership), this.key, this.value1, this.value2);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        this.assertLoadAfterOperation(cacheHelper, operation, ownership, skipLoad);
        Cache primary = ((CacheHelper)cacheHelper).cache(Ownership.PRIMARY);
        Cache backup = ((CacheHelper)cacheHelper).cache(Ownership.BACKUP);
        AssertJUnit.assertEquals((String)operation.finalValue(this.value1, this.value2, skipLoad), (String)((String)primary.get((Object)this.key)));
        if (backup != null) {
            AssertJUnit.assertEquals((String)operation.finalValue(this.value1, this.value2, skipLoad), (String)((String)backup.get((Object)this.key)));
        }
    }

    protected <K, V> void assertLoadAfterOperation(CacheHelper<K, V> cacheHelper, ConditionalOperation operation, Ownership ownership, boolean skipLoad) {
        this.assertLoad(cacheHelper, skipLoad ? 0 : 1, 0, 0);
    }

    protected final <K, V> void assertLoad(CacheHelper<K, V> cacheHelper, int primaryOwner, int backupOwner, int nonOwner) {
        AssertJUnit.assertEquals((String)"primary owner load", (long)primaryOwner, (long)cacheHelper.loads(Ownership.PRIMARY));
        AssertJUnit.assertEquals((String)"backup owner load", (long)backupOwner, (long)cacheHelper.loads(Ownership.BACKUP));
        AssertJUnit.assertEquals((String)"non owner load", (long)nonOwner, (long)cacheHelper.loads(Ownership.NON_OWNER));
    }

    private <K, V> void assertEmpty(List<Cache<K, V>> cacheList) {
        for (Cache<K, V> cache : cacheList) {
            AssertJUnit.assertTrue((String)(cache + ".isEmpty()"), (boolean)cache.isEmpty());
        }
    }

    private void initStore(CacheHelper<String, String> cacheHelper, boolean shared) {
        DummyInMemoryStore primaryStore = ((CacheHelper)cacheHelper).cacheStore(Ownership.PRIMARY);
        DummyInMemoryStore backupStore = ((CacheHelper)cacheHelper).cacheStore(Ownership.BACKUP);
        DummyInMemoryStore nonOwnerStore = ((CacheHelper)cacheHelper).cacheStore(Ownership.NON_OWNER);
        if (shared) {
            ClusteredConditionalCommandTest.writeToStore(cacheHelper, Ownership.PRIMARY, this.key, this.value1);
            AssertJUnit.assertTrue((boolean)primaryStore.contains(this.key));
            if (backupStore != null) {
                AssertJUnit.assertTrue((boolean)backupStore.contains(this.key));
            }
            AssertJUnit.assertTrue((boolean)nonOwnerStore.contains(this.key));
        } else {
            ClusteredConditionalCommandTest.writeToStore(cacheHelper, Ownership.PRIMARY, this.key, this.value1);
            AssertJUnit.assertTrue((boolean)primaryStore.contains(this.key));
            if (backupStore != null) {
                ClusteredConditionalCommandTest.writeToStore(cacheHelper, Ownership.BACKUP, this.key, this.value1);
                AssertJUnit.assertTrue((boolean)backupStore.contains(this.key));
            }
            AssertJUnit.assertFalse((boolean)nonOwnerStore.contains(this.key));
        }
        ((CacheHelper)cacheHelper).resetStats(Ownership.PRIMARY);
        ((CacheHelper)cacheHelper).resetStats(Ownership.BACKUP);
        ((CacheHelper)cacheHelper).resetStats(Ownership.NON_OWNER);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(3);
        int index = 0;
        for (EmbeddedCacheManager cacheManager : this.cacheManagers) {
            if (!this.passivation) {
                cacheManager.defineConfiguration(SHARED_STORE_CACHE_NAME, this.createConfiguration(this.getClass().getSimpleName(), true, this.transactional, false, index).build());
            }
            cacheManager.defineConfiguration(PRIVATE_STORE_CACHE_NAME, this.createConfiguration(this.getClass().getSimpleName(), false, this.transactional, this.passivation, index).build());
            ++index;
        }
    }

    public void testPutIfAbsentOnPrimaryOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.PRIMARY, Flag.SKIP_CACHE_LOAD, true);
    }

    public void testPutIfAbsentOnPrimaryOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.PRIMARY, Flag.SKIP_CACHE_LOAD, false);
    }

    public void testPutIfAbsentOnPrimaryOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.PRIMARY, Flag.IGNORE_RETURN_VALUES, true);
    }

    public void testPutIfAbsentOnPrimaryOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.PRIMARY, Flag.IGNORE_RETURN_VALUES, false);
    }

    public void testPutIfAbsentOnPrimaryOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.PRIMARY, null, true);
    }

    public void testPutIfAbsentOnPrimaryOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.PRIMARY, null, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testPutIfAbsentOnBackupOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.BACKUP, Flag.SKIP_CACHE_LOAD, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testPutIfAbsentOnBackupOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.BACKUP, Flag.SKIP_CACHE_LOAD, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testPutIfAbsentOnBackupOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.BACKUP, Flag.IGNORE_RETURN_VALUES, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testPutIfAbsentOnBackupOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.BACKUP, Flag.IGNORE_RETURN_VALUES, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testPutIfAbsentOnBackupOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.BACKUP, null, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testPutIfAbsentOnBackupOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.BACKUP, null, false);
    }

    public void testPutIfAbsentOnNonOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.NON_OWNER, Flag.SKIP_CACHE_LOAD, true);
    }

    public void testPutIfAbsentOnNonOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.NON_OWNER, Flag.SKIP_CACHE_LOAD, false);
    }

    public void testPutIfAbsentOnNonOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.NON_OWNER, Flag.IGNORE_RETURN_VALUES, true);
    }

    public void testPutIfAbsentOnNonOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.NON_OWNER, Flag.IGNORE_RETURN_VALUES, false);
    }

    public void testPutIfAbsentOnNonOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.NON_OWNER, null, true);
    }

    public void testPutIfAbsentOnNonOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.PUT_IF_ABSENT, Ownership.NON_OWNER, null, false);
    }

    public void testReplaceOnPrimaryOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.PRIMARY, Flag.SKIP_CACHE_LOAD, true);
    }

    public void testReplaceOnPrimaryOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.PRIMARY, Flag.SKIP_CACHE_LOAD, false);
    }

    public void testReplaceOnPrimaryOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.PRIMARY, Flag.IGNORE_RETURN_VALUES, true);
    }

    public void testReplaceOnPrimaryOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.PRIMARY, Flag.IGNORE_RETURN_VALUES, false);
    }

    public void testReplaceOnPrimaryOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.PRIMARY, null, true);
    }

    public void testReplaceOnPrimaryOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.PRIMARY, null, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceOnBackupOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.BACKUP, Flag.SKIP_CACHE_LOAD, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceOnBackupOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.BACKUP, Flag.SKIP_CACHE_LOAD, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceOnBackupOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.BACKUP, Flag.IGNORE_RETURN_VALUES, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceOnBackupOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.BACKUP, Flag.IGNORE_RETURN_VALUES, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceOnBackupOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.BACKUP, null, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceOnBackupOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.BACKUP, null, false);
    }

    public void testReplaceOnNonOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.NON_OWNER, Flag.SKIP_CACHE_LOAD, true);
    }

    public void testReplaceOnNonOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.NON_OWNER, Flag.SKIP_CACHE_LOAD, false);
    }

    public void testReplaceOnNonOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.NON_OWNER, Flag.IGNORE_RETURN_VALUES, true);
    }

    public void testReplaceOnNonOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.NON_OWNER, Flag.IGNORE_RETURN_VALUES, false);
    }

    public void testReplaceOnNonOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.NON_OWNER, null, true);
    }

    public void testReplaceOnNonOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE, Ownership.NON_OWNER, null, false);
    }

    public void testReplaceIfOnPrimaryOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.PRIMARY, Flag.SKIP_CACHE_LOAD, true);
    }

    public void testReplaceIfOnPrimaryOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.PRIMARY, Flag.SKIP_CACHE_LOAD, false);
    }

    public void testReplaceIfOnPrimaryOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.PRIMARY, Flag.IGNORE_RETURN_VALUES, true);
    }

    public void testReplaceIfOnPrimaryOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.PRIMARY, Flag.IGNORE_RETURN_VALUES, false);
    }

    public void testReplaceIfOnPrimaryOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.PRIMARY, null, true);
    }

    public void testReplaceIfOnPrimaryOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.PRIMARY, null, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceIfOnBackupOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.BACKUP, Flag.SKIP_CACHE_LOAD, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceIfOnBackupOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.BACKUP, Flag.SKIP_CACHE_LOAD, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceIfOnBackupOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.BACKUP, Flag.IGNORE_RETURN_VALUES, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceIfOnBackupOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.BACKUP, Flag.IGNORE_RETURN_VALUES, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceIfOnBackupOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.BACKUP, null, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testReplaceIfOnBackupOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.BACKUP, null, false);
    }

    public void testReplaceIfOnNonOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.NON_OWNER, Flag.SKIP_CACHE_LOAD, true);
    }

    public void testReplaceIfOnNonOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.NON_OWNER, Flag.SKIP_CACHE_LOAD, false);
    }

    public void testReplaceIfOnNonOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.NON_OWNER, Flag.IGNORE_RETURN_VALUES, true);
    }

    public void testReplaceIfOnNonOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.NON_OWNER, Flag.IGNORE_RETURN_VALUES, false);
    }

    public void testReplaceIfOnNonOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.NON_OWNER, null, true);
    }

    public void testReplaceIfOnNonOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REPLACE_IF, Ownership.NON_OWNER, null, false);
    }

    public void testRemoveIfOnPrimaryOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.PRIMARY, Flag.SKIP_CACHE_LOAD, true);
    }

    public void testRemoveIfOnPrimaryOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.PRIMARY, Flag.SKIP_CACHE_LOAD, false);
    }

    public void testRemoveIfOnPrimaryOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.PRIMARY, Flag.IGNORE_RETURN_VALUES, true);
    }

    public void testRemoveIfOnPrimaryOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.PRIMARY, Flag.IGNORE_RETURN_VALUES, false);
    }

    public void testRemoveIfOnPrimaryOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.PRIMARY, null, true);
    }

    public void testRemoveIfOnPrimaryOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.PRIMARY, null, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testRemoveIfOnBackupOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.BACKUP, Flag.SKIP_CACHE_LOAD, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testRemoveIfOnBackupOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.BACKUP, Flag.SKIP_CACHE_LOAD, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testRemoveIfOnBackupOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.BACKUP, Flag.IGNORE_RETURN_VALUES, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testRemoveIfOnBackupOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.BACKUP, Flag.IGNORE_RETURN_VALUES, false);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testRemoveIfOnBackupOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.BACKUP, null, true);
    }

    @InCacheMode(value={CacheMode.DIST_SYNC})
    public void testRemoveIfOnBackupOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.BACKUP, null, false);
    }

    public void testRemoveIfOnNonOwnerWithSkipCacheLoaderShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.NON_OWNER, Flag.SKIP_CACHE_LOAD, true);
    }

    public void testRemoveIfOnNonOwnerWithSkipCacheLoader() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.NON_OWNER, Flag.SKIP_CACHE_LOAD, false);
    }

    public void testRemoveIfOnNonOwnerWithIgnoreReturnValuesShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.NON_OWNER, Flag.IGNORE_RETURN_VALUES, true);
    }

    public void testRemoveIfOnNonOwnerWithIgnoreReturnValues() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.NON_OWNER, Flag.IGNORE_RETURN_VALUES, false);
    }

    public void testRemoveIfOnNonOwnerShared() {
        this.doTest(SHARED_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.NON_OWNER, null, true);
    }

    public void testRemoveIfOnNonOwner() {
        this.doTest(PRIVATE_STORE_CACHE_NAME, ConditionalOperation.REMOVE_IF, Ownership.NON_OWNER, null, false);
    }

    protected static class CacheHelper<K, V> {
        private final Map<Ownership, Cache<K, V>> cacheEnumMap = new EnumMap<Ownership, Cache<K, V>>(Ownership.class);

        private CacheHelper() {
        }

        public boolean addCache(Ownership ownership, Cache<K, V> cache) {
            boolean contains = this.cacheEnumMap.containsKey(ownership);
            if (!contains) {
                this.cacheEnumMap.put(ownership, cache);
            }
            return !contains;
        }

        private Cache<K, V> cache(Ownership ownership) {
            return this.cacheEnumMap.get(ownership);
        }

        private DummyInMemoryStore cacheStore(Ownership ownership) {
            Cache<K, V> cache = this.cache(ownership);
            return cache != null ? (DummyInMemoryStore)TestingUtil.getFirstStore(cache) : null;
        }

        protected long loads(Ownership ownership) {
            Cache<K, V> cache = this.cache(ownership);
            if (cache == null) {
                return 0L;
            }
            AsyncInterceptorChain chain = TestingUtil.extractComponent(cache, AsyncInterceptorChain.class);
            CacheLoaderInterceptor interceptor = (CacheLoaderInterceptor)chain.findInterceptorExtending(CacheLoaderInterceptor.class);
            return interceptor.getCacheLoaderLoads();
        }

        private void resetStats(Ownership ownership) {
            Cache<K, V> cache = this.cache(ownership);
            if (cache == null) {
                return;
            }
            AsyncInterceptorChain chain = TestingUtil.extractComponent(cache, AsyncInterceptorChain.class);
            CacheLoaderInterceptor interceptor = (CacheLoaderInterceptor)chain.findInterceptorExtending(CacheLoaderInterceptor.class);
            interceptor.resetStatistics();
        }
    }

    protected static enum ConditionalOperation {
        PUT_IF_ABSENT{

            @Override
            public <K, V> void execute(Cache<K, V> cache, K key, V value1, V value2) {
                cache.putIfAbsent(key, value2);
            }

            @Override
            public <V> V finalValue(V value1, V value2, boolean skipLoad) {
                return skipLoad ? value2 : value1;
            }
        }
        ,
        REPLACE{

            @Override
            public <K, V> void execute(Cache<K, V> cache, K key, V value1, V value2) {
                cache.replace(key, value2);
            }

            @Override
            public <V> V finalValue(V value1, V value2, boolean skipLoad) {
                return skipLoad ? value1 : value2;
            }
        }
        ,
        REPLACE_IF{

            @Override
            public <K, V> void execute(Cache<K, V> cache, K key, V value1, V value2) {
                cache.replace(key, value1, value2);
            }

            @Override
            public <V> V finalValue(V value1, V value2, boolean skipLoad) {
                return skipLoad ? value1 : value2;
            }
        }
        ,
        REMOVE_IF{

            @Override
            public <K, V> void execute(Cache<K, V> cache, K key, V value1, V value2) {
                cache.remove(key, value1);
            }

            @Override
            public <V> V finalValue(V value1, V value2, boolean skipLoad) {
                return (V)(skipLoad ? value1 : null);
            }
        };


        public abstract <K, V> void execute(Cache<K, V> var1, K var2, V var3, V var4);

        public abstract <V> V finalValue(V var1, V var2, boolean var3);
    }
}

