/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.ConcurrentLoadAndEvictTxTest")
public class ConcurrentLoadAndEvictTxTest
extends SingleCacheManagerTest {
    TransactionManager tm;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder config = this.getDefaultStandaloneCacheConfig(true);
        ((DummyInMemoryStoreConfigurationBuilder)config.memory().size(10L).expiration().wakeUpInterval(10L).persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).build();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(config);
        this.cache = cm.getCache();
        this.tm = TestingUtil.getTransactionManager(this.cache);
        return cm;
    }

    public void testEvictAndTx() throws SystemException, NotSupportedException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
        for (int i = 0; i < 10; ++i) {
            int j;
            this.tm.begin();
            for (j = 0; j < 10; ++j) {
                this.cache.put((Object)String.format("key-%s-%s", i, j), (Object)"value");
            }
            this.tm.commit();
            for (j = 0; j < 10; ++j) {
                assert ("value".equals(this.cache.get((Object)String.format("key-%s-%s", i, j)))) : "Data loss on key " + String.format("key-%s-%s", i, j);
            }
        }
    }
}

