/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="persistence.IgnoreModificationsStoreTest", groups={"functional"}, sequential=true)
@CleanupAfterMethod
public class IgnoreModificationsStoreTest
extends SingleCacheManagerTest {
    DummyInMemoryStore store;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        ((DummyInMemoryStoreConfigurationBuilder)cfg.invocationBatching().enable().persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).ignoreModifications(true);
        return TestCacheManagerFactory.createCacheManager(cfg);
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
    }

    public void testReadOnlyCacheStore() throws PersistenceException {
        TestingUtil.writeToAllStores("k1", "v1", this.cache);
        TestingUtil.writeToAllStores("k2", "v2", this.cache);
        assert (!this.store.contains("k1")) : "READ ONLY - Store should NOT contain k1 key.";
        assert (!this.store.contains("k2")) : "READ ONLY - Store should NOT contain k2 key.";
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert ("v2".equals(this.cache.get((Object)"k2")));
        assert (!this.store.contains("k1")) : "READ ONLY - Store should NOT contain k1 key.";
        assert (!this.store.contains("k2")) : "READ ONLY - Store should NOT contain k2 key.";
        assert (!TestingUtil.deleteFromAllStores("k1", this.cache)) : "READ ONLY - Remove operation should return false (no op)";
        assert (!TestingUtil.deleteFromAllStores("k2", this.cache)) : "READ ONLY - Remove operation should return false (no op)";
        assert (!TestingUtil.deleteFromAllStores("k3", this.cache)) : "READ ONLY - Remove operation should return false (no op)";
        assert ("v1".equals(this.cache.get((Object)"k1")));
        assert ("v2".equals(this.cache.get((Object)"k2")));
        this.cache.remove((Object)"k1");
        this.cache.remove((Object)"k2");
        assert (this.cache.get((Object)"k1") == null);
        assert (this.cache.get((Object)"k2") == null);
    }
}

