/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.eviction.impl.ActivationManager;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.LocalConditionalCommandTest")
public class LocalConditionalCommandTest
extends SingleCacheManagerTest {
    private static final String PRIVATE_STORE_CACHE_NAME = "private-store-cache";
    private static final String SHARED_STORE_CACHE_NAME = "shared-store-cache";
    private final String key = this.getClass().getSimpleName() + "-key";
    private final String value1 = this.getClass().getSimpleName() + "-value1";
    private final String value2 = this.getClass().getSimpleName() + "-value2";
    private final boolean transactional;
    private final boolean passivation;

    public LocalConditionalCommandTest() {
        this(false, false);
    }

    protected LocalConditionalCommandTest(boolean transactional, boolean passivation) {
        this.transactional = transactional;
        this.passivation = passivation;
    }

    private static ConfigurationBuilder createConfiguration(String storeName, boolean shared, boolean transactional, boolean passivation) {
        ConfigurationBuilder builder = LocalConditionalCommandTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, transactional);
        builder.statistics().enable();
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(passivation).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(storeName + (shared ? "-shared" : "-private")).fetchPersistentState(false)).shared(shared);
        builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        return builder;
    }

    @AfterMethod
    public void afterMethod() {
        if (this.passivation) {
            ActivationManager activationManager = TestingUtil.extractComponent(this.cache(PRIVATE_STORE_CACHE_NAME), ActivationManager.class);
            this.eventuallyEquals(0L, () -> ((ActivationManager)activationManager).getPendingActivationCount());
        }
    }

    private static <K, V> void writeToStore(Cache<K, V> cache, K key, V value) {
        MarshallableEntry<K, V> entry = MarshalledEntryUtil.create(key, value, cache);
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        store.write(entry);
    }

    private static CacheLoaderInterceptor cacheLoaderInterceptor(Cache<?, ?> cache) {
        AsyncInterceptorChain chain = TestingUtil.extractComponent(cache, AsyncInterceptorChain.class);
        return (CacheLoaderInterceptor)chain.findInterceptorExtending(CacheLoaderInterceptor.class);
    }

    private void doTest(Cache<String, String> cache, ConditionalOperation operation, Flag flag) {
        this.assertEmpty(cache);
        this.initStore(cache);
        boolean skipLoad = flag == Flag.SKIP_CACHE_LOAD || flag == Flag.SKIP_CACHE_STORE;
        try {
            if (flag != null) {
                operation.execute(cache.getAdvancedCache().withFlags(flag), this.key, this.value1, this.value2);
            } else {
                operation.execute(cache, this.key, this.value1, this.value2);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        this.assertLoadAfterOperation(cache, skipLoad);
        AssertJUnit.assertEquals((String)operation.finalValue(this.value1, this.value2, skipLoad), (String)((String)cache.get((Object)this.key)));
    }

    private void assertLoadAfterOperation(Cache<?, ?> cache, boolean skipLoad) {
        AssertJUnit.assertEquals((String)"cache load", (long)(skipLoad ? 0L : 1L), (long)LocalConditionalCommandTest.cacheLoaderInterceptor(cache).getCacheLoaderLoads());
    }

    private void assertEmpty(Cache<?, ?> cache) {
        AssertJUnit.assertTrue((String)(cache + ".isEmpty()"), (boolean)cache.isEmpty());
    }

    private void initStore(Cache<String, String> cache) {
        LocalConditionalCommandTest.writeToStore(cache, this.key, this.value1);
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
        AssertJUnit.assertTrue((boolean)store.contains(this.key));
        LocalConditionalCommandTest.cacheLoaderInterceptor(cache).resetStatistics();
    }

    public void testPutIfAbsentWithSkipCacheLoader() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.PUT_IF_ABSENT, Flag.SKIP_CACHE_LOAD);
    }

    public void testPutIfAbsentWithIgnoreReturnValues() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.PUT_IF_ABSENT, Flag.IGNORE_RETURN_VALUES);
    }

    public void testPutIfAbsent() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.PUT_IF_ABSENT, null);
    }

    public void testReplaceWithSkipCacheLoader() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.REPLACE, Flag.SKIP_CACHE_LOAD);
    }

    public void testReplaceWithIgnoreReturnValues() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.REPLACE, Flag.IGNORE_RETURN_VALUES);
    }

    public void testReplace() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.REPLACE, null);
    }

    public void testReplaceIfWithSkipCacheLoader() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.REPLACE_IF, Flag.SKIP_CACHE_LOAD);
    }

    public void testReplaceIfWithIgnoreReturnValues() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.REPLACE_IF, Flag.IGNORE_RETURN_VALUES);
    }

    public void testReplaceIf() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.REPLACE_IF, null);
    }

    public void testRemoveIfWithSkipCacheLoader() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.REMOVE_IF, Flag.SKIP_CACHE_LOAD);
    }

    public void testRemoveIfWithIgnoreReturnValues() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.REMOVE_IF, Flag.IGNORE_RETURN_VALUES);
    }

    public void testRemoveIf() {
        this.doTest(this.cache(PRIVATE_STORE_CACHE_NAME), ConditionalOperation.REMOVE_IF, null);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager embeddedCacheManager = TestCacheManagerFactory.createClusteredCacheManager();
        embeddedCacheManager.defineConfiguration(PRIVATE_STORE_CACHE_NAME, LocalConditionalCommandTest.createConfiguration(this.getClass().getSimpleName(), false, this.transactional, this.passivation).build());
        if (!this.passivation) {
            embeddedCacheManager.defineConfiguration(SHARED_STORE_CACHE_NAME, LocalConditionalCommandTest.createConfiguration(this.getClass().getSimpleName(), true, this.transactional, false).build());
        }
        return embeddedCacheManager;
    }

    private static enum ConditionalOperation {
        PUT_IF_ABSENT{

            @Override
            public <K, V> void execute(Cache<K, V> cache, K key, V value1, V value2) {
                cache.putIfAbsent(key, value2);
            }

            @Override
            public <V> V finalValue(V value1, V value2, boolean skipLoad) {
                return skipLoad ? value2 : value1;
            }
        }
        ,
        REPLACE{

            @Override
            public <K, V> void execute(Cache<K, V> cache, K key, V value1, V value2) {
                cache.replace(key, value2);
            }

            @Override
            public <V> V finalValue(V value1, V value2, boolean skipLoad) {
                return skipLoad ? value1 : value2;
            }
        }
        ,
        REPLACE_IF{

            @Override
            public <K, V> void execute(Cache<K, V> cache, K key, V value1, V value2) {
                cache.replace(key, value1, value2);
            }

            @Override
            public <V> V finalValue(V value1, V value2, boolean skipLoad) {
                return skipLoad ? value1 : value2;
            }
        }
        ,
        REMOVE_IF{

            @Override
            public <K, V> void execute(Cache<K, V> cache, K key, V value1, V value2) {
                cache.remove(key, value1);
            }

            @Override
            public <V> V finalValue(V value1, V value2, boolean skipLoad) {
                return (V)(skipLoad ? value1 : null);
            }
        };


        public abstract <K, V> void execute(Cache<K, V> var1, K var2, V var3, V var4);

        public abstract <V> V finalValue(V var1, V var2, boolean var3);
    }
}

