/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.encoding.DataConversion;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.LocalModePassivationTest")
@CleanupAfterMethod
public class LocalModePassivationTest
extends SingleCacheManagerTest {
    private final boolean passivationEnabled;

    protected LocalModePassivationTest() {
        this.passivationEnabled = true;
    }

    protected LocalModePassivationTest(boolean passivationEnabled) {
        this.passivationEnabled = passivationEnabled;
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = LocalModePassivationTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, true, true);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).memory().storageType(StorageType.BINARY).size(150L).locking().useLockStriping(false).isolationLevel(IsolationLevel.READ_COMMITTED).persistence().passivation(this.passivationEnabled).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(this.getClass().getName()).fetchPersistentState(true)).ignoreModifications(false)).preload(false)).purgeOnStartup(false);
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    public void testStoreAndLoad() throws Exception {
        int numKeys = 300;
        for (int i = 0; i < 300; ++i) {
            this.cache().put((Object)i, (Object)i);
        }
        int keysInDataContainer = this.cache().getAdvancedCache().getDataContainer().size();
        AssertJUnit.assertTrue((keysInDataContainer != 300 ? 1 : 0) != 0);
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache());
        long keysInCacheStore = store.size();
        if (this.passivationEnabled) {
            AssertJUnit.assertEquals((long)300L, (long)((long)keysInDataContainer + keysInCacheStore));
        } else {
            AssertJUnit.assertEquals((long)300L, (long)keysInCacheStore);
        }
        this.cache().stop();
        this.cache().start();
        store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache());
        AssertJUnit.assertEquals((long)300L, (long)store.size());
        for (int i = 0; i < 300; ++i) {
            AssertJUnit.assertEquals((Object)i, (Object)this.cache().get((Object)i));
        }
    }

    public void testSizeWithEvictedEntries() {
        int numKeys = 300;
        for (int i = 0; i < 300; ++i) {
            this.cache.put((Object)i, (Object)i);
        }
        AssertJUnit.assertFalse((String)"Data Container should not have all keys", (300 == this.cache.getAdvancedCache().getDataContainer().size() ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)300, (int)this.cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).size());
    }

    public void testSizeWithEvictedEntriesAndFlags() {
        int numKeys = 300;
        for (int i = 0; i < 300; ++i) {
            this.cache.put((Object)i, (Object)i);
        }
        AssertJUnit.assertFalse((String)"Data Container should not have all keys", (300 == this.cache.getAdvancedCache().getDataContainer().size() ? 1 : 0) != 0);
        AssertJUnit.assertEquals((int)this.cache.getAdvancedCache().getDataContainer().size(), (int)this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).size());
        AssertJUnit.assertEquals((int)300, (int)this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).size());
    }

    public void testKeySetWithEvictedEntries() {
        int numKeys = 300;
        for (int i = 0; i < 300; ++i) {
            this.cache.put((Object)i, (Object)i);
        }
        AssertJUnit.assertFalse((String)"Data Container should not have all keys", (300 == this.cache.getAdvancedCache().getDataContainer().size() ? 1 : 0) != 0);
        CacheSet keySet = this.cache.keySet();
        for (int i = 0; i < 300; ++i) {
            AssertJUnit.assertTrue((String)("Key: " + i + " was not found!"), (boolean)keySet.contains(i));
        }
    }

    public void testKeySetWithEvictedEntriesAndFlags() {
        int numKeys = 300;
        for (int i = 0; i < 300; ++i) {
            this.cache.put((Object)i, (Object)i);
        }
        AdvancedCache flagCache = this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        DataContainer dc = flagCache.getDataContainer();
        AssertJUnit.assertFalse((String)"Data Container should not have all keys", (300 == dc.size() ? 1 : 0) != 0);
        CacheSet keySet = flagCache.keySet();
        AssertJUnit.assertEquals((int)dc.size(), (int)keySet.size());
        DataConversion conversion = flagCache.getValueDataConversion();
        for (InternalCacheEntry entry : dc) {
            Object key = entry.getKey();
            AssertJUnit.assertTrue((String)("Key: " + key + " was not found!"), (boolean)keySet.contains(conversion.fromStorage(key)));
        }
    }

    public void testEntrySetWithEvictedEntries() {
        int numKeys = 300;
        for (int i = 0; i < 300; ++i) {
            this.cache.put((Object)i, (Object)i);
        }
        AssertJUnit.assertFalse((String)"Data Container should not have all keys", (300 == this.cache.getAdvancedCache().getDataContainer().size() ? 1 : 0) != 0);
        CacheSet entrySet = this.cache.entrySet();
        AssertJUnit.assertEquals((int)300, (int)entrySet.size());
        HashMap map = new HashMap(entrySet.size());
        for (Map.Entry entry : entrySet) {
            map.put(entry.getKey(), entry.getValue());
        }
        for (int i = 0; i < 300; ++i) {
            AssertJUnit.assertEquals((String)"Key/Value mismatch!", (Object)i, map.get(i));
        }
    }

    public void testEntrySetWithEvictedEntriesAndFlags() {
        int numKeys = 300;
        for (int i = 0; i < 300; ++i) {
            this.cache.put((Object)i, (Object)i);
        }
        AdvancedCache flagCache = this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        DataContainer dc = flagCache.getDataContainer();
        AssertJUnit.assertFalse((String)"Data Container should not have all keys", (300 == dc.size() ? 1 : 0) != 0);
        CacheSet entrySet = flagCache.entrySet();
        AssertJUnit.assertEquals((int)dc.size(), (int)entrySet.size());
        DataConversion keyDataConversion = flagCache.getAdvancedCache().getKeyDataConversion();
        DataConversion valueDataConversion = flagCache.getAdvancedCache().getValueDataConversion();
        HashMap<WrappedByteArray, WrappedByteArray> map = new HashMap<WrappedByteArray, WrappedByteArray>(entrySet.size());
        for (Map.Entry entry : entrySet) {
            WrappedByteArray storedKey = (WrappedByteArray)keyDataConversion.toStorage(entry.getKey());
            WrappedByteArray storedValue = (WrappedByteArray)valueDataConversion.toStorage(entry.getValue());
            map.put(storedKey, storedValue);
        }
        for (Map.Entry entry : dc) {
            AssertJUnit.assertEquals((String)"Key/Value mismatch!", (Object)entry.getValue(), map.get(entry.getKey()));
        }
    }

    public void testValuesWithEvictedEntries() {
        int numKeys = 300;
        for (int i = 0; i < 300; ++i) {
            this.cache.put((Object)i, (Object)i);
        }
        AssertJUnit.assertFalse((String)"Data Container should not have all keys", (300 == this.cache.getAdvancedCache().getDataContainer().size() ? 1 : 0) != 0);
        CacheCollection values = this.cache.values();
        for (int i = 0; i < 300; ++i) {
            AssertJUnit.assertTrue((String)("Value: " + i + " was not found!"), (boolean)values.contains(i));
        }
    }

    public void testValuesWithEvictedEntriesAndFlags() {
        int numKeys = 300;
        for (int i = 0; i < 300; ++i) {
            this.cache.put((Object)i, (Object)i);
        }
        AdvancedCache flagCache = this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
        DataContainer dc = flagCache.getDataContainer();
        AssertJUnit.assertFalse((String)"Data Container should not have all keys", (300 == dc.size() ? 1 : 0) != 0);
        CacheCollection values = flagCache.values();
        AssertJUnit.assertEquals((int)dc.size(), (int)values.size());
        for (InternalCacheEntry entry : dc) {
            Object dcValue = entry.getValue();
            DataConversion valueDataConversion = flagCache.getValueDataConversion();
            AssertJUnit.assertTrue((String)("Value: " + dcValue + " was not found!"), (boolean)values.contains(valueDataConversion.fromStorage(dcValue)));
        }
    }

    public void testStoreAndLoadWithGetEntry() {
        int numKeys = 300;
        for (int i = 0; i < 300; ++i) {
            this.cache().put((Object)i, (Object)i);
        }
        int keysInDataContainer = this.cache().getAdvancedCache().getDataContainer().size();
        AssertJUnit.assertTrue((keysInDataContainer != 300 ? 1 : 0) != 0);
        DummyInMemoryStore dims = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache());
        long keysInCacheStore = dims.size();
        if (this.passivationEnabled) {
            AssertJUnit.assertEquals((long)300L, (long)((long)keysInDataContainer + keysInCacheStore));
        } else {
            AssertJUnit.assertEquals((long)300L, (long)keysInCacheStore);
        }
        this.cache().stop();
        this.cache().start();
        dims = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache());
        AssertJUnit.assertEquals((long)300L, (long)dims.size());
        for (int i = 0; i < 300; ++i) {
            AssertJUnit.assertEquals((Object)i, (Object)this.cache.getAdvancedCache().getCacheEntry((Object)i).getValue());
        }
    }
}

