/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(testName="persistence.PassivatePersistentTest", groups={"functional"})
public class PassivatePersistentTest
extends AbstractInfinispanTest {
    Cache<String, String> cache;
    DummyInMemoryStore store;
    TransactionManager tm;
    ConfigurationBuilder cfg;
    CacheContainer cm;

    @BeforeMethod
    public void setUp() {
        this.cfg = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)this.cfg.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(this.getClass().getName()).purgeOnStartup(false);
        this.cm = TestCacheManagerFactory.createCacheManager(this.cfg);
        this.cache = this.cm.getCache();
        this.store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        this.tm = TestingUtil.getTransactionManager(this.cache);
    }

    @AfterMethod
    public void tearDown() throws PersistenceException {
        this.store.clear();
        TestingUtil.killCacheManagers(this.cm);
    }

    public void testPersistence() throws PersistenceException {
        this.cache.put((Object)"k", (Object)"v");
        assert ("v".equals(this.cache.get((Object)"k")));
        this.cache.evict((Object)"k");
        assert (this.store.contains("k"));
        assert ("v".equals(this.cache.get((Object)"k")));
        this.eventually(() -> !this.store.contains("k"));
        this.cache.stop();
        this.cache.start();
        this.store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        assert (this.store.contains("k"));
        assert ("v".equals(this.cache.get((Object)"k")));
        this.eventually(() -> !this.store.contains("k"));
    }
}

