/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.manager.CacheContainer;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.PassivationFunctionalTest")
public class PassivationFunctionalTest
extends AbstractInfinispanTest {
    Cache<String, String> cache;
    DummyInMemoryStore store;
    TransactionManager tm;
    ConfigurationBuilder cfg;
    CacheContainer cm;
    long lifespan = 6000000L;

    @BeforeClass
    public void setUp() {
        this.cfg = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        this.cfg.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class);
        this.cm = TestCacheManagerFactory.createCacheManager(this.cfg);
        this.cache = this.cm.getCache();
        this.store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.cache);
        this.tm = TestingUtil.getTransactionManager(this.cache);
    }

    @AfterClass
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cm);
    }

    @AfterMethod
    public void afterMethod() throws PersistenceException {
        if (this.cache != null) {
            this.cache.clear();
        }
        if (this.store != null) {
            this.store.clear();
        }
    }

    private void assertInCacheNotInStore(Object key, Object value) throws PersistenceException {
        this.assertInCacheNotInStore(key, value, -1L);
    }

    private void assertInCacheNotInStore(Object key, Object value, long lifespanMillis) throws PersistenceException {
        InternalCacheValue se = this.cache.getAdvancedCache().getDataContainer().get(key).toInternalCacheValue();
        this.testStoredEntry(se, value, lifespanMillis, "Cache", key);
        this.eventually(() -> !this.store.contains(key));
    }

    private void assertInStoreNotInCache(Object key, Object value) throws PersistenceException {
        this.assertInStoreNotInCache(key, value, -1L);
    }

    private void assertInStoreNotInCache(Object key, Object value, long lifespanMillis) throws PersistenceException {
        MarshallableEntry se = this.store.loadEntry(key);
        this.testStoredEntry(se, value, lifespanMillis, "Store", key);
        assert (!this.cache.getAdvancedCache().getDataContainer().containsKey(key)) : "Key " + key + " should not be in cache!";
    }

    private void testStoredEntry(InternalCacheValue entry, Object expectedValue, long expectedLifespan, String src, Object key) {
        assert (entry != null) : src + " entry for key " + key + " should NOT be null";
        assert (entry.getValue().equals(expectedValue)) : src + " should contain value " + expectedValue + " under key " + key + " but was " + entry.getValue() + ". Entry is " + entry;
        assert (entry.getLifespan() == expectedLifespan) : src + " expected lifespan for key " + key + " to be " + expectedLifespan + " but was " + entry.getLifespan() + ". Entry is " + entry;
    }

    private void testStoredEntry(MarshallableEntry entry, Object expectedValue, long expectedLifespan, String src, Object key) {
        assert (entry != null) : src + " entry for key " + key + " should NOT be null";
        assert (entry.getValue().equals(expectedValue)) : src + " should contain value " + expectedValue + " under key " + key + " but was " + entry.getValue() + ". Entry is " + entry;
        if (expectedLifespan > -1L) assert (entry.getMetadata().lifespan() == expectedLifespan) : src + " expected lifespan for key " + key + " to be " + expectedLifespan + " but was " + entry.getMetadata().lifespan() + ". Entry is " + entry;
    }

    private void assertNotInCacheAndStore(Object ... keys) throws PersistenceException {
        for (Object key : keys) {
            assert (!this.cache.getAdvancedCache().getDataContainer().containsKey(key)) : "Cache should not contain key " + key;
            assert (!this.store.contains(key)) : "Store should not contain key " + key;
        }
    }

    public void testPassivate() throws PersistenceException {
        this.assertNotInCacheAndStore("k1", "k2");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.cache.evict((Object)"k1");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k1", "v1");
        this.assertInStoreNotInCache("k2", "v2", this.lifespan);
        assert (((String)this.cache.get((Object)"k1")).equals("v1"));
        assert (((String)this.cache.get((Object)"k2")).equals("v2"));
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.cache.evict((Object)"k1");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k1", "v1");
        this.assertInStoreNotInCache("k2", "v2", this.lifespan);
    }

    public void testRemoveAndReplace() throws PersistenceException {
        this.assertNotInCacheAndStore("k1", "k2");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.cache.evict((Object)"k1");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k1", "v1");
        this.assertInStoreNotInCache("k2", "v2", this.lifespan);
        assert (((String)this.cache.remove((Object)"k1")).equals("v1"));
        this.assertNotInCacheAndStore("k1");
        assert (((String)this.cache.put((Object)"k2", (Object)"v2-NEW")).equals("v2"));
        this.assertInCacheNotInStore("k2", "v2-NEW");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k2", "v2-NEW");
        assert (((String)this.cache.replace((Object)"k2", (Object)"v2-REPLACED")).equals("v2-NEW"));
        this.assertInCacheNotInStore("k2", "v2-REPLACED");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k2", "v2-REPLACED");
        assert (!this.cache.replace((Object)"k2", (Object)"some-rubbish", (Object)"v2-SHOULDNT-STORE"));
        this.assertInCacheNotInStore("k2", "v2-REPLACED");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k2", "v2-REPLACED");
        assert (this.cache.replace((Object)"k2", (Object)"v2-REPLACED", (Object)"v2-REPLACED-AGAIN"));
        this.assertInCacheNotInStore("k2", "v2-REPLACED-AGAIN");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k2", "v2-REPLACED-AGAIN");
        assert (((String)this.cache.putIfAbsent((Object)"k2", (Object)"should-not-appear")).equals("v2-REPLACED-AGAIN"));
        this.assertInCacheNotInStore("k2", "v2-REPLACED-AGAIN");
        assert (this.cache.putIfAbsent((Object)"k1", (Object)"v1-if-absent") == null);
        this.assertInCacheNotInStore("k1", "v1-if-absent");
    }

    public void testTransactions() throws Exception {
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        Transaction t = this.tm.suspend();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.resume(t);
        this.tm.commit();
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.tm.begin();
        this.cache.remove((Object)"k1");
        this.cache.remove((Object)"k2");
        t = this.tm.suspend();
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.tm.resume(t);
        this.tm.commit();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.begin();
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        t = this.tm.suspend();
        this.assertNotInCacheAndStore("k1", "k2");
        this.tm.resume(t);
        this.tm.rollback();
        this.assertNotInCacheAndStore("k1", "k2");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2", this.lifespan, TimeUnit.MILLISECONDS);
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInCacheNotInStore("k2", "v2", this.lifespan);
        this.cache.evict((Object)"k1");
        this.cache.evict((Object)"k2");
        this.assertInStoreNotInCache("k1", "v1");
        this.assertInStoreNotInCache("k2", "v2", this.lifespan);
    }

    public void testPutMap() throws PersistenceException {
        this.assertNotInCacheAndStore("k1", "k2", "k3");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        this.cache.evict((Object)"k2");
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInStoreNotInCache("k2", "v2");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("k1", "v1-NEW");
        m.put("k2", "v2-NEW");
        m.put("k3", "v3-NEW");
        this.cache.putAll(m);
        this.assertInCacheNotInStore("k1", "v1-NEW");
        this.assertInCacheNotInStore("k2", "v2-NEW");
        this.assertInCacheNotInStore("k3", "v3-NEW");
    }

    public void testClear() {
        this.assertNotInCacheAndStore("k1", "k2", "k3");
        this.cache.put((Object)"k1", (Object)"v1");
        this.cache.put((Object)"k2", (Object)"v2");
        this.cache.evict((Object)"k2");
        this.assertInCacheNotInStore("k1", "v1");
        this.assertInStoreNotInCache("k2", "v2");
        this.cache.clear();
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
    }
}

